/*
 * Decompiled with CFR 0.152.
 */
package matrix.deck.eai;

import java.util.Enumeration;
import java.util.Vector;
import matrix.deck.ConsumerException;
import matrix.deck.Network;
import matrix.deck.RealTimeConsumer;
import matrix.deck.eai.Beta;
import matrix.deck.eai.Gate;
import matrix.deck.eai.Route;
import matrix.deck.eai.SO;
import matrix.vrml.Field;
import vrml.external.Browser;
import vrml.external.Node;
import vrml.external.field.EventInSFBool;
import vrml.external.field.EventOutMFFloat;
import vrml.external.field.EventOutMFNode;

public class WorldObject
implements RealTimeConsumer {
    private String name;
    private Node root = null;
    private Node proxy;
    private Network postOffice;
    private Vector states = new Vector();
    private float offset;
    private Vector gates = new Vector();

    public WorldObject(SO object, Browser browser, Network postOffice, Beta beta, int vpIndex) throws ConsumerException {
        Node[] trans;
        this.name = object.getName();
        this.postOffice = postOffice;
        Node xform = object.getTransform();
        Node[] nodes = ((EventOutMFNode)xform.getEventOut("children_changed")).getValue();
        if (nodes == null) {
            System.out.println(String.valueOf(this.name) + " nodes not loaded !");
            return;
        }
        this.offset = 1.6f;
        boolean viewBound = false;
        boolean fogBound = false;
        boolean backBound = false;
        boolean infoBound = false;
        Node infoNode = null;
        try {
            trans = ((EventOutMFNode)object.getTransform().getEventOut("children_changed")).getValue();
        }
        catch (Exception e) {
            System.out.println("PANIC : can't get world nodes " + e);
            throw new ConsumerException("Error accessing loaded world !");
        }
        int i = 0;
        while (i < trans.length) {
            if (trans[i].getType().equals("Group")) {
                infoNode = trans[i];
                break;
            }
            ++i;
        }
        if (infoNode == null) {
            System.err.println("PANIC : Couldn't get Info node !");
            throw new ConsumerException("Loaded world format is wrong !");
        }
        trans = ((EventOutMFNode)infoNode.getEventOut("children")).getValue();
        System.out.println("Parsing world : " + trans.length + " children ");
        if (vpIndex > 0) {
            vpIndex -= 2;
        }
        i = 0;
        while (i < trans.length) {
            System.out.println("Node " + i + " " + trans[i].getType());
            if (trans[i].getType().equals("ProximitySensor")) {
                this.proxy = trans[i];
            } else if (trans[i].getType().startsWith("Network")) {
                Route route = new Route(trans[i], postOffice);
                route.setName(String.valueOf(this.name) + "_" + route.getName());
                this.states.addElement(route);
                postOffice.addConsumer(route);
            } else if (trans[i].getType().equals("Matrix_Gate")) {
                this.gates.addElement(new Gate(trans[i], beta));
            } else if (trans[i].getType().equals("Viewpoint")) {
                if (!viewBound) {
                    if (vpIndex == -1) {
                        ((EventInSFBool)trans[i].getEventIn("set_bind")).setValue(true);
                        viewBound = true;
                    } else {
                        --vpIndex;
                    }
                }
            } else if (trans[i].getType().equals("Fog")) {
                if (!fogBound) {
                    ((EventInSFBool)trans[i].getEventIn("set_bind")).setValue(true);
                    fogBound = true;
                }
            } else if (trans[i].getType().equals("Background")) {
                if (!backBound) {
                    ((EventInSFBool)trans[i].getEventIn("set_bind")).setValue(true);
                    backBound = true;
                }
            } else if (trans[i].getType().equals("NavigationInfo")) {
                if (!infoBound) {
                    ((EventInSFBool)trans[i].getEventIn("set_bind")).setValue(true);
                    float[] help = ((EventOutMFFloat)trans[i].getEventOut("avatarSize")).getValue();
                    this.offset = help[1];
                    infoBound = true;
                }
            } else {
                System.out.println("Hickup with " + i + "th node " + trans[i].getType());
            }
            ++i;
        }
    }

    public float getOffset() {
        return this.offset;
    }

    public Node getProxy() {
        return this.proxy;
    }

    public String getName() {
        return this.name;
    }

    public void handleMessage(String tag, Field data) throws ConsumerException {
        throw new ConsumerException("WorldObject should not receive any messages !");
    }

    public void update() {
        Enumeration list = this.states.elements();
        while (list.hasMoreElements()) {
            ((RealTimeConsumer)list.nextElement()).update();
        }
    }

    public void delete() throws RuntimeException {
        Enumeration list = this.states.elements();
        while (list.hasMoreElements()) {
            this.postOffice.removeConsumer(((RealTimeConsumer)list.nextElement()).getName());
        }
        this.states.removeAllElements();
    }
}

