/*
 * Decompiled with CFR 0.152.
 */
package matrix.server;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class Log {
    PrintWriter m_writer = null;
    Date date = new Date();
    DateFormat df = DateFormat.getDateTimeInstance(3, 2);
    final int BUFFERSIZE = 4096;

    public Log(String fileName) {
        try {
            this.m_writer = fileName == null || fileName.equals("-") ? new PrintWriter(new BufferedOutputStream(System.out, 4096)) : new PrintWriter(new BufferedOutputStream(new FileOutputStream(fileName, true), 4096));
            this.m_writer.println("------------------------ New session ------------------------");
            this.m_writer.println(String.valueOf(this.df.format(this.date)) + " logging started into file " + fileName);
            this.m_writer.flush();
        }
        catch (Exception e) {
            System.err.println("Could not open file " + fileName + " for logging");
            this.m_writer = new PrintWriter(System.err);
        }
    }

    public synchronized void close() {
        try {
            this.m_writer.flush();
            this.m_writer.close();
        }
        catch (Exception e) {
            System.err.println("Error closing log file");
        }
    }

    public synchronized String println(String msg) {
        try {
            this.date.setTime(System.currentTimeMillis());
            this.m_writer.println(String.valueOf(this.df.format(this.date)) + " " + Thread.currentThread().getName() + " : " + msg);
            this.m_writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msg;
    }
}

