/*
 * Decompiled with CFR 0.152.
 */
package matrix.server;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import matrix.server.Log;
import matrix.server.Room;
import matrix.server.RoomManager;
import matrix.server.ServerThread;
import matrix.sip.server.ServerSipController;

public class MatrixD
extends Thread {
    private static final int PORT = 6666;
    private int logLevel = 0;
    private int conQueue = 30;
    private boolean levelread = false;
    private boolean portread = false;
    private String startRoom = null;
    private String rcfile = "matrixrc";
    private String logfile = "matrix.log";
    private String serverip = null;
    private int newID = 1;
    private Log log;
    protected int port = 6666;
    protected ServerSocket Listener;
    protected Hashtable Threads;
    protected Hashtable Rooms;
    protected Hashtable Objects;
    ServerSipController serverSipController;

    public MatrixD(String[] args) {
        super("Matrix");
        int i = 0;
        System.out.println("DeepMatrix Server V1.2 starting up ...");
        while (i < args.length && args[i].startsWith("-")) {
            String arg;
            if ((arg = args[i++]).equals("-port")) {
                if (i < args.length) {
                    try {
                        this.port = Integer.parseInt(args[i++]);
                        this.portread = true;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("error converting port number " + e);
                        this.port = 6666;
                    }
                    continue;
                }
                MatrixD.usage();
                continue;
            }
            if (arg.equals("-loglevel")) {
                if (i < args.length) {
                    try {
                        this.logLevel = Integer.parseInt(args[i++]);
                        if (this.logLevel < 0 && this.logLevel > 3) {
                            MatrixD.usage();
                        }
                        this.levelread = true;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("error converting loglevel " + e);
                        this.logLevel = 0;
                    }
                    continue;
                }
                MatrixD.usage();
                continue;
            }
            if (!arg.equals("-rcfile")) continue;
            if (i < args.length) {
                this.rcfile = args[i++];
                continue;
            }
            MatrixD.usage();
        }
        this.Rooms = new Hashtable();
        this.Threads = new Hashtable();
        this.Objects = new Hashtable();
        this.loadInit(this.rcfile);
        if (this.port == 0) {
            this.port = 6666;
        }
        try {
            this.Listener = this.serverip == null ? new ServerSocket(this.port, this.conQueue) : new ServerSocket(this.port, this.conQueue, InetAddress.getByName(this.serverip));
        }
        catch (IOException e) {
            MatrixD.fail(e, "Could not open socket");
        }
        this.log = new Log(this.logfile);
        this.log("MatrixD listening on " + this.Listener.getInetAddress() + ":" + this.port, 1);
        this.serverSipController = new ServerSipController(this);
        this.serverSipController.start();
        this.start();
    }

    public void run() {
        while (true) {
            try {
                Socket con = this.Listener.accept();
                new ServerThread(this, this.startRoom, con);
                continue;
            }
            catch (IOException e) {
                this.log("Error while listening :" + e, 1);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        new MatrixD(args);
    }

    public boolean Check(String name, String passwd) {
        Enumeration th = this.Threads.elements();
        while (th.hasMoreElements()) {
            if (!((ServerThread)th.nextElement()).getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public synchronized int addThread(ServerThread th) {
        Integer id = new Integer(this.newID);
        ++this.newID;
        while (this.Threads.containsKey(id)) {
            id = new Integer(this.newID++);
        }
        this.Threads.put(id, th);
        return id;
    }

    public void loadInit(String file) {
        BufferedReader fin = null;
        int index = 1;
        try {
            try {
                fin = new BufferedReader(new FileReader(file));
                String line = fin.readLine();
                while (line != null) {
                    StringTokenizer token;
                    String keyword;
                    if (line.length() > 0 && (keyword = (token = new StringTokenizer(line, " ")).nextToken()).charAt(0) != '#') {
                        String lower = keyword.toLowerCase();
                        if (lower.equals("loglevel") && !this.levelread) {
                            this.logLevel = Integer.parseInt(token.nextToken());
                        } else if (lower.equals("port") && !this.portread) {
                            this.port = Integer.parseInt(token.nextToken());
                        } else if (lower.equals("logfile")) {
                            this.logfile = token.nextToken();
                        } else if (lower.equals("serverip")) {
                            this.serverip = token.nextToken();
                        } else if (lower.equals("waitingconnections")) {
                            this.conQueue = Integer.parseInt(token.nextToken());
                        } else {
                            try {
                                String roomName = keyword;
                                String roomURL = token.nextToken();
                                int maxNumber = 0;
                                if (token.hasMoreTokens()) {
                                    try {
                                        maxNumber = Integer.parseInt(token.nextToken());
                                    }
                                    catch (NumberFormatException e) {
                                        System.err.println("Error parsing " + file + " : " + line + "\n\t" + e);
                                        maxNumber = 0;
                                    }
                                }
                                boolean multible = false;
                                if (maxNumber > 0 && token.hasMoreTokens()) {
                                    multible = Boolean.valueOf(token.nextToken());
                                }
                                if (this.Rooms.containsKey(roomName)) {
                                    System.err.println(String.valueOf(roomName) + " is allready defined!");
                                } else {
                                    this.Rooms.put(roomName, new RoomManager(this, roomName, roomURL, maxNumber, multible));
                                    if (this.startRoom == null) {
                                        this.startRoom = roomName;
                                    }
                                }
                            }
                            catch (NoSuchElementException e) {
                                System.err.println("Error parsing " + file + " : " + line + "\n\t" + e);
                            }
                        }
                    }
                    line = fin.readLine();
                    ++index;
                }
            }
            catch (Exception e) {
                MatrixD.fail(e, "Error reading " + file + " in line " + index);
            }
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public Room enterRoom(ServerThread thread, String roomName) throws Exception {
        RoomManager help;
        if (roomName.lastIndexOf(35) != -1) {
            roomName = roomName.substring(0, roomName.lastIndexOf(35));
        }
        if ((help = (RoomManager)this.Rooms.get(roomName)) == null) {
            throw new Exception("No room of name " + roomName + " known !");
        }
        Room ret = help.addUser(thread);
        if (ret == null) {
            throw new Exception("Maximum number of users for room " + roomName + " reached !");
        }
        return ret;
    }

    public void leaveRoom(ServerThread thread, Room room) throws Exception {
        RoomManager help = (RoomManager)this.Rooms.get(room.getName());
        if (help == null) {
            throw new Exception("No room of name " + room.getName() + " known !");
        }
        help.removeUser(thread, room);
    }

    public static void fail(Throwable e, String msg) {
        System.err.println("MatrixD " + msg + ":" + e);
        System.exit(1);
    }

    public void log(String msg, int level) {
        if (level <= this.logLevel) {
            this.log.println(msg);
        }
    }

    public static void usage() {
        System.err.println("Usage : java matrix.server.MatrixD [-port portnumber] [-loglevel level] [-rcfile name]");
        System.err.println("        level between 0 and 3");
        System.exit(1);
    }
}

