/*
 * Decompiled with CFR 0.152.
 */
package matrix.server;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import matrix.ControlMessage;
import matrix.Message;
import matrix.server.MatrixD;
import matrix.server.ServerThread;

public class Room {
    private Vector listeners;
    private Hashtable objects;
    private MatrixD parent;
    private String wrlUrl;
    private String name;

    public Room(MatrixD par, String na, String wrl) {
        this.parent = par;
        this.wrlUrl = wrl;
        this.name = na;
        this.listeners = new Vector();
        this.objects = new Hashtable();
    }

    public String getWrl() {
        return this.wrlUrl;
    }

    public void setWrl(String wrl) {
        this.wrlUrl = wrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public synchronized void addUser(ServerThread user) {
        this.listeners.addElement(user);
    }

    public synchronized void removeUser(ServerThread user) {
        this.listeners.removeElement(user);
        if (this.countUsers() > 0) {
            String[] help = this.Whois();
            StringBuffer sb = new StringBuffer(help[0]);
            int i = 1;
            while (i < help.length) {
                sb.append(" " + help[i]);
                ++i;
            }
            this.postToAll(new ControlMessage(800, "", sb.toString()));
        }
    }

    public int countUsers() {
        return this.listeners.size();
    }

    public synchronized void update(ServerThread user) {
        Enumeration names = this.objects.keys();
        ControlMessage msg = new ControlMessage();
        msg.command = 200;
        while (names.hasMoreElements()) {
            msg.name = (String)names.nextElement();
            msg.arg = (String)this.objects.get(msg.name);
            try {
                user.sendMessage(msg);
            }
            catch (IOException e) {
                this.parent.log(String.valueOf(this.name) + " to " + user.getName() + " " + e, 1);
            }
        }
    }

    public synchronized void updateRoutes(ServerThread user) {
        Enumeration usr = this.listeners.elements();
        ServerThread updater = null;
        while (usr.hasMoreElements()) {
            updater = (ServerThread)usr.nextElement();
            if (updater == user) continue;
            ControlMessage help = new ControlMessage(600, "world", "");
            try {
                updater.sendMessage(help);
            }
            catch (IOException e) {
                this.parent.log(String.valueOf(this.name) + " update to " + updater.getName() + " " + e, 1);
            }
            break;
        }
    }

    public synchronized boolean addObject(ServerThread sender, String name, String url) {
        if (this.objects.containsKey(name)) {
            return false;
        }
        this.objects.put(name, url);
        ControlMessage msg = new ControlMessage(200, name, url);
        this.postToAllBut(sender, msg);
        return true;
    }

    public synchronized void deleteObject(ServerThread sender, String name) {
        if (this.objects.containsKey(name)) {
            this.objects.remove(name);
            ControlMessage msg = new ControlMessage(210, name, "");
            this.postToAllBut(sender, msg);
        }
    }

    public void updateObject(String name) {
        Enumeration list = this.listeners.elements();
        while (list.hasMoreElements()) {
            ((ServerThread)list.nextElement()).updateObject(name);
        }
    }

    public synchronized String[] Whois() {
        String[] val = new String[this.listeners.size()];
        int i = 0;
        Enumeration list = this.listeners.elements();
        while (list.hasMoreElements()) {
            val[i++] = ((ServerThread)list.nextElement()).name;
        }
        return val;
    }

    public void postTo(String name, ServerThread sender, Message msg) {
        Enumeration list = this.listeners.elements();
        while (list.hasMoreElements()) {
            ServerThread help = (ServerThread)list.nextElement();
            if (!help.name.equals(name)) continue;
            try {
                help.sendMessage(msg);
            }
            catch (IOException e) {
                this.parent.log(name + " to " + help.getName() + " " + e, 1);
            }
            break;
        }
    }

    public void postToAllBut(ServerThread sender, Message msg) {
        Enumeration list = this.listeners.elements();
        while (list.hasMoreElements()) {
            ServerThread help = (ServerThread)list.nextElement();
            if (help == sender) continue;
            try {
                help.sendMessage(msg);
            }
            catch (IOException e) {
                this.parent.log(String.valueOf(this.name) + " to " + help.getName() + " " + e, 1);
            }
        }
    }

    public void postToAll(Message msg) {
        Enumeration list = this.listeners.elements();
        while (list.hasMoreElements()) {
            ServerThread help = (ServerThread)list.nextElement();
            try {
                help.sendMessage(msg);
            }
            catch (IOException e) {
                this.parent.log(String.valueOf(this.name) + " to " + help.getName() + " " + e, 1);
            }
        }
    }
}

