/*
 * Decompiled with CFR 0.152.
 */
package matrix.server;

import java.util.Enumeration;
import java.util.Vector;
import matrix.server.MatrixD;
import matrix.server.Room;
import matrix.server.ServerThread;

public class RoomManager {
    private Vector rooms = new Vector();
    private String name;
    private String url;
    private int maxUsers;
    private boolean multible;
    private MatrixD parent;

    public RoomManager(MatrixD parent, String name, String url, int maxUsers, boolean multible) {
        this.name = name;
        this.url = url;
        this.maxUsers = maxUsers;
        this.multible = multible;
        this.parent = parent;
        this.rooms.addElement(new Room(parent, name, url));
    }

    public synchronized Room addUser(ServerThread user) {
        Enumeration list = this.rooms.elements();
        boolean found = false;
        if (this.maxUsers == 0) {
            Room help = (Room)this.rooms.firstElement();
            help.addUser(user);
            return help;
        }
        Room help = (Room)this.rooms.firstElement();
        while (list.hasMoreElements()) {
            help = (Room)list.nextElement();
            if (help.countUsers() >= this.maxUsers) continue;
            found = true;
            break;
        }
        if (found) {
            help.addUser(user);
            return help;
        }
        if (this.multible) {
            help = new Room(this.parent, this.name, this.url);
            this.rooms.addElement(help);
            help.addUser(user);
            this.parent.log("New room " + this.name + " created, now " + this.rooms.size() + " available", 3);
            return help;
        }
        return null;
    }

    public synchronized void removeUser(ServerThread user, Room room) {
        room.removeUser(user);
        if (this.rooms.contains(room) && room.countUsers() == 0 && this.rooms.size() > 3) {
            this.rooms.removeElement(room);
            this.parent.log("Room " + this.name + " destroyed, now " + this.rooms.size() + " available", 1);
        }
    }
}

