/*
 * Decompiled with CFR 0.152.
 */
package matrix.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import matrix.Connection;
import matrix.ControlMessage;
import matrix.server.MatrixD;
import matrix.server.Room;

public class ServerThread
extends Connection
implements Runnable {
    protected MatrixD daemon;
    protected Room room;
    private Thread runner;
    private Hashtable objects;
    protected String name;
    protected int clientID;
    protected int port;
    protected InetAddress inet;
    private String startRoom;

    public ServerThread(MatrixD daemon, String startRoom, Socket connection) throws IOException {
        super(connection, 10000);
        connection.setTcpNoDelay(true);
        this.objects = new Hashtable();
        this.daemon = daemon;
        this.startRoom = startRoom;
        this.runner = new Thread(this);
        this.runner.start();
    }

    public String getName() {
        return this.name;
    }

    public Room getRoom() {
        return this.room;
    }

    protected boolean login() {
        ControlMessage msg = new ControlMessage();
        try {
            msg.command = 700;
            msg.name = "MatrixD";
            msg.arg = "Hello please login to DeepMatrix V1.1 beta !";
            this.sendMessage(msg);
            msg.name = "";
            msg.arg = "";
            msg.command = 100;
            this.sendMessage(msg);
            msg = (ControlMessage)this.getMessage();
            if (msg.command == 100 && this.daemon.Check(msg.name, msg.name)) {
                this.name = msg.name;
                this.runner.setName(this.name);
                this.clientID = this.daemon.addThread(this);
                this.inet = this.getInetAddress();
                msg.command = 700;
                msg.name = "MatrixD";
                msg.arg = "" + this.clientID;
                this.sendMessage(msg);
                msg = (ControlMessage)this.getMessage();
                if (msg.command == 400) {
                    this.startRoom = msg.name;
                }
                try {
                    this.room = this.daemon.enterRoom(this, this.startRoom);
                    this.sendMessage(new ControlMessage(400, this.room.getName(), this.room.getWrl()));
                }
                catch (Exception e) {
                    this.sendMessage(new ControlMessage(900, "MatrixD", e.getMessage()));
                    this.sendMessage(new ControlMessage(150, "", ""));
                    this.daemon.log("start room " + this.startRoom + " not available, login break off", 1);
                    return false;
                }
                this.room.update(this);
                msg.command = 700;
                msg.name = this.name;
                msg.arg = " logged in";
                this.room.postToAllBut(this, msg);
                String[] userList = this.room.Whois();
                StringBuffer sb = new StringBuffer(userList[0]);
                int i = 1;
                while (i < userList.length) {
                    sb.append(" " + userList[i]);
                    ++i;
                }
                this.room.postToAll(new ControlMessage(800, "", sb.toString()));
                this.daemon.log("login from " + this.inet.getHostName() + " with ID " + this.clientID, 1);
                this.daemon.log("start in " + this.room.getName(), 2);
                return true;
            }
            msg.command = 900;
            msg.arg = "Login failed!";
            this.sendMessage(msg);
        }
        catch (Exception e) {
            this.daemon.log("Login Error " + e, 1);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updateObject(String name) {
        if (this.isAlive() && this.objects.containsKey(name)) {
            try {
                this.sendMessage(new ControlMessage(600, name, ""));
            }
            catch (IOException e) {
                this.daemon.log("Error updating object " + name + " " + e, 1);
            }
        }
    }
}

