/*
 * Decompiled with CFR 0.152.
 */
package matrix.util;

public class MathUtil {
    public static void normalize(float[] vec) {
        float d = (float)Math.sqrt(vec[0] * vec[0] + vec[1] * vec[1] + vec[2] * vec[2]);
        vec[0] = vec[0] / d;
        vec[1] = vec[1] / d;
        vec[2] = vec[2] / d;
    }

    public static float dot(float[] vec1, float[] vec2) {
        return vec1[0] * vec2[0] + vec1[1] * vec2[1] + vec1[2] * vec2[2];
    }

    public static void cross(float[] x, float[] y, float[] z) {
        z[0] = x[1] * y[2] - x[2] * y[1];
        z[1] = x[2] * y[0] - x[0] * y[2];
        z[2] = x[0] * y[1] - x[1] * y[0];
    }

    public static float det(float[][] matrix) {
        return matrix[0][0] * matrix[1][1] * matrix[2][2] + matrix[0][1] * matrix[1][2] * matrix[2][0] + matrix[0][2] * matrix[1][0] * matrix[2][1] - matrix[0][0] * matrix[1][2] * matrix[2][1] - matrix[0][1] * matrix[1][0] * matrix[2][2] - matrix[0][2] * matrix[1][1] * matrix[2][0];
    }

    public static void axisAngleToMatrix(float[] rot, float[][] matrix) {
        float[] vec = new float[]{rot[0], rot[1], rot[2]};
        MathUtil.normalize(vec);
        float s = (float)Math.sin(rot[3]);
        float c = (float)Math.cos(rot[3]);
        float t = 1.0f - c;
        matrix[0][0] = t * vec[0] * vec[0] + c;
        matrix[0][1] = t * vec[0] * vec[1] + s * vec[2];
        matrix[0][2] = t * vec[0] * vec[2] - s * vec[1];
        matrix[1][0] = t * vec[0] * vec[1] - s * vec[2];
        matrix[1][1] = t * vec[1] * vec[1] + c;
        matrix[1][2] = t * vec[1] * vec[2] + s * vec[0];
        matrix[2][0] = t * vec[0] * vec[2] + s * vec[1];
        matrix[2][1] = t * vec[1] * vec[2] - s * vec[0];
        matrix[2][2] = t * vec[2] * vec[2] + c;
        matrix[3][3] = 1.0f;
        matrix[2][3] = 0.0f;
        matrix[1][3] = 0.0f;
        matrix[0][3] = 0.0f;
        matrix[3][2] = 0.0f;
        matrix[3][1] = 0.0f;
        matrix[3][0] = 0.0f;
    }

    public static void translateMatrix(float[][] matrix, float[] vec) {
        float[] fArray = matrix[3];
        fArray[0] = fArray[0] + vec[0];
        float[] fArray2 = matrix[3];
        fArray2[1] = fArray2[1] + vec[1];
        float[] fArray3 = matrix[3];
        fArray3[2] = fArray3[2] + vec[2];
    }

    public static void getTranslationFromMatrix(float[][] matrix, float[] vec) {
        vec[0] = matrix[3][0];
        vec[1] = matrix[3][1];
        vec[2] = matrix[3][2];
    }

    public static void getRotationFromMatrix(float[][] matrix, float[] rot) {
        float[][] newMatrix = new float[4][4];
        newMatrix[0][0] = matrix[0][0];
        newMatrix[0][1] = matrix[0][1];
        newMatrix[0][2] = matrix[0][2];
        MathUtil.normalize(newMatrix[0]);
        float d1 = MathUtil.dot(newMatrix[0], matrix[1]);
        newMatrix[1][0] = matrix[1][0] - newMatrix[0][0] * d1;
        newMatrix[1][1] = matrix[1][1] - newMatrix[0][1] * d1;
        newMatrix[1][2] = matrix[1][2] - newMatrix[0][2] * d1;
        MathUtil.normalize(newMatrix[1]);
        d1 = MathUtil.dot(newMatrix[0], matrix[2]);
        float d2 = MathUtil.dot(newMatrix[1], matrix[2]);
        newMatrix[2][0] = matrix[2][0] - newMatrix[0][0] * d1 - newMatrix[1][0] * d2;
        newMatrix[2][1] = matrix[2][1] - newMatrix[0][1] * d1 - newMatrix[1][1] * d2;
        newMatrix[2][2] = matrix[2][2] - newMatrix[0][2] * d1 - newMatrix[1][2] * d2;
        MathUtil.normalize(newMatrix[2]);
        if (MathUtil.det(newMatrix) < 0.0f) {
            newMatrix[0][0] = -newMatrix[0][0];
            newMatrix[0][1] = -newMatrix[0][1];
            newMatrix[0][2] = -newMatrix[0][2];
            newMatrix[1][0] = -newMatrix[1][0];
            newMatrix[1][1] = -newMatrix[1][1];
            newMatrix[1][2] = -newMatrix[1][2];
            newMatrix[2][0] = -newMatrix[2][0];
            newMatrix[2][1] = -newMatrix[2][1];
            newMatrix[2][2] = -newMatrix[2][2];
        }
        rot[3] = (float)Math.acos((newMatrix[0][0] + newMatrix[1][1] + newMatrix[2][2] - 1.0f) / 2.0f);
        float s = (float)(2.0 * Math.sin(rot[3]));
        if (s != 0.0f) {
            rot[0] = (newMatrix[1][2] - newMatrix[2][1]) / s;
            rot[1] = (newMatrix[2][0] - newMatrix[0][2]) / s;
            rot[2] = (newMatrix[0][1] - newMatrix[1][0]) / s;
        } else {
            rot[0] = 0.0f;
            rot[1] = 1.0f;
            rot[2] = 0.0f;
        }
    }

    public static void getViewpointRotationFromMatrix(float[][] matrix, float[] rot) {
        float[][] newMatrix = new float[4][4];
        newMatrix[2][0] = matrix[2][0];
        newMatrix[2][1] = matrix[2][1];
        newMatrix[2][2] = matrix[2][2];
        MathUtil.normalize(newMatrix[2]);
        float d1 = MathUtil.dot(newMatrix[2], matrix[1]);
        newMatrix[1][0] = matrix[1][0] - newMatrix[2][0] * d1;
        newMatrix[1][1] = matrix[1][1] - newMatrix[2][1] * d1;
        newMatrix[1][2] = matrix[1][2] - newMatrix[2][2] * d1;
        MathUtil.normalize(newMatrix[1]);
        d1 = MathUtil.dot(newMatrix[2], matrix[0]);
        float d2 = MathUtil.dot(newMatrix[1], matrix[0]);
        newMatrix[0][0] = matrix[0][0] - newMatrix[2][0] * d1 - newMatrix[1][0] * d2;
        newMatrix[0][1] = matrix[0][1] - newMatrix[2][1] * d1 - newMatrix[1][1] * d2;
        newMatrix[0][2] = matrix[0][2] - newMatrix[2][2] * d1 - newMatrix[1][2] * d2;
        MathUtil.normalize(newMatrix[0]);
        if (MathUtil.det(newMatrix) < 0.0f) {
            newMatrix[0][0] = -newMatrix[0][0];
            newMatrix[0][1] = -newMatrix[0][1];
            newMatrix[0][2] = -newMatrix[0][2];
            newMatrix[1][0] = -newMatrix[1][0];
            newMatrix[1][1] = -newMatrix[1][1];
            newMatrix[1][2] = -newMatrix[1][2];
            newMatrix[2][0] = -newMatrix[2][0];
            newMatrix[2][1] = -newMatrix[2][1];
            newMatrix[2][2] = -newMatrix[2][2];
        }
        rot[3] = (float)Math.acos((newMatrix[0][0] + newMatrix[1][1] + newMatrix[2][2] - 1.0f) / 2.0f);
        float s = (float)(2.0 * Math.sin(rot[3]));
        if (s != 0.0f) {
            rot[0] = (newMatrix[1][2] - newMatrix[2][1]) / s;
            rot[1] = (newMatrix[2][0] - newMatrix[0][2]) / s;
            rot[2] = (newMatrix[0][1] - newMatrix[1][0]) / s;
        } else {
            rot[0] = 0.0f;
            rot[1] = 1.0f;
            rot[2] = 0.0f;
        }
    }

    public static void multMatrixMatrix(float[][] a, float[][] b, float[][] res) {
        res[0][0] = a[0][0] * b[0][0] + a[0][1] * b[1][0] + a[0][2] * b[2][0];
        res[0][1] = a[0][0] * b[0][1] + a[0][1] * b[1][1] + a[0][2] * b[2][1];
        res[0][2] = a[0][0] * b[0][2] + a[0][1] * b[1][2] + a[0][2] * b[2][2];
        res[1][0] = a[1][0] * b[0][0] + a[1][1] * b[1][0] + a[1][2] * b[2][0];
        res[1][1] = a[1][0] * b[0][1] + a[1][1] * b[1][1] + a[1][2] * b[2][1];
        res[1][2] = a[1][0] * b[0][2] + a[1][1] * b[1][2] + a[1][2] * b[2][2];
        res[2][0] = a[2][0] * b[0][0] + a[2][1] * b[1][0] + a[2][2] * b[2][0];
        res[2][1] = a[2][0] * b[0][1] + a[2][1] * b[1][1] + a[2][2] * b[2][1];
        res[2][2] = a[2][0] * b[0][2] + a[2][1] * b[1][2] + a[2][2] * b[2][2];
        res[3][0] = a[3][0] * b[0][0] + a[3][1] * b[1][0] + a[3][2] * b[2][0] + b[3][0];
        res[3][1] = a[3][0] * b[0][1] + a[3][1] * b[1][1] + a[3][2] * b[2][1] + b[3][1];
        res[3][2] = a[3][0] * b[0][2] + a[3][1] * b[1][2] + a[3][2] * b[2][2] + b[3][2];
        res[2][3] = 0.0f;
        res[1][3] = 0.0f;
        res[0][3] = 0.0f;
        res[3][3] = 1.0f;
    }

    public static void multVecMatrix(float[][] matrix, float[] vec) {
        float[] res = new float[]{vec[0] * matrix[0][0] + vec[1] * matrix[1][0] + vec[2] * matrix[2][0] + matrix[3][0], vec[0] * matrix[0][1] + vec[1] * matrix[1][1] + vec[2] * matrix[2][1] + matrix[3][1], vec[0] * matrix[0][2] + vec[1] * matrix[1][2] + vec[2] * matrix[2][2] + matrix[3][2]};
        vec[0] = res[0];
        vec[1] = res[1];
        vec[2] = res[2];
    }

    public static void multDirMatrix(float[][] matrix, float[] vec) {
        float[] res = new float[]{vec[0] * matrix[0][0] + vec[1] * matrix[1][0] + vec[2] * matrix[2][0], vec[0] * matrix[0][1] + vec[1] * matrix[1][1] + vec[2] * matrix[2][1], vec[0] * matrix[0][2] + vec[1] * matrix[1][2] + vec[2] * matrix[2][2]};
        vec[0] = res[0];
        vec[1] = res[1];
        vec[2] = res[2];
    }

    public static void setToIdentityMatrix(float[][] matrix) {
        matrix[3][3] = 1.0f;
        matrix[2][2] = 1.0f;
        matrix[1][1] = 1.0f;
        matrix[0][0] = 1.0f;
        matrix[0][3] = 0.0f;
        matrix[0][2] = 0.0f;
        matrix[0][1] = 0.0f;
        matrix[1][3] = 0.0f;
        matrix[1][2] = 0.0f;
        matrix[1][0] = 0.0f;
        matrix[2][3] = 0.0f;
        matrix[2][1] = 0.0f;
        matrix[2][0] = 0.0f;
        matrix[3][2] = 0.0f;
        matrix[3][1] = 0.0f;
        matrix[3][0] = 0.0f;
    }

    public static void shoutToMatrix(float[] shout, float[][] matrix) {
        matrix[0][0] = shout[0];
        matrix[0][1] = shout[1];
        matrix[0][2] = shout[2];
        matrix[0][3] = shout[3];
        matrix[1][0] = shout[4];
        matrix[1][1] = shout[5];
        matrix[1][2] = shout[6];
        matrix[1][3] = shout[7];
        matrix[2][0] = shout[8];
        matrix[2][1] = shout[9];
        matrix[2][2] = shout[10];
        matrix[2][3] = shout[11];
        matrix[3][0] = shout[12];
        matrix[3][1] = shout[13];
        matrix[3][2] = shout[14];
        matrix[3][3] = shout[15];
    }

    public static void logVec(String name, float[] a) {
        System.out.println(String.valueOf(name) + " " + a[0] + " " + a[1] + " " + a[2]);
    }

    public static void logRot(String name, float[] a) {
        System.out.println(String.valueOf(name) + " " + a[0] + " " + a[1] + " " + a[2] + " " + a[3]);
    }

    public static void logMat(String name, float[][] a) {
        System.out.println(String.valueOf(name) + "\t" + a[0][0] + " " + a[0][1] + " " + a[0][2] + " " + a[0][3]);
        System.out.println("\t" + a[1][0] + " " + a[1][1] + " " + a[1][2] + " " + a[1][3]);
        System.out.println("\t" + a[2][0] + " " + a[2][1] + " " + a[2][2] + " " + a[2][3]);
        System.out.println("\t" + a[3][0] + " " + a[3][1] + " " + a[3][2] + " " + a[3][3]);
    }
}

