/*
 * Decompiled with CFR 0.152.
 */
package matrix.vrml;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import matrix.vrml.Field;
import matrix.vrml.FieldInputStream;
import matrix.vrml.FieldOutputStream;
import matrix.vrml.InvalidFieldException;

public class FieldArray
extends Field {
    Vector data;

    public FieldArray() {
        this.data = new Vector();
    }

    public FieldArray(Field[] data) {
        this.data = new Vector(data.length);
        int i = 0;
        while (i < data.length) {
            this.data.addElement(data[i]);
            ++i;
        }
    }

    public FieldArray(InputStream in) throws IOException {
        FieldInputStream fin = new FieldInputStream(in);
        int size = fin.readInt();
        this.data = new Vector(size);
        int i = 0;
        while (i < size) {
            this.data.addElement(fin.readField());
            ++i;
        }
    }

    public void write(DataOutputStream out) throws IOException {
        FieldOutputStream fout = new FieldOutputStream(out);
        fout.writeInt(this.data.size());
        int i = 0;
        while (i < this.data.size()) {
            fout.writeField((Field)this.data.elementAt(i));
            ++i;
        }
    }

    public byte getType() {
        return 19;
    }

    public void set(Field data) throws InvalidFieldException {
        if (data.getType() != 19) {
            throw new InvalidFieldException("Data not FieldArray field");
        }
        this.data = (Vector)((FieldArray)data).data.clone();
    }

    public void addField(Field what) {
        this.data.addElement(what);
    }

    public int size() {
        return this.data.size();
    }

    public Field fieldAt(int i) {
        return (Field)this.data.elementAt(i);
    }

    public Field[] copyInto() {
        Object[] fields = new Field[this.data.size()];
        this.data.copyInto(fields);
        return fields;
    }
}

