/*
 * Decompiled with CFR 0.152.
 */
package matrix.vrml;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import matrix.vrml.Field;
import matrix.vrml.InvalidFieldException;
import matrix.vrml.SFColor;

public class MFColor
extends Field {
    SFColor[] colors;

    public MFColor(float[][] data) {
        this.setValue(data);
    }

    public MFColor(MFColor data) {
        this.setValue(data.getValue());
    }

    public MFColor(DataInputStream in) throws IOException {
        this.colors = new SFColor[in.readInt()];
        int i = 0;
        while (i < this.colors.length) {
            this.colors[i] = new SFColor(in);
            ++i;
        }
    }

    public void setValue(float[][] data) {
        this.colors = new SFColor[data.length];
        int i = 0;
        while (i < data.length) {
            this.colors[i] = new SFColor(data[i]);
            ++i;
        }
    }

    public void set1Value(int index, float[] value) {
        this.colors[index] = new SFColor(value);
    }

    public SFColor[] getColors() {
        return this.colors;
    }

    public SFColor get1Color(int pos) {
        return this.colors[pos];
    }

    public float[][] getValue() {
        float[][] out = new float[this.colors.length][3];
        int i = 0;
        while (i < this.colors.length) {
            out[i][0] = this.colors[i].red;
            out[i][1] = this.colors[i].green;
            out[i][2] = this.colors[i].blue;
            ++i;
        }
        return out;
    }

    public float[] get1Value(int pos) {
        return this.colors[pos].getValue();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.colors.length);
        int i = 0;
        while (i < this.colors.length) {
            this.colors[i].write(out);
            ++i;
        }
    }

    public byte getType() {
        return 11;
    }

    public void set(Field data) throws InvalidFieldException {
        if (data.getType() != 11) {
            throw new InvalidFieldException("Data not MFColor field");
        }
        this.setValue(((MFColor)data).getValue());
    }
}

