/*
 * Decompiled with CFR 0.152.
 */
package matrix.vrml;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import matrix.vrml.Field;
import matrix.vrml.InvalidFieldException;

public class MFFloat
extends Field {
    public float[] values;

    public MFFloat(float[] val) {
        this.setValue(val);
    }

    public MFFloat(MFFloat val) {
        this.setValue(val.values);
    }

    public MFFloat(DataInputStream in) throws IOException {
        this.values = new float[in.readInt()];
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = in.readFloat();
            ++i;
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.values.length);
        int i = 0;
        while (i < this.values.length) {
            out.writeFloat(this.values[i]);
            ++i;
        }
    }

    public byte getType() {
        return 12;
    }

    public void set(Field data) throws InvalidFieldException {
        if (data.getType() != 12) {
            throw new InvalidFieldException("Data not MFFloat field");
        }
        this.setValue(((MFFloat)data).values);
    }

    public void setValue(float[] data) {
        this.values = new float[data.length];
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = data[i];
            ++i;
        }
    }

    public void set1Value(int index, float data) {
        this.values[index] = data;
    }

    public float[] getValue() {
        return this.values;
    }

    public float get1Value(int index) {
        return this.values[index];
    }
}

