/*
 * Decompiled with CFR 0.152.
 */
package matrix.vrml;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import matrix.vrml.Field;
import matrix.vrml.InvalidFieldException;

public class SFVec3f
extends Field {
    public float[] values = new float[3];

    public SFVec3f() {
    }

    public SFVec3f(SFVec3f data) {
        this.setValue(data.getValue());
    }

    public SFVec3f(float x, float y, float z) {
        this.values[0] = x;
        this.values[1] = y;
        this.values[2] = z;
    }

    public SFVec3f(float[] values) {
        this.setValue(values);
    }

    public SFVec3f(DataInputStream in) throws IOException {
        this.values[0] = in.readFloat();
        this.values[1] = in.readFloat();
        this.values[2] = in.readFloat();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeFloat(this.values[0]);
        out.writeFloat(this.values[1]);
        out.writeFloat(this.values[2]);
    }

    public byte getType() {
        return 10;
    }

    public void set(Field data) throws InvalidFieldException {
        if (data.getType() != 10) {
            throw new InvalidFieldException("Data not SFVec3f field");
        }
        this.setValue(((SFVec3f)data).getValue());
    }

    public SFVec3f plus(SFVec3f v) {
        return new SFVec3f(this.values[0] + v.values[0], this.values[1] + v.values[1], this.values[2] + v.values[2]);
    }

    public SFVec3f minus(SFVec3f v) {
        return new SFVec3f(this.values[0] - v.values[0], this.values[1] - v.values[1], this.values[2] - v.values[2]);
    }

    public void setValue(float[] value) {
        this.values[0] = value[0];
        this.values[1] = value[1];
        this.values[2] = value[2];
    }

    public float[] getValue() {
        return this.values;
    }
}

