/*
 * Decompiled with CFR 0.152.
 */
package nvrcontentserver.vrserviceprocessor;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class HttpRequestParser {
    String httpRequest;

    public HttpRequestParser(FileInputStream httpRequest) throws IOException {
        String line = null;
        BufferedReader buf = new BufferedReader(new InputStreamReader(httpRequest));
        while ((line = buf.readLine()) != null) {
            this.httpRequest = String.valueOf(this.httpRequest) + line + "\n";
        }
    }

    public String getServerAddress() throws IOException {
        StringTokenizer tok;
        String line = null;
        String address = null;
        BufferedReader buf = new BufferedReader(new StringReader(this.httpRequest));
        while ((line = buf.readLine()) != null) {
            tok = new StringTokenizer(line);
            while (tok.hasMoreElements()) {
                if (tok.nextToken().compareTo("Host:") != 0) continue;
                address = tok.nextToken();
                break;
            }
            if (address != null) break;
        }
        if (address != null) {
            tok = new StringTokenizer(address, ":");
            try {
                address = tok.nextToken();
            }
            catch (NoSuchElementException nsee) {
                address = null;
            }
        }
        try {
            buf.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return address;
    }

    public String getServerPort() throws IOException {
        StringTokenizer tok;
        String line = null;
        String port = null;
        BufferedReader buf = new BufferedReader(new StringReader(this.httpRequest));
        while ((line = buf.readLine()) != null) {
            tok = new StringTokenizer(line);
            while (tok.hasMoreElements()) {
                if (tok.nextToken().compareTo("Host:") != 0) continue;
                port = tok.nextToken();
                break;
            }
            if (port != null) break;
        }
        if (port != null) {
            tok = new StringTokenizer(port, ":");
            try {
                tok.nextToken();
                port = tok.nextToken();
            }
            catch (NoSuchElementException nsee) {
                port = null;
            }
        }
        try {
            buf.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return port;
    }
}

