/*
 * Decompiled with CFR 0.152.
 */
package nvrcontentserver.vrserviceprocessor;

import hr.fer.tel.nims.dsa.server.serviceprofilehandler.ProfileParser;
import hr.fer.tel.nims.dsa.server.serviceprofilehandler.XmlElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import matrix.sip.server.ServerSipController;
import nvrcontentserver.vrserviceprocessor.ServicesData;
import nvrcontentserver.vrserviceprocessor.galleryservice.GalleryProcessor;

public class ServiceProcessor
extends Thread {
    private Socket socket = null;
    private InputStream socketInput = null;
    private OutputStream socketOutput = null;
    private ServerSipController serverSipController = null;
    private ServicesData serviceData = null;
    private GalleryProcessor galleryProcessor;

    public ServiceProcessor(Socket socket, ServicesData serviceData, GalleryProcessor galleryProcessor, ServerSipController serverSipController) throws IOException {
        super("ServiceProcessorThread");
        this.socket = socket;
        this.serviceData = serviceData;
        this.galleryProcessor = galleryProcessor;
        this.serverSipController = serverSipController;
        System.out.print("\nNVR content server's socket opened to " + this.socket.getInetAddress().getHostName());
        System.out.println(":" + this.socket.getPort());
        try {
            this.socketOutput = socket.getOutputStream();
            System.out.println("\tSocket output stream opened");
        }
        catch (IOException ioe) {
            System.out.println("Unable to open socket output stream!");
            this.socket.close();
        }
        try {
            this.socketInput = socket.getInputStream();
            System.out.println("\tSocket input stream opened");
        }
        catch (IOException ioe) {
            System.out.println("Unable to open socket input stream!");
            this.socket.close();
        }
        try {
            socket.setKeepAlive(true);
        }
        catch (SocketException se) {
            se.printStackTrace();
        }
    }

    public void run() {
        try {
            this.receiveClientRequest();
            System.out.println("ServiceProcessor zatvara sockete.");
            this.closeSocket();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void receiveClientRequest() throws IOException {
        String clientRequest = new String("");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socketInput));
        int byteRead = 0;
        while ((byteRead = bufferedReader.read()) != 26 && byteRead != -1) {
            clientRequest = String.valueOf(clientRequest) + (char)byteRead;
        }
        if (clientRequest == "") {
            System.out.println("The client request is empty!");
        } else {
            System.out.println(clientRequest);
        }
        int index = clientRequest.lastIndexOf("Call-ID:");
        String sessionId = clientRequest.substring(index + 8);
        ProfileParser profileManager = new ProfileParser();
        XmlElement xmlElement = new XmlElement("General_Info", "", null, null);
        System.out.println("finalni profil je " + this.serverSipController.getFinalProfile());
        String result = profileManager.getParameter(this.serverSipController.getFinalProfile(), xmlElement);
        xmlElement = new XmlElement("Service_Description", "", null, null);
        result = profileManager.getParameter(result, xmlElement);
        xmlElement = new XmlElement("name", "", null, null);
        result = profileManager.getParameterValue(result, xmlElement);
        if (result.contains("gallery")) {
            this.galleryProcessor.processService(this.socketOutput, this.serverSipController.getFinalProfile(), this.socket, sessionId);
        }
        while ((byteRead = bufferedReader.read()) != 26 && byteRead != -1) {
            clientRequest = String.valueOf(clientRequest) + (char)byteRead;
        }
    }

    private void closeSocket() {
        try {
            if (this.socketInput != null) {
                this.socketInput.close();
                System.out.println("\t Socket input stream closed");
            }
            if (this.socketOutput != null) {
                this.socketOutput.close();
                System.out.println("\t Socket output stream closed");
            }
            if (this.socket != null) {
                System.out.println("\n Closing (client) socket at port: " + this.socket.getPort());
                this.socket.close();
            }
            this.socket = null;
            System.out.println("\t Socket closed");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

