/*
 * Decompiled with CFR 0.152.
 */
package nvrcontentserver.vrserviceprocessor;

import hr.fer.tel.nims.dsa.server.sipagent.SessionData;
import java.io.IOException;
import java.net.ServerSocket;
import matrix.sip.server.ServerSipController;
import nvrcontentserver.vrserviceprocessor.ServiceProcessor;
import nvrcontentserver.vrserviceprocessor.ServicesData;
import nvrcontentserver.vrserviceprocessor.UserInteractionListener;
import nvrcontentserver.vrserviceprocessor.galleryservice.GalleryProcessor;

public class ServiceRequestListener
extends Thread {
    private static final int serviceRequestListeningPort = 8095;
    private boolean listening = true;
    private UserInteractionListener userInteractionListener;
    private ServicesData serviceData = new ServicesData();
    private GalleryProcessor galleryProcessor = new GalleryProcessor(this.serviceData);
    private String callId;
    private ServerSipController serverSipController;

    public ServiceRequestListener(String callId, ServerSipController serverSipController) {
        super("ServiceRequestListenerThread");
        this.callId = callId;
        this.serverSipController = serverSipController;
        serverSipController.setGalleryProcessor(this.galleryProcessor);
    }

    public void run() {
        ServerSocket serverSocket = null;
        System.out.println("Starting Service Request Listener....");
        try {
            serverSocket = new ServerSocket(8095);
            System.out.println("\tOpened socket at port: 8095");
        }
        catch (IOException ioe) {
            System.err.println("\tCould not listen on port: 8095");
            System.exit(-1);
        }
        boolean start = true;
        try {
            while (this.listening) {
                new ServiceProcessor(serverSocket.accept(), this.serviceData, this.galleryProcessor, this.serverSipController).run();
                if (!start) continue;
                this.userInteractionListener = new UserInteractionListener(this.galleryProcessor, this.serverSipController);
                this.userInteractionListener.start();
                start = false;
            }
            this.userInteractionListener.setListening(false);
            System.out.println("\n Closing server socket.............");
            serverSocket.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void notifyGalleryProcessor(String callId, SessionData sessionData) {
        try {
            this.galleryProcessor.processService(null, this.serverSipController.getFinalProfile(), null, callId);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setListening(boolean listening) {
        this.listening = listening;
    }
}

