/*
 * Decompiled with CFR 0.152.
 */
package nvrcontentserver.vrserviceprocessor;

import java.io.IOException;
import java.net.ServerSocket;
import matrix.sip.server.ServerSipController;
import nvrcontentserver.vrserviceprocessor.UserInteractionProcessor;
import nvrcontentserver.vrserviceprocessor.galleryservice.GalleryProcessor;

public class UserInteractionListener
extends Thread {
    private static final int userInteractionListeningPort = 8096;
    private boolean listening = true;
    private ServerSipController serverSipController;
    private GalleryProcessor galleryProcessor;

    public UserInteractionListener(GalleryProcessor galleryProcessor, ServerSipController serverSipController) {
        super("UserInteractionListenerThread");
        this.galleryProcessor = galleryProcessor;
        this.serverSipController = serverSipController;
    }

    public void run() {
        ServerSocket serverSocket = null;
        System.out.println("Starting User Interaction Listener....");
        try {
            serverSocket = new ServerSocket(8096);
            System.out.println("\tOpened socket at port: 8096");
        }
        catch (IOException ioe) {
            System.err.println("\tCould not listen on port: 8096");
            System.exit(-1);
        }
        try {
            while (this.listening) {
                new UserInteractionProcessor(serverSocket.accept(), this.galleryProcessor, this.serverSipController).start();
            }
            System.out.println("\n Closing server socket.............");
            serverSocket.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setListening(boolean listening) {
        this.listening = listening;
    }
}

