/*
 * Decompiled with CFR 0.152.
 */
package nvrcontentserver.vrserviceprocessor.galleryservice.streamreceiver;

import java.awt.Component;
import java.net.InetAddress;
import java.util.Vector;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Manager;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.control.BufferControl;
import javax.media.protocol.DataSource;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.NewParticipantEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;
import javax.media.rtp.event.SessionEvent;
import javax.media.rtp.event.StreamMappedEvent;
import nvrcontentserver.vrserviceprocessor.galleryservice.streamreceiver.PlayerWindow;
import nvrcontentserver.vrserviceprocessor.galleryservice.streamreceiver.SessionNameParser;

public class Receiver
implements ReceiveStreamListener,
SessionListener,
ControllerListener {
    String[] sessions = null;
    RTPManager[] rtpManager = null;
    Vector playerWindows = null;
    boolean dataReceived = false;
    Object dataSync = new Object();

    public Receiver(String[] sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize() {
        try {
            SessionAddress localAddr = new SessionAddress();
            this.rtpManager = new RTPManager[this.sessions.length];
            this.playerWindows = new Vector();
            System.out.println("bla bal tu sam");
            System.out.println("sad sam tu");
            int i = 0;
            while (i < this.sessions.length) {
                SessionAddress destAddr;
                SessionNameParser session;
                try {
                    session = new SessionNameParser(this.sessions[i]);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Failed to parse the session address given: " + this.sessions[i]);
                    return false;
                }
                System.out.println("  - Open RTP session for: addr: " + session.ipaddress + " port: " + session.port + " ttl: " + session.ttl);
                this.rtpManager[i] = RTPManager.newInstance();
                this.rtpManager[i].addSessionListener((SessionListener)this);
                this.rtpManager[i].addReceiveStreamListener((ReceiveStreamListener)this);
                InetAddress ipAddr = InetAddress.getByName(session.ipaddress);
                if (ipAddr.isMulticastAddress()) {
                    localAddr = new SessionAddress(ipAddr, session.port, session.ttl);
                    destAddr = new SessionAddress(ipAddr, session.port, session.ttl);
                } else {
                    localAddr = new SessionAddress(ipAddr, session.port);
                    destAddr = new SessionAddress(ipAddr, session.port);
                }
                this.rtpManager[i].initialize(localAddr);
                BufferControl buffercontol = (BufferControl)this.rtpManager[i].getControl("javax.media.control.BufferControl");
                if (buffercontol != null) {
                    buffercontol.setBufferLength(350L);
                }
                this.rtpManager[i].addTarget(destAddr);
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Cannot create the RTP Session: " + e.getMessage());
            return false;
        }
        long startPoint = System.currentTimeMillis();
        long waitingPeriod = 120000L;
        try {
            Object object = this.dataSync;
            synchronized (object) {
                while (!this.dataReceived && System.currentTimeMillis() - startPoint < waitingPeriod) {
                    if (!this.dataReceived) {
                        System.out.println("  - Waiting for RTP data to arrive...");
                    }
                    this.dataSync.wait(1000L);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.dataReceived) {
            System.err.println("No RTP data was received.");
            this.close();
            return false;
        }
        return true;
    }

    public boolean isDone() {
        return this.playerWindows.size() == 0;
    }

    protected void close() {
        int i = 0;
        while (i < this.playerWindows.size()) {
            try {
                ((PlayerWindow)this.playerWindows.elementAt(i)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.playerWindows.removeAllElements();
        i = 0;
        while (i < this.rtpManager.length) {
            if (this.rtpManager[i] != null) {
                this.rtpManager[i].removeTargets("Closing session from Receiver");
                this.rtpManager[i].dispose();
                this.rtpManager[i] = null;
            }
            ++i;
        }
    }

    PlayerWindow find(Player p) {
        int i = 0;
        while (i < this.playerWindows.size()) {
            PlayerWindow pw = (PlayerWindow)this.playerWindows.elementAt(i);
            if (pw.player == p) {
                return pw;
            }
            ++i;
        }
        return null;
    }

    PlayerWindow find(ReceiveStream strm) {
        int i = 0;
        while (i < this.playerWindows.size()) {
            PlayerWindow pw = (PlayerWindow)this.playerWindows.elementAt(i);
            if (pw.stream == strm) {
                return pw;
            }
            ++i;
        }
        return null;
    }

    public synchronized void update(SessionEvent evt) {
        if (evt instanceof NewParticipantEvent) {
            Participant p = ((NewParticipantEvent)evt).getParticipant();
            System.out.println("  - A new participant had just joined: " + p.getCNAME());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(ReceiveStreamEvent evt) {
        block19: {
            RTPManager mgr = (RTPManager)evt.getSource();
            Participant participant = evt.getParticipant();
            ReceiveStream stream = evt.getReceiveStream();
            if (evt instanceof RemotePayloadChangeEvent) {
                System.err.println("  - Received an RTP PayloadChangeEvent.");
                System.err.println("Sorry, cannot handle payload change.");
                System.exit(0);
            } else {
                if (evt instanceof NewReceiveStreamEvent) {
                    try {
                        stream = ((NewReceiveStreamEvent)evt).getReceiveStream();
                        DataSource ds = stream.getDataSource();
                        RTPControl ctl = (RTPControl)ds.getControl("javax.media.rtp.RTPControl");
                        if (ctl != null) {
                            System.out.println("  - Recevied new RTP stream: " + ctl.getFormat());
                        } else {
                            System.out.println("  - Recevied new RTP stream");
                        }
                        if (participant == null) {
                            System.out.println("      The sender of this stream had yet to be identified.");
                        } else {
                            System.out.println("      The stream comes from: " + participant.getCNAME());
                        }
                        Player p = Manager.createPlayer((DataSource)ds);
                        if (p == null) {
                            return;
                        }
                        p.addControllerListener((ControllerListener)this);
                        p.realize();
                        PlayerWindow pw = new PlayerWindow(p, stream);
                        this.playerWindows.addElement(pw);
                        Object object = this.dataSync;
                        synchronized (object) {
                            this.dataReceived = true;
                            this.dataSync.notifyAll();
                            break block19;
                        }
                    }
                    catch (Exception e) {
                        System.err.println("NewReceiveStreamEvent exception " + e.getMessage());
                        return;
                    }
                }
                if (evt instanceof StreamMappedEvent) {
                    if (stream != null && stream.getDataSource() != null) {
                        DataSource ds = stream.getDataSource();
                        RTPControl ctl = (RTPControl)ds.getControl("javax.media.rtp.RTPControl");
                        System.out.println("  - The previously unidentified stream ");
                        if (ctl != null) {
                            System.out.println("      " + ctl.getFormat());
                        }
                        System.out.println("      had now been identified as sent by: " + participant.getCNAME());
                    }
                } else if (evt instanceof ByeEvent) {
                    System.out.println("  - Got \"bye\" from: " + participant.getCNAME());
                    PlayerWindow pw = this.find(stream);
                    if (pw != null) {
                        pw.close();
                        this.playerWindows.removeElement(pw);
                    }
                }
            }
        }
    }

    public synchronized void controllerUpdate(ControllerEvent ce) {
        PlayerWindow pw;
        Player p = (Player)ce.getSourceController();
        if (p == null) {
            return;
        }
        if (ce instanceof RealizeCompleteEvent) {
            pw = this.find(p);
            if (pw == null) {
                System.err.println("Internal error!");
                System.exit(-1);
            }
            System.out.println("Inicijaliziram...");
            pw.initialize();
            System.out.println("Inicijalizirao...");
            ((Component)pw).setVisible(true);
            p.start();
        }
        if (ce instanceof ControllerErrorEvent) {
            p.removeControllerListener((ControllerListener)this);
            pw = this.find(p);
            if (pw != null) {
                pw.close();
                this.playerWindows.removeElement(pw);
            }
            System.err.println("Receiver internal error: " + ce);
        }
    }

    public synchronized void controller(ControllerEvent ce) {
        if (ce instanceof ControllerClosedEvent) {
            System.out.println(" Dobio controller event");
        }
    }

    public static void main(String[] argv) {
        Receiver avReceive;
        if (argv.length == 0) {
            Receiver.prUsage();
        }
        if (!(avReceive = new Receiver(argv)).initialize()) {
            System.err.println("Failed to initialize the sessions.");
        }
        try {
            while (!avReceive.isDone()) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Exiting Receiver");
    }

    static void prUsage() {
        System.out.println("Usage: Receiver <session> <session> ...");
        System.out.println("     <session>: <address>/<port>/<ttl>");
    }
}

