/*
 * Decompiled with CFR 0.152.
 */
package nvrcontentserver.vrserviceprocessor.galleryservice.streamtransmitter;

import java.awt.Dimension;
import java.io.IOException;
import java.net.InetAddress;
import javax.media.Codec;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoProcessorException;
import javax.media.Owned;
import javax.media.Player;
import javax.media.Processor;
import javax.media.Time;
import javax.media.control.QualityControl;
import javax.media.control.TrackControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.RTPManager;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionAddress;
import nvrcontentserver.vrserviceprocessor.galleryservice.streamtransmitter.ChosenAudioCodec;
import nvrcontentserver.vrserviceprocessor.galleryservice.streamtransmitter.ChosenVideoCodec;

public class AudioVideoFormats {
    private MediaLocator locator;
    private String ipAddress;
    private int portBase;
    private int trackNumber;
    Time duration = null;
    private long processDuration;
    Time stoptime = null;
    private long remainingtime;
    private long currenttime;
    private Processor processor = null;
    private RTPManager[] rtpManager;
    private DataSource dataOutput = null;
    private ChosenAudioCodec chosenAudiocodec = new ChosenAudioCodec();
    private ChosenVideoCodec chosenVideocodec = new ChosenVideoCodec();
    private Time mediaTime = null;
    public int homeport = 8000;
    private Integer stateLock = new Integer(0);
    private boolean failed = false;

    public AudioVideoFormats(MediaLocator locator, String ipAddress, String pb, Format format, int trackNumber) {
        this.locator = locator;
        this.ipAddress = ipAddress;
        this.trackNumber = trackNumber;
        Integer integer = Integer.valueOf(pb);
        if (integer != null) {
            this.portBase = integer;
        }
    }

    public synchronized String start() {
        String result = this.createProcessor();
        if (result != null) {
            return result;
        }
        result = this.createTransmitter();
        if (result != null) {
            this.processor.close();
            this.processor = null;
            return result;
        }
        this.processor.start();
        return null;
    }

    private Time returnTime() {
        Time time = this.processor.getMediaTime();
        return time;
    }

    private void setTime(Time time) {
        this.mediaTime = time;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void changeAudioCodec(String newFormatName) {
        this.chosenAudiocodec.setName(newFormatName);
        this.mediaTime = this.processor.getMediaTime();
        System.out.println("Stopping processor");
        this.stop();
        System.out.println("Starting processor");
        this.start();
    }

    public void changeVideoCodec(String newFormatName) {
        this.chosenVideocodec.setName(newFormatName);
        this.mediaTime = this.processor.getMediaTime();
        System.out.println("Stopping processor");
        this.stop();
        System.out.println("Starting processor");
        this.start();
    }

    public ChosenAudioCodec returnchosenAudiocodec() {
        return this.chosenAudiocodec;
    }

    public ChosenVideoCodec returnchosenVideocodec() {
        return this.chosenVideocodec;
    }

    public void setChosenAudiocodec(String newFormat) {
        this.chosenAudiocodec.setName(newFormat);
    }

    public void setChosenVideocodec(String newFormat) {
        this.chosenVideocodec.setName(newFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AudioVideoFormats audioVideoFormats = this;
        synchronized (audioVideoFormats) {
            if (this.processor != null) {
                this.processor.stop();
                this.processor.close();
                this.processor = null;
                int i = 0;
                while (i < this.rtpManager.length) {
                    this.rtpManager[i].removeTargets("Session ended.");
                    this.rtpManager[i].dispose();
                    ++i;
                }
            }
        }
    }

    private String createProcessor() {
        DataSource ds;
        if (this.locator == null) {
            return "Locator is null";
        }
        try {
            ds = Manager.createDataSource((MediaLocator)this.locator);
        }
        catch (Exception e) {
            return "Couldn't create DataSource";
        }
        try {
            this.processor = Manager.createProcessor((DataSource)ds);
        }
        catch (NoProcessorException npe) {
            return "Couldn't create processor";
        }
        catch (IOException ioe) {
            return "IOException creating processor";
        }
        boolean result = this.waitForState(this.processor, 180);
        if (!result) {
            return "Couldn't configure processor";
        }
        TrackControl[] tracks = this.processor.getTrackControls();
        if (tracks == null || tracks.length < 1) {
            return "Couldn't find tracks in processor";
        }
        ContentDescriptor cd = new ContentDescriptor("raw.rtp");
        this.processor.setContentDescriptor(cd);
        boolean atLeastOneTrack = false;
        System.out.println("Trackova ima " + tracks.length);
        int i = 0;
        while (i < tracks.length) {
            Format format = tracks[i].getFormat();
            if (tracks[i].isEnabled()) {
                System.out.println("Track je enabled");
            }
            System.out.println("I je " + i + ", a tracknumber je " + this.trackNumber);
            if (tracks[i].isEnabled() && i == this.trackNumber) {
                Format[] supported = tracks[i].getSupportedFormats();
                System.out.println("Formats for track " + i + " are next:");
                int j = 0;
                while (j < supported.length) {
                    System.out.println("Supported format: " + supported[j]);
                    ++j;
                }
                if (supported.length > 0) {
                    Format chosen = supported[0] instanceof VideoFormat ? this.checkForVideoSizes(tracks[i].getFormat(), supported[0]) : supported[0];
                    System.out.println("Chosen audio codec= " + this.chosenAudiocodec.getName());
                    System.out.println("Chosen video codec= " + this.chosenVideocodec.getName());
                    int k = 0;
                    while (k < supported.length) {
                        String ime = supported[k].toString();
                        if (this.chosenAudiocodec.getName().compareTo("PCM") == 0 && ime.startsWith("PCM")) {
                            chosen = supported[k];
                            break;
                        }
                        if (this.chosenAudiocodec.getName().compareTo("LINEAR") == 0 && ime.startsWith("LINEAR")) {
                            chosen = supported[k];
                            break;
                        }
                        if (this.chosenAudiocodec.getName().compareTo("GSM") == 0 && ime.startsWith("gsm")) {
                            chosen = supported[k];
                            break;
                        }
                        if (this.chosenAudiocodec.getName().compareTo("g723") == 0 && ime.startsWith("g723")) {
                            chosen = supported[k];
                            break;
                        }
                        if (this.chosenVideocodec.getName().compareTo("H263") == 0 && ime.startsWith("H263")) {
                            chosen = supported[k];
                            break;
                        }
                        if (this.chosenVideocodec.getName().compareTo("MPEG") == 0 && ime.startsWith("MPEG")) {
                            chosen = supported[k];
                            break;
                        }
                        if (this.chosenVideocodec.getName().compareTo("JPEG") == 0 && ime.startsWith("JPEG")) {
                            chosen = supported[k];
                            break;
                        }
                        ++k;
                    }
                    tracks[i].setFormat(chosen);
                    System.out.println("Track " + i + " is set to transmit as:");
                    System.out.println("  " + chosen);
                    atLeastOneTrack = true;
                } else {
                    tracks[i].setEnabled(false);
                }
            } else {
                tracks[i].setEnabled(false);
            }
            ++i;
        }
        if (!atLeastOneTrack) {
            return "Couldn't set any of the tracks to a valid RTP format";
        }
        result = this.waitForState(this.processor, 300);
        if (!result) {
            return "Couldn't realize processor";
        }
        this.duration = this.processor.getDuration();
        this.processDuration = this.duration.getNanoseconds();
        long stoptimelong = this.processor.getDuration().getNanoseconds() + this.processor.getMediaTime().getNanoseconds();
        this.stoptime = new Time(stoptimelong);
        if (this.mediaTime != null) {
            this.processor.setMediaTime(this.mediaTime);
            this.processDuration = this.stoptime.getNanoseconds() - this.mediaTime.getNanoseconds();
        }
        this.processDuration /= 1000000L;
        this.processDuration += 1000L;
        System.out.println("process duration = " + this.processDuration);
        this.setJPEGQuality((Player)this.processor, 0.5f);
        this.dataOutput = this.processor.getDataOutput();
        return null;
    }

    public void sethomeport(int port) {
        this.homeport = port;
    }

    public int gethomeport() {
        return this.homeport;
    }

    private String createTransmitter() {
        PushBufferDataSource pbds = (PushBufferDataSource)this.dataOutput;
        PushBufferStream[] pbss = pbds.getStreams();
        this.rtpManager = new RTPManager[pbss.length];
        int i = 0;
        while (i < pbss.length) {
            try {
                this.rtpManager[i] = RTPManager.newInstance();
                this.homeport += 2 * i;
                int port = this.portBase + 2 * i;
                InetAddress ipAddr = InetAddress.getByName(this.ipAddress);
                SessionAddress localAddr = new SessionAddress(InetAddress.getLocalHost(), this.homeport);
                SessionAddress destAddr = new SessionAddress(ipAddr, port);
                this.rtpManager[i].initialize(localAddr);
                this.rtpManager[i].addTarget(destAddr);
                System.out.println("Created RTP session: " + this.ipAddress + " " + port);
                SendStream sendStream = this.rtpManager[i].createSendStream(this.dataOutput, i);
                sendStream.start();
            }
            catch (Exception e) {
                return e.getMessage();
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    Format checkForVideoSizes(Format original, Format supported) {
        void var4_7;
        void var3_6;
        int height;
        int width;
        Dimension size = ((VideoFormat)original).getSize();
        Format jpegFormat = new Format("jpeg/rtp");
        Format h263Format = new Format("h263/rtp");
        if (supported.matches(jpegFormat)) {
            width = size.width % 8 == 0 ? size.width : size.width / 8 * 8;
            height = size.height % 8 == 0 ? size.height : size.height / 8 * 8;
        } else if (supported.matches(h263Format)) {
            if (size.width < 128) {
                width = 128;
                height = 96;
            } else if (size.width < 176) {
                width = 176;
                height = 144;
            } else {
                width = 352;
                height = 288;
            }
        } else {
            return supported;
        }
        return new VideoFormat(null, new Dimension((int)var3_6, (int)var4_7), -1, null, -1.0f).intersects(supported);
    }

    void setJPEGQuality(Player p, float val) {
        Control[] cs = p.getControls();
        QualityControl qc = null;
        VideoFormat jpegFormat = new VideoFormat("jpeg");
        int i = 0;
        while (i < cs.length) {
            if (cs[i] instanceof QualityControl && cs[i] instanceof Owned) {
                Object owner = ((Owned)cs[i]).getOwner();
                if (owner instanceof Codec) {
                    Format[] fmts = ((Codec)owner).getSupportedOutputFormats(null);
                    int j = 0;
                    while (j < fmts.length) {
                        if (fmts[j].matches((Format)jpegFormat)) {
                            qc = (QualityControl)cs[i];
                            qc.setQuality(val);
                            System.out.println("- Setting quality to " + val + " on " + qc);
                            break;
                        }
                        ++j;
                    }
                }
                if (qc != null) break;
            }
            ++i;
        }
    }

    Integer getStateLock() {
        return this.stateLock;
    }

    void setFailed() {
        this.failed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean waitForState(Processor p, int state) {
        p.addControllerListener((ControllerListener)new StateListener());
        this.failed = false;
        if (state == 180) {
            p.configure();
        } else if (state == 300) {
            p.realize();
        }
        while (p.getState() < state && !this.failed) {
            Integer n = this.getStateLock();
            synchronized (n) {
                try {
                    this.getStateLock().wait();
                }
                catch (InterruptedException ie) {
                    return false;
                }
            }
        }
        return !this.failed;
    }

    public InterruptedException sleep() {
        InterruptedException exception = null;
        System.out.println("Start transmission for " + this.processDuration / 1000L + " seconds");
        try {
            System.out.println("Kreno spat");
            Thread.currentThread();
            Thread.sleep(this.processDuration + 5000L);
            System.out.println("BUDJENJEEEE");
        }
        catch (InterruptedException ie) {
            return ie;
        }
        return exception;
    }

    public InterruptedException semisleep() {
        InterruptedException exception = null;
        System.out.println("Start transmission for " + this.processDuration / 1000L + " seconds");
        try {
            Thread.currentThread();
            Thread.sleep(this.processDuration / 5L);
        }
        catch (InterruptedException ie) {
            return ie;
        }
        return exception;
    }

    public static void main(String[] args) {
        InterruptedException semisleeptimeaudio;
        if (args.length < 3) {
            AudioVideoFormats.prUsage();
        }
        Format fmt = null;
        int i = 0;
        AudioVideoFormats avTransmit = new AudioVideoFormats(new MediaLocator(args[i]), args[i + 1], args[i + 2], fmt, 0);
        AudioVideoFormats avTransmit2 = new AudioVideoFormats(new MediaLocator("file:/D:/postdiplomski/Izvedba_modela/Sounds_and_Video_clips/toyota.mpeg"), "159.107.226.107", "22226", fmt, 1);
        String result = avTransmit.start();
        if (result != null) {
            System.err.println("Error 1: " + result);
            System.exit(0);
        }
        avTransmit2.sethomeport(9000);
        String result2 = avTransmit2.start();
        if (result2 != null) {
            System.err.println("Error 1: " + result);
            System.exit(0);
        }
        if ((semisleeptimeaudio = avTransmit2.semisleep()) != null) {
            System.err.println("Error 2: " + semisleeptimeaudio);
            System.exit(0);
        }
        semisleeptimeaudio = avTransmit2.semisleep();
        avTransmit2.changeAudioCodec("mpegaudio");
        avTransmit.changeVideoCodec("MPEG");
        InterruptedException sleeptime = avTransmit2.sleep();
        if (sleeptime != null) {
            System.err.println("Error 2: " + sleeptime);
            System.exit(0);
        }
        avTransmit.stop();
        avTransmit2.stop();
        System.out.println("...transmission ended.");
        System.exit(0);
    }

    static void prUsage() {
        System.out.println("Usage: AVTransmiter <sourceURL> <destIP> <destPortBase>");
        System.out.println("     <sourceURL>: input URL or file name");
        System.out.println("     <destIP>: multicast, broadcast or unicast IP address for the transmission");
        System.out.println("     <destPortBase>: network port numbers for the transmission.");
        System.out.println("                     The first track will use the destPortBase.");
        System.out.println("                     The next track will use destPortBase + 2 and so on.\n");
        System.exit(0);
    }

    class StateListener
    implements ControllerListener {
        StateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerClosedEvent) {
                AudioVideoFormats.this.setFailed();
            }
            if (ce instanceof ControllerEvent) {
                Integer n = AudioVideoFormats.this.getStateLock();
                synchronized (n) {
                    AudioVideoFormats.this.getStateLock().notifyAll();
                }
            }
        }
    }
}

