/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import matrix.deck.Backend;
import matrix.deck.NetworkListener;
import tools.BotConsumer;
import tools.ObjectListener;

public class Bot
implements NetworkListener {
    private Backend net;
    private Vector consumers = new Vector();

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage : java tools.Bot resourcefile");
            return;
        }
        try {
            Bot me = new Bot(args[0]);
            while (System.in.available() == 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            me.close();
        }
        catch (Exception e) {
            System.err.println("Error running Bot " + e);
            System.exit(1);
        }
    }

    public Bot(String file) throws Exception {
        this.net = new Backend(this);
        BufferedReader fin = new BufferedReader(new FileReader(file));
        String line = fin.readLine();
        while (line.startsWith("#")) {
            line = fin.readLine();
        }
        StringTokenizer token = new StringTokenizer(line, " ");
        String host = token.nextToken();
        int port = Integer.parseInt(token.nextToken());
        String name = token.nextToken();
        String room = token.nextToken();
        System.out.println("Connecting to " + host + ":" + port + " as " + name + " in room " + room + ".");
        line = fin.readLine();
        Vector<String> argvec = new Vector<String>();
        while (line != null) {
            if (line.length() == 0 || line.startsWith("#")) {
                line = fin.readLine();
                continue;
            }
            token = new StringTokenizer(line, " ");
            Class<?> consumerClass = Class.forName(token.nextToken());
            Object consumerObject = consumerClass.newInstance();
            if (!(consumerObject instanceof BotConsumer)) {
                System.err.println("Class " + consumerClass + " does not implement BotConsumer");
                continue;
            }
            argvec.removeAllElements();
            while (token.hasMoreTokens()) {
                argvec.addElement(token.nextToken());
            }
            Object[] args = new String[argvec.size()];
            argvec.copyInto(args);
            this.consumers.addElement(consumerObject);
            ((BotConsumer)consumerObject).setData(this.net, (String[])args);
            line = fin.readLine();
        }
        fin.close();
        this.net.connect(host, port, name, name, room);
        Enumeration list = this.consumers.elements();
        while (list.hasMoreElements()) {
            ((BotConsumer)list.nextElement()).start();
        }
    }

    public void handleLOGOUT() {
        System.out.println("LOGOUT received ... shutting down");
        System.exit(0);
    }

    public void handleOBJADD(String name, String url) {
        System.out.println("Avatar " + name + "(" + url + ") added");
        this.net.addConsumer(new ObjectListener(name, false));
    }

    public void handleOBJDEL(String name) {
        this.net.removeConsumer(name);
        System.out.println("Avatar " + name + " removed");
    }

    public void handleROOM(String name, String url) {
    }

    public void handleMSG(String from, String line) {
        System.out.println(String.valueOf(from) + " : " + line);
    }

    public void handleWHOIS(String[] users) {
        System.out.print("Userlist : ");
        int i = 0;
        while (i < users.length) {
            System.out.print(String.valueOf(users[i]) + " ");
            ++i;
        }
        System.out.println("");
    }

    public void handleERROR(String from, String line) {
        System.out.println(String.valueOf(from) + " : " + line);
    }

    public void close() {
        Enumeration list = this.consumers.elements();
        while (list.hasMoreElements()) {
            ((BotConsumer)list.nextElement()).stop();
        }
        this.net.disconnect();
        this.net.close();
    }
}

