/*
 * Decompiled with CFR 0.152.
 */
package tools;

import matrix.deck.ConsumerException;
import matrix.deck.Network;
import matrix.vrml.Field;
import tools.BotConsumer;

public class Chatter
implements BotConsumer,
Runnable {
    private String name;
    private String message;
    private Thread runner;
    private Network postOffice;
    private long pause;

    public void setData(Network network, String[] args) throws ConsumerException {
        this.postOffice = network;
        if (args.length != 3) {
            throw new ConsumerException("args error");
        }
        this.name = args[0];
        try {
            this.pause = Long.valueOf(args[1]);
        }
        catch (NumberFormatException e) {
            throw new ConsumerException("interval not a number");
        }
        this.message = args[2];
        System.out.println("Chatter " + this.name + " with interval " + this.pause + " and msg \"" + this.message + "\" init");
    }

    public String getName() {
        return this.name;
    }

    public synchronized void handleMessage(String tag, Field data) throws ConsumerException {
    }

    public void update() {
    }

    public void start() {
        this.runner = new Thread((Runnable)this, this.name);
        this.runner.start();
        System.out.println("Echo " + this.name + " started");
    }

    public synchronized void stop() {
        this.runner = null;
    }

    public void delete() {
    }

    public synchronized void run() {
        while (Thread.currentThread() == this.runner) {
            try {
                this.postOffice.sendChatMessage(null, this.message);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(this.name) + " error sending chat\n\t" + e);
            }
            try {
                this.wait(this.pause);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

