/*
 * Decompiled with CFR 0.152.
 */
package tools;

import matrix.deck.ConsumerException;
import matrix.deck.Network;
import matrix.vrml.Field;
import matrix.vrml.SFImage;
import tools.BotConsumer;

public class Echo
implements BotConsumer,
Runnable {
    private String name;
    private Thread runner;
    private Network postOffice;
    private long pause;
    private long sum = 0L;
    private long loss = 0L;
    private long start;
    private long step;
    private long stop;
    private long mark;
    private boolean next = true;

    public void setData(Network network, String[] args) throws ConsumerException {
        this.postOffice = network;
        if (args.length != 5) {
            throw new ConsumerException("args error");
        }
        this.name = args[0];
        try {
            this.pause = Long.valueOf(args[1]);
        }
        catch (NumberFormatException e) {
            throw new ConsumerException("sample size not a number");
        }
        try {
            this.start = Long.valueOf(args[2]);
        }
        catch (NumberFormatException e) {
            throw new ConsumerException("start not a number");
        }
        try {
            this.step = Long.valueOf(args[3]);
        }
        catch (NumberFormatException e) {
            throw new ConsumerException("step not a number");
        }
        try {
            this.stop = Long.valueOf(args[4]);
        }
        catch (NumberFormatException e) {
            throw new ConsumerException("stop not a number");
        }
        System.out.println("Echo " + this.name + " with sample " + this.pause + " and size " + this.start + "," + this.step + "," + this.stop + " init");
    }

    public String getName() {
        return this.name;
    }

    public synchronized void handleMessage(String tag, Field data) throws ConsumerException {
        if (!tag.equals(this.name)) {
            throw new ConsumerException(String.valueOf(this.name) + " matches not " + tag);
        }
        this.sum += System.currentTimeMillis() - this.mark;
        this.next = true;
        this.notify();
    }

    public void update() {
    }

    public void start() {
        this.postOffice.addConsumer(this);
        this.runner = new Thread((Runnable)this, this.name);
        this.runner.start();
        System.out.println("Echo " + this.name + " started");
    }

    public synchronized void stop() {
        this.runner = null;
        this.notify();
        this.postOffice.removeConsumer(this.name);
    }

    public void delete() {
    }

    public synchronized void run() {
        this.next = false;
        int i = 0;
        System.out.println("Median delay for last " + this.pause + " messages\n\r ms\tsize");
        while (this.start < this.stop) {
            SFImage data = new SFImage((int)this.start, 1, 1, new byte[(int)this.start]);
            while ((long)i < this.pause) {
                this.mark = System.currentTimeMillis();
                try {
                    this.postOffice.sendRealTime(this.name, data, true);
                }
                catch (Exception e) {
                    System.out.println(String.valueOf(this.name) + " error sending rtm\n\t" + e);
                }
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
                if (this.next) {
                    this.next = false;
                    continue;
                }
                ++this.loss;
            }
            i = 0;
            System.out.println(String.valueOf((double)this.sum / (double)this.pause) + "\t" + this.start + "\t" + this.loss);
            Runtime.getRuntime().gc();
            this.sum = 0L;
            this.loss = 0L;
            this.start += this.step;
        }
        this.postOffice.disconnect();
    }
}

