/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import matrix.deck.Backend;
import matrix.deck.NetworkListener;
import tools.RealTimeListener;

public class NetListener
implements NetworkListener {
    public static final int ERROR = 1;
    public static final int LOGIN = 2;
    public static final int LOGOUT = 4;
    public static final int MSG = 8;
    public static final int NET = 16;
    public static final int OBJADD = 32;
    public static final int OBJDEL = 64;
    public static final int ROOM = 128;
    public static final int UPDATE = 256;
    public static final int WHOIS = 512;
    private Backend net;
    private int select;
    private String startRoom;
    private String file;
    private PrintWriter writer = null;
    private RealTimeListener rtlistener;

    public NetListener(String hostname, int port, String user, String r, boolean c, int w, String f) {
        this.select = w;
        this.file = f;
        this.startRoom = r;
        try {
            this.net = new Backend(this);
        }
        catch (IOException e) {
            System.err.println("Could not inst. Backend !");
            System.exit(1);
        }
        this.rtlistener = new RealTimeListener(this.net, this);
        try {
            this.net.connect(hostname, port, user, user, this.startRoom);
        }
        catch (IOException e) {
            System.err.println("Couldn't connect to " + hostname + " : " + e);
            System.exit(1);
        }
        if (this.file != null) {
            try {
                this.writer = new PrintWriter(new FileOutputStream(this.file));
            }
            catch (Exception e) {
                System.err.println("Could not open file " + this.file + " for logging");
                this.writer = new PrintWriter(System.out);
            }
        } else {
            this.writer = new PrintWriter(System.out);
        }
    }

    public static void main(String[] args) throws Exception {
        String host = "127.0.0.1";
        String name = "spy";
        String file = null;
        String room = null;
        int port = 6666;
        int i = 0;
        int which = 0;
        boolean cooked = false;
        while (i < args.length) {
            String arg;
            if (!args[i].startsWith("-")) {
                System.err.println("Usage: NetListener [-cooked/raw] [-eiomnadruw] [-host ahost] [-port aport] [-name aname] [-file afile] [-room aroom]");
                return;
            }
            if ((arg = args[i++]).equals("-cooked")) {
                System.out.println("cooked mode on");
                cooked = true;
                continue;
            }
            if (arg.equals("-raw")) {
                System.out.println("raw mode on");
                cooked = false;
                continue;
            }
            if (arg.equals("-host")) {
                if (i < args.length) {
                    host = args[i++];
                    continue;
                }
                System.err.println("-host requires a hostname");
                continue;
            }
            if (arg.equals("-port")) {
                if (i < args.length) {
                    try {
                        port = Integer.parseInt(args[i++]);
                    }
                    catch (Exception e) {
                        System.err.println("-port requires numeric argument");
                        port = 6666;
                    }
                    continue;
                }
                System.err.println("-port requires a portnumber");
                continue;
            }
            if (arg.equals("-name")) {
                if (i < args.length) {
                    name = args[i++];
                    continue;
                }
                System.err.println("-name requires a username");
                continue;
            }
            if (arg.equals("-file")) {
                if (i < args.length) {
                    file = args[i++];
                    continue;
                }
                System.err.println("-file requires a filename");
                continue;
            }
            if (arg.equals("-room")) {
                if (i < args.length) {
                    room = args[i++];
                    continue;
                }
                System.err.println("-room requires a roomname");
                continue;
            }
            int j = 1;
            while (j < arg.length()) {
                char flag = arg.charAt(j);
                switch (flag) {
                    case 'e': {
                        which |= 1;
                        break;
                    }
                    case 'i': {
                        which |= 2;
                        break;
                    }
                    case 'o': {
                        which |= 4;
                        break;
                    }
                    case 'm': {
                        which |= 8;
                        break;
                    }
                    case 'n': {
                        which |= 0x10;
                        break;
                    }
                    case 'a': {
                        which |= 0x20;
                        break;
                    }
                    case 'd': {
                        which |= 0x40;
                        break;
                    }
                    case 'r': {
                        which |= 0x80;
                        break;
                    }
                    case 'u': {
                        which |= 0x100;
                        break;
                    }
                    case 'w': {
                        which |= 0x200;
                        break;
                    }
                    default: {
                        System.err.println("NetListener: illegal option " + flag);
                    }
                }
                ++j;
            }
        }
        NetListener me = new NetListener(host, port, name, room, cooked, which, file);
        while (System.in.available() == 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        me.close();
    }

    public void handleLOGOUT() {
        if ((this.select & 4) == 0) {
            this.writeln("LOGOUT message");
        }
        System.exit(0);
    }

    public void handleOBJADD(String name, String url) {
        this.rtlistener.addObject(name);
        if ((this.select & 0x20) == 0) {
            this.writeln("Object " + name + " with URL " + url + " added");
        }
    }

    public void handleOBJDEL(String name) {
        this.rtlistener.removeObject(name);
        if ((this.select & 0x40) == 0) {
            this.writeln("Object " + name + " deleted");
        }
    }

    public void handleROOM(String name, String url) {
        if ((this.select & 0x80) == 0) {
            this.writeln("Room " + name + " with URL " + url);
        }
    }

    public void handleMSG(String from, String line) {
        if ((this.select & 8) == 0) {
            this.writeln(String.valueOf(from) + " : " + line);
        }
    }

    public void handleWHOIS(String[] users) {
        if ((this.select & 0x200) == 0) {
            StringBuffer sb = new StringBuffer("Userlist : ");
            int i = 0;
            while (i < users.length) {
                sb.append(String.valueOf(users[i]) + " ");
                ++i;
            }
            this.writeln(sb.toString());
        }
    }

    public void handleERROR(String from, String line) {
        if ((this.select & 1) == 0) {
            this.writeln("Error : " + from + " - " + line);
        }
    }

    public void writeln(String line) {
        try {
            this.writer.println(line);
            this.writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        this.net.disconnect();
        this.net.close();
    }
}

