/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.util.Hashtable;
import matrix.deck.Backend;
import matrix.deck.ConsumerException;
import matrix.deck.RealTimeConsumer;
import matrix.vrml.Field;
import matrix.vrml.SFRotation;
import matrix.vrml.SFString;
import matrix.vrml.SFVec3f;
import tools.NetListener;

public class RealTimeListener {
    private Backend postOffice;
    private Hashtable listeners;
    private NetListener parent;

    public RealTimeListener(Backend office, NetListener parent) {
        this.postOffice = office;
        this.parent = parent;
        this.listeners = new Hashtable();
    }

    public void addObject(String name) {
        Listener object = new Listener(name);
        this.listeners.put(name, object);
        this.postOffice.addConsumer(object);
    }

    public void removeObject(String name) {
        Listener object = (Listener)this.listeners.get(name);
        if (object != null) {
            object.delete();
            this.postOffice.removeConsumer(name);
            this.listeners.remove(name);
        }
    }

    public void log(String line) {
        this.parent.writeln(line);
    }

    class Listener
    implements RealTimeConsumer {
        private String name;

        public Listener(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void handleMessage(String tag, Field data) throws ConsumerException {
            if (!tag.equals(this.name)) {
                throw new ConsumerException(String.valueOf(this.name) + " matches not " + tag);
            }
            if (data.getType() == 6) {
                float[] rot = ((SFRotation)data).getValue();
                RealTimeListener.this.log(String.valueOf(tag) + " Rot " + rot[0] + " " + rot[1] + " " + rot[2] + " " + rot[3]);
            } else if (data.getType() == 10) {
                float[] vec = ((SFVec3f)data).getValue();
                RealTimeListener.this.log(String.valueOf(tag) + " Vec " + vec[0] + " " + vec[1] + " " + vec[2]);
            } else if (data.getType() == 7) {
                RealTimeListener.this.log(String.valueOf(tag) + " Str " + ((SFString)data).getValue());
            } else {
                RealTimeListener.this.log(String.valueOf(tag) + " " + data.getType());
            }
        }

        public void update() {
        }

        public void delete() {
        }
    }
}

