/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.IOException;
import matrix.deck.ConsumerException;
import matrix.deck.Network;
import matrix.vrml.Field;
import matrix.vrml.SFVec3f;
import tools.BotConsumer;

public class RotBot
implements BotConsumer,
Runnable {
    private String name;
    private String url;
    private Thread runner;
    private Network postOffice;
    private long pause;

    public void setData(Network network, String[] args) throws ConsumerException {
        this.postOffice = network;
        if (args.length != 3) {
            throw new ConsumerException("args error");
        }
        this.name = args[0];
        this.url = args[1];
        try {
            this.pause = Long.valueOf(args[2]);
        }
        catch (NumberFormatException e) {
            throw new ConsumerException("interval not a number");
        }
        System.out.println("RotBot as " + this.name + " with URL " + this.url + " and interval " + this.pause + " init");
    }

    public String getName() {
        return this.name;
    }

    public void handleMessage(String tag, Field data) throws ConsumerException {
        if (!tag.equals(this.name)) {
            throw new ConsumerException(String.valueOf(this.name) + " matches not " + tag);
        }
        System.out.print(String.valueOf(this.name) + ".");
    }

    public void update() {
    }

    public void start() {
        try {
            this.postOffice.addSharedObject(this.name, this.url);
        }
        catch (IOException e) {
            System.err.println(String.valueOf(this.name) + " error adding me " + e);
            return;
        }
        this.postOffice.addConsumer(this);
        this.runner = new Thread((Runnable)this, this.name);
        this.runner.start();
        System.out.println("RotBot " + this.name + " started");
    }

    public void stop() {
        this.runner = null;
        this.postOffice.removeConsumer(this.name);
        try {
            this.postOffice.deleteSharedObject(this.name);
        }
        catch (IOException e) {
            System.err.println(String.valueOf(this.name) + " error deleting me " + e);
            return;
        }
    }

    public void delete() {
    }

    public void run() {
        float[] pos = new float[]{0.0f, 2.0f, 0.0f};
        float radius = 5.0f;
        float phi = 0.0f;
        while (Thread.currentThread() == this.runner) {
            pos[0] = (float)((double)radius * Math.cos(phi));
            pos[2] = (float)((double)radius * Math.sin(phi));
            phi = (float)((double)phi + 0.15707963267948966);
            try {
                this.postOffice.sendRealTime(this.name, new SFVec3f(pos), false);
                Thread.sleep(this.pause);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(this.name) + " error sending rtm\n\t" + e);
            }
        }
    }
}

