/*
 * Decompiled with CFR 0.152.
 */
package tools;

import matrix.deck.ConsumerException;
import matrix.deck.Network;
import matrix.vrml.Field;
import matrix.vrml.SFImage;
import tools.BotConsumer;

public class Send
implements BotConsumer,
Runnable {
    private String name;
    private Thread runner;
    private Network postOffice;
    private long pause;
    private long start;
    private long step;
    private long stop;
    private long mark;

    public void setData(Network network, String[] args) throws ConsumerException {
        this.postOffice = network;
        if (args.length != 5) {
            throw new ConsumerException("args error");
        }
        this.name = args[0];
        try {
            this.pause = Long.valueOf(args[1]);
        }
        catch (NumberFormatException e) {
            throw new ConsumerException("interval not a number");
        }
        try {
            this.start = Long.valueOf(args[2]);
        }
        catch (NumberFormatException e) {
            throw new ConsumerException("start not a number");
        }
        try {
            this.step = Long.valueOf(args[3]);
        }
        catch (NumberFormatException e) {
            throw new ConsumerException("step not a number");
        }
        try {
            this.stop = Long.valueOf(args[4]);
        }
        catch (NumberFormatException e) {
            throw new ConsumerException("stop not a number");
        }
        System.out.println("Send " + this.name + " with sample " + this.pause + " and size " + this.start + "," + this.step + "," + this.stop + " init");
    }

    public String getName() {
        return this.name;
    }

    public void handleMessage(String tag, Field data) throws ConsumerException {
        if (!tag.equals(this.name)) {
            throw new ConsumerException(String.valueOf(this.name) + " matches not " + tag);
        }
    }

    public void update() {
    }

    public void start() {
        this.postOffice.addConsumer(this);
        this.runner = new Thread((Runnable)this, this.name);
        this.runner.start();
        System.out.println("Send " + this.name + " started");
    }

    public void stop() {
        this.runner = null;
        this.postOffice.removeConsumer(this.name);
    }

    public void delete() {
    }

    public void run() {
        int i = 0;
        System.out.println("Median for last " + this.pause + " messages\n\r ms \t size");
        while (this.start < this.stop) {
            SFImage data = new SFImage((int)this.start, 1, 1, new byte[(int)this.start]);
            this.mark = System.currentTimeMillis();
            i = 0;
            while ((long)i < this.pause) {
                try {
                    this.postOffice.sendRealTime(this.name, data, false);
                }
                catch (Exception e) {
                    System.out.println(String.valueOf(this.name) + " error sending rtm\n\t" + e);
                    System.exit(1);
                }
                ++i;
            }
            this.mark = System.currentTimeMillis() - this.mark;
            System.out.println(String.valueOf((double)this.mark / (double)this.pause) + "\t" + this.start);
            this.start += this.step;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.postOffice.disconnect();
    }
}

