/*
 * Decompiled with CFR 0.152.
 */
package client.custom_nodes;

import client.custom_nodes.NetworkState;
import client.matrix.vrml.Field;
import client.matrix.vrml.MFRotation;
import java.io.IOException;
import shout3d.core.FieldObserver;
import shout3d.core.FloatArrayField;
import shout3d.core.Node;

public class NetworkMFRotation
extends NetworkState {
    private float[] initialValue = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    public final FloatArrayField setValue = new FloatArrayField((Node)this, "set_value", 33, this.initialValue);
    public final FloatArrayField valueChanged = new FloatArrayField((Node)this, "value_changed", 33, this.initialValue);

    public NetworkMFRotation() {
        this.setValue.addFieldObserver((FieldObserver)this, null);
        this.valueChanged.addFieldObserver((FieldObserver)this, null);
    }

    protected void finalize() throws Throwable {
        this.setValue.removeFieldObserver((FieldObserver)this);
        this.valueChanged.removeFieldObserver((FieldObserver)this);
        super.finalize();
    }

    public void onFieldChange(shout3d.core.Field theField, Object userData) {
        if (theField == this.setValue) {
            this.update();
            if (this.localCopy.getValue()) {
                this.valueChanged.setValue(this.setValue.getValue());
            }
        } else {
            super.onFieldChange(theField, userData);
        }
    }

    public void handleMessage(String tagName, Field data) {
        if (tagName.equals(this.name) && data.getType() == 15) {
            float[][] val = ((MFRotation)data).getValue();
            float[] newVal = new float[val.length * 4];
            int i = 0;
            while (i < val.length) {
                newVal[4 * i] = val[i][0];
                newVal[4 * i + 1] = val[i][1];
                newVal[4 * i + 2] = val[i][2];
                newVal[4 * i + 3] = val[i][3];
                ++i;
            }
            this.valueChanged.setValue(newVal);
            this.setValue.setValue(newVal);
        }
    }

    public void update() {
        if (this.office == null) {
            return;
        }
        float[] val = this.setValue.getValue();
        float[][] newVal = new float[val.length / 4][4];
        int i = 0;
        while (i < newVal.length) {
            newVal[i][0] = val[i * 4];
            newVal[i][1] = val[i * 4 + 1];
            newVal[i][2] = val[i * 4 + 2];
            newVal[i][3] = val[i * 4 + 3];
            ++i;
        }
        MFRotation value = new MFRotation(newVal);
        try {
            this.office.sendRealTime(this.name, value, this.echo.getValue());
        }
        catch (IOException e) {
            System.out.println(String.valueOf(this.name) + " error sending value " + e);
        }
    }
}

