/*
 * Decompiled with CFR 0.152.
 */
package client.matrix;

import client.matrix.Message;
import client.matrix.vrml.Field;
import client.matrix.vrml.FieldInputStream;
import client.matrix.vrml.FieldOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RealTimeMessage
extends Message {
    public static final int TYPE = 2;
    public String tag = null;
    public Field data = null;
    public boolean echo = true;

    public RealTimeMessage() {
    }

    public RealTimeMessage(String tag, Field data, boolean echo) {
        this.tag = tag;
        this.data = data;
        this.echo = echo;
    }

    public RealTimeMessage(InputStream in) throws IOException {
        this.read(in);
    }

    public int getType() {
        return 2;
    }

    public synchronized void read(InputStream in) throws IOException {
        FieldInputStream fin = new FieldInputStream(in);
        this.tag = fin.readUTF();
        this.echo = fin.readBoolean();
        this.data = fin.readField();
    }

    public synchronized void write(OutputStream out) throws IOException {
        if (this.data == null) {
            throw new IOException("No data in RTMessage");
        }
        if (this.tag == null) {
            throw new IOException("No tag in RTMessage");
        }
        FieldOutputStream fout = new FieldOutputStream(out);
        fout.writeUTF(this.tag);
        fout.writeBoolean(this.echo);
        fout.writeField(this.data);
    }

    public String toString() {
        return String.valueOf(this.tag) + " " + this.echo + " " + this.data;
    }
}

