/*
 * Decompiled with CFR 0.152.
 */
package client.matrix.deck;

import client.matrix.Connection;
import client.matrix.ControlMessage;
import client.matrix.RealTimeMessage;
import client.matrix.deck.Network;
import client.matrix.deck.NetworkListener;
import client.matrix.deck.RealTimeConsumer;
import client.matrix.deck.RealTimeHandler;
import client.matrix.deck.Viewer;
import client.matrix.vrml.Field;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Backend
implements Network,
Runnable {
    private Connection net = new Connection(4096);
    private RealTimeHandler rtThread = new RealTimeHandler();
    private Thread runner = null;
    private int clientID;
    private String name;
    private boolean connected = false;
    private Vector listeners = new Vector();

    public Backend() throws IOException {
    }

    public Backend(NetworkListener listener) throws IOException {
        this.addNetworkListener(listener);
    }

    public void connect(String hostname, int port, String name, String passwd, String room) throws IOException {
        if (this.net.isAlive()) {
            throw new IOException("Allready connected to" + this.net.getInetAddress().getHostName());
        }
        this.name = name;
        this.net.open(hostname, port);
        ControlMessage msg = new ControlMessage(700, "", "");
        while (msg.getCommand() != 100) {
            msg = (ControlMessage)this.net.getMessage();
        }
        msg.setName(name);
        msg.setArg(passwd);
        this.net.sendMessage(msg);
        msg = (ControlMessage)this.net.getMessage();
        if (msg.getCommand() != 700) {
            throw new IOException("Login failed !");
        }
        this.clientID = Integer.parseInt(msg.getArg());
        if (room != null) {
            msg.setCommand(400);
            msg.setName(room);
            msg.setArg("");
            this.net.sendMessage(msg);
        } else {
            msg.setCommand(700);
            msg.setName(name);
            msg.setArg("hello");
            this.net.sendMessage(msg);
        }
        this.runner = new Thread((Runnable)this, "backend");
        this.runner.start();
        this.connected = true;
    }

    public void disconnect() {
        this.connected = false;
        this.clearConsumers();
        if (this.net.isAlive()) {
            try {
                this.net.sendMessage(new ControlMessage(150, this.name, ""));
            }
            catch (IOException e) {
                System.err.println("IOEx in disconnect : " + e);
            }
        } else {
            this.runner = null;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void getStates() throws IOException {
        this.net.sendMessage(new ControlMessage(600, "", ""));
    }

    public void sendChatMessage(String to, String line) throws IOException {
        if (to == null) {
            to = "ALL";
        }
        this.net.sendMessage(new ControlMessage(700, to, line));
    }

    public void addSharedObject(String name, String url) throws IOException {
        this.net.sendMessage(new ControlMessage(200, name, url));
    }

    public void deleteSharedObject(String name) throws IOException {
        this.net.sendMessage(new ControlMessage(210, name, ""));
    }

    public void update(String name) throws IOException {
        this.net.sendMessage(new ControlMessage(600, name, ""));
    }

    public void switchRoom(String name) throws IOException {
        this.net.sendMessage(new ControlMessage(400, name, ""));
    }

    public void whois() throws IOException {
        this.net.sendMessage(new ControlMessage(800, "", ""));
    }

    public void addNetworkListener(NetworkListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeNetworkListener(NetworkListener listener) {
        this.listeners.removeElement(listener);
    }

    public void addConsumer(RealTimeConsumer consumer) {
        this.rtThread.addConsumer(consumer);
    }

    public RealTimeConsumer getConsumer(String name) {
        return this.rtThread.getConsumer(name);
    }

    public void removeConsumer(String name) {
        this.rtThread.removeConsumer(name);
    }

    public Enumeration getConsumers() {
        return this.rtThread.getConsumers();
    }

    public void clearConsumers() {
        this.rtThread.clear();
    }

    public void sendRealTime(String tag, Field data, boolean echo) throws IOException {
        this.net.sendMessage(new RealTimeMessage(tag, data, echo));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try lbl-1000:
            // 5 sources

            {
                block23: while (Thread.currentThread() == this.runner) {
                    try {
                        msg = this.net.getMessage();
                    }
                    catch (InterruptedIOException e) {
                        continue;
                    }
                    switch (msg.getType()) {
                        case 1: {
                            cm = (ControlMessage)msg;
                            switch (cm.getCommand()) {
                                case 600: {
                                    this.rtThread.update(cm.getName());
                                    break;
                                }
                                case 700: {
                                    if (cm.getName().equals(this.name)) break;
                                    list = this.listeners.elements();
                                    while (list.hasMoreElements()) {
                                        ((NetworkListener)list.nextElement()).handleMSG(cm.getName(), cm.getArg());
                                    }
                                    break;
                                }
                                case 200: {
                                    list = this.listeners.elements();
                                    while (list.hasMoreElements()) {
                                        ((NetworkListener)list.nextElement()).handleOBJADD(cm.getName(), cm.getArg());
                                    }
                                    break;
                                }
                                case 210: {
                                    list = this.listeners.elements();
                                    while (list.hasMoreElements()) {
                                        ((NetworkListener)list.nextElement()).handleOBJDEL(cm.getName());
                                    }
                                    break;
                                }
                                case 900: {
                                    list = this.listeners.elements();
                                    while (list.hasMoreElements()) {
                                        ((NetworkListener)list.nextElement()).handleERROR(cm.getName(), cm.getArg());
                                    }
                                    break;
                                }
                                case 800: {
                                    token = new StringTokenizer(cm.getArg(), " ");
                                    users = new Vector<String>();
                                    try {
                                        while (token.hasMoreTokens()) {
                                            users.addElement(token.nextToken());
                                        }
                                    }
                                    catch (NoSuchElementException var6_10) {
                                        // empty catch block
                                    }
                                    arg = new String[users.size()];
                                    i = 0;
                                    while (true) {
                                        if (i >= users.size()) {
                                            list = this.listeners.elements();
                                            break;
                                        }
                                        arg[i] = (String)users.elementAt(i);
                                        ++i;
                                    }
                                    while (list.hasMoreElements()) {
                                        ((NetworkListener)list.nextElement()).handleWHOIS(arg);
                                    }
                                    break;
                                }
                                case 400: {
                                    list = this.listeners.elements();
                                    while (list.hasMoreElements()) {
                                        ((NetworkListener)list.nextElement()).handleROOM(cm.getName(), cm.getArg());
                                    }
                                    break;
                                }
                                case 150: {
                                    this.runner = null;
                                    list = this.listeners.elements();
                                    while (list.hasMoreElements()) {
                                        ((NetworkListener)list.nextElement()).handleLOGOUT();
                                    }
                                    break;
                                }
                                default: {
                                    System.err.println("unrecognized/not handled Message " + cm);
                                    break;
                                }
                            }
                            continue block23;
                        }
                        case 2: {
                            this.rtThread.handle((RealTimeMessage)msg);
                            ** break;
                        }
                    }
                    System.err.println("unknown message type " + msg);
                }
                ** GOTO lbl-1000
            }
            catch (IOException e) {
                System.err.println("error listening in main loop\n\t" + e);
                this.disconnect();
                list = this.listeners.elements();
            }
            while (list.hasMoreElements()) {
                ((NetworkListener)list.nextElement()).handleLOGOUT();
            }
        }
        catch (Throwable var9_12) {
            var8_13 = null;
            this.net.close();
            throw var9_12;
        }
lbl-1000:
        // 2 sources

        {
            var8_14 = null;
            this.net.close();
            return;
        }
    }

    public void setViewer(Viewer viewer) {
        if (this.rtThread != null) {
            this.rtThread.setViewer(viewer);
        }
    }

    public void close() {
        this.rtThread.close();
    }
}

