/*
 * Decompiled with CFR 0.152.
 */
package client.matrix.deck;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;

public class BorderPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final int NONE = 0;
    public static final int PLAIN = 1;
    public static final int ETCHED_IN = 2;
    public static final int ETCHED_OUT = 3;
    public static final int RAISED = 4;
    public static final int LOWERED = 5;
    protected int style = 1;
    int innerMargin = 3;
    int outerMargin = 3;

    public BorderPanel() {
    }

    public BorderPanel(int style) {
        this.style = style;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
        this.repaint();
    }

    public int getInnerMargin() {
        return this.innerMargin;
    }

    public void setInnerMargin(int innerMargin) {
        this.innerMargin = innerMargin;
        this.repaint();
    }

    public int getOuterMargin() {
        return this.outerMargin;
    }

    public void setOuterMargin(int outerMargin) {
        this.outerMargin = outerMargin;
        this.repaint();
    }

    public Insets getInsets() {
        int width;
        switch (this.style) {
            case 0: {
                width = 0;
                break;
            }
            case 1: {
                width = 1;
                break;
            }
            default: {
                width = 2;
            }
        }
        width += this.innerMargin;
        return new Insets(width += this.outerMargin, width, width, width);
    }

    public Insets insets() {
        return this.getInsets();
    }

    public void paint(Graphics g) {
        switch (this.style) {
            case 0: {
                this.drawNone();
                break;
            }
            case 2: {
                this.drawEtched(g, this.darkerColor(), this.brighterColor());
                break;
            }
            case 3: {
                this.drawEtched(g, this.brighterColor(), this.darkerColor());
                break;
            }
            case 4: {
                this.draw3d(g, this.brighterColor(), this.darkerColor());
                break;
            }
            case 5: {
                this.draw3d(g, this.darkerColor(), this.brighterColor());
                break;
            }
            default: {
                this.drawPlain(g);
            }
        }
    }

    protected void drawNone() {
    }

    protected void drawPlain(Graphics g) {
        Dimension size = this.getSize();
        int x = this.outerMargin;
        int y = this.outerMargin;
        int width = size.width - 2 * this.outerMargin - 1;
        int height = size.height - 2 * this.outerMargin - 1;
        g.drawRect(x, y, width, height);
    }

    protected void drawEtched(Graphics g, Color upperLeftColor, Color lowerRightColor) {
        Dimension size = this.getSize();
        g.setColor(upperLeftColor);
        int x = this.outerMargin;
        int y = this.outerMargin;
        int width = size.width - 2 * this.outerMargin - 2;
        int height = size.height - 2 * this.outerMargin - 2;
        g.drawRect(x, y, width, height);
        g.setColor(lowerRightColor);
        g.drawRect(x + 1, y + 1, width, height);
    }

    protected void draw3d(Graphics g, Color upperLeftColor, Color lowerRightColor) {
        int i = 0;
        while (i < 2) {
            Dimension size = this.getSize();
            int x1 = i + this.outerMargin;
            int y1 = i + this.outerMargin;
            int x2 = size.width - i - this.outerMargin - 1;
            int y2 = size.height - i - this.outerMargin - 1;
            g.setColor(upperLeftColor);
            g.drawLine(x1, y1, x2, y1);
            g.drawLine(x1, y1, x1, y2);
            g.setColor(lowerRightColor);
            g.drawLine(x2, y1, x2, y2);
            g.drawLine(x1, y2, x2, y2);
            ++i;
        }
    }

    protected Color brighterColor() {
        return this.getBackground().brighter();
    }

    protected Color darkerColor() {
        return this.getBackground().darker();
    }
}

