/*
 * Decompiled with CFR 0.152.
 */
package client.matrix.deck.eai;

import client.matrix.deck.ConsumerException;
import client.matrix.deck.Network;
import client.matrix.deck.RealTimeConsumer;
import client.matrix.deck.eai.Route;
import client.matrix.deck.eai.SO;
import client.matrix.vrml.Field;
import client.matrix.vrml.SFRotation;
import client.matrix.vrml.SFVec3f;
import java.util.Enumeration;
import java.util.Vector;
import vrml.external.Browser;
import vrml.external.Node;
import vrml.external.exception.InvalidEventOutException;
import vrml.external.field.EventInMFNode;
import vrml.external.field.EventInSFRotation;
import vrml.external.field.EventInSFVec3f;
import vrml.external.field.EventOut;
import vrml.external.field.EventOutMFNode;

public class Avatar
implements RealTimeConsumer {
    private String name;
    private Node avatar = null;
    private int counter = 0;
    private EventInSFVec3f pos;
    private EventInSFRotation rot;
    private Network postOffice;
    private Vector states = new Vector();

    public Avatar(SO object, Browser browser, Network postOffice) throws RuntimeException {
        this.name = object.getName();
        this.postOffice = postOffice;
        Node xform = object.getTransform();
        Node[] nodes = ((EventOutMFNode)xform.getEventOut("children_changed")).getValue();
        if (nodes == null) {
            System.out.println(String.valueOf(this.name) + " nodes not loaded !");
            return;
        }
        if (nodes[0].getType().equals("SharedObject")) {
            Node soNode = nodes[0];
            Node[] statesVal = ((EventOutMFNode)soNode.getEventOut("states_changed")).getValue();
            System.out.println(String.valueOf(this.name) + " is shared object with " + statesVal.length + " states.");
            if (statesVal.length != 0) {
                int i = 0;
                while (i < statesVal.length) {
                    if (statesVal[i].getType().startsWith("Network")) {
                        Route route = new Route(statesVal[i], postOffice);
                        route.setName(String.valueOf(this.name) + "_" + route.getName());
                        postOffice.addConsumer(route);
                        this.states.addElement(route);
                    }
                    ++i;
                }
            }
            Node[] help = browser.createVrmlFromString("Transform { children [ Transform { translation 0 3 0 children [ Billboard { children [ Shape { geometry Text { string [\"" + this.name.substring(1) + "\"] maxExtent 4" + "fontStyle FontStyle { family [\"SANS\"] justify \"MIDDLE\" } }" + "}" + "]}" + "]}" + "]}");
            ((EventInMFNode)xform.getEventIn("addChildren")).setValue(help);
            browser.addRoute(soNode, "position_changed", help[0], "set_translation");
            browser.addRoute(soNode, "orientation_changed", help[0], "set_rotation");
            this.pos = (EventInSFVec3f)soNode.getEventIn("set_position");
            this.rot = (EventInSFRotation)soNode.getEventIn("set_orientation");
        } else {
            Node[] help = browser.createVrmlFromString("PROTO Avatar [eventIn SFVec3f translation eventIn SFRotation rotation exposedField MFNode children [] ]{ Transform { translation IS translation rotation IS rotation children [ Transform { rotation 0 1 0 3.141592 children IS children }, Transform { children [ Transform { translation 0 3 0 children [ Billboard { children [ Shape { geometry Text { string [\"" + this.name.substring(1) + "\"] maxExtent 4" + "fontStyle FontStyle { family [\"SANS\"] justify \"MIDDLE\" } }" + "}" + "]}" + "]}" + "]}" + "]}" + "}" + "Avatar {} ");
            Node anchor = help[0];
            ((EventInMFNode)anchor.getEventIn("set_children")).setValue(nodes);
            ((EventInMFNode)xform.getEventIn("set_children")).setValue(help);
            this.pos = (EventInSFVec3f)anchor.getEventIn("translation");
            this.rot = (EventInSFRotation)anchor.getEventIn("rotation");
        }
        try {
            EventOut field = nodes[0].getEventOut("gestures");
            if (field == null) {
                throw new InvalidEventOutException();
            }
            if (field.getType() != 15) {
                throw new InvalidEventOutException();
            }
            this.avatar = nodes[0];
            System.out.println(String.valueOf(this.name) + " is BOMU avatar");
        }
        catch (InvalidEventOutException e) {
            this.avatar = null;
            System.out.println(String.valueOf(this.name) + " is not BOMU VRML");
        }
        catch (NullPointerException e) {
            this.avatar = null;
            System.out.println(String.valueOf(this.name) + " is not BOMU VRML");
        }
    }

    public String getName() {
        return this.name;
    }

    public void handleMessage(String tag, Field data) throws ConsumerException {
        block5: {
            if (!tag.equals(this.name)) {
                throw new ConsumerException(String.valueOf(this.name) + " is not equal to " + tag);
            }
            try {
                if (data.getType() == 10) {
                    this.pos.setValue(((SFVec3f)data).getValue());
                    break block5;
                }
                if (data.getType() == 6) {
                    this.rot.setValue(((SFRotation)data).getValue());
                    break block5;
                }
                throw new ConsumerException("Wrong field type for " + this.name);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error moving " + this.name + " " + e);
            }
        }
    }

    public void update() {
    }

    public void delete() throws RuntimeException {
        Enumeration list = this.states.elements();
        while (list.hasMoreElements()) {
            this.postOffice.removeConsumer(((Route)list.nextElement()).getName());
        }
        this.states.removeAllElements();
    }
}

