/*
 * Decompiled with CFR 0.152.
 */
package client.matrix.deck.eai;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class HttpRequestParser {
    String httpRequest;

    public HttpRequestParser(FileInputStream httpRequest) throws IOException {
        String line = null;
        BufferedReader buf = new BufferedReader(new InputStreamReader(httpRequest));
        while ((line = buf.readLine()) != null) {
            this.httpRequest = String.valueOf(this.httpRequest) + line + "\n";
        }
    }

    public String getServerAddress() throws IOException {
        StringTokenizer tok;
        String line = null;
        String address = null;
        BufferedReader buf = new BufferedReader(new StringReader(this.httpRequest));
        while ((line = buf.readLine()) != null) {
            tok = new StringTokenizer(line);
            while (tok.hasMoreElements()) {
                if (tok.nextToken().compareTo("Host:") != 0) continue;
                address = tok.nextToken();
                break;
            }
            if (address != null) break;
        }
        if (address != null) {
            if (address.indexOf(91) != -1) {
                if (address.indexOf(93) == -1 || address.indexOf(91) != 0) {
                    throw new IOException("Invalid format for IPv6 address!");
                }
                address = address.substring(1, address.indexOf(93));
            } else {
                tok = new StringTokenizer(address, ":");
                try {
                    address = tok.nextToken();
                }
                catch (NoSuchElementException nsee) {
                    throw new IOException("Invalid format for IPv4 address!");
                }
            }
        }
        try {
            buf.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return address;
    }

    public String getServerPort() throws IOException {
        String line = null;
        String port = null;
        BufferedReader buf = new BufferedReader(new StringReader(this.httpRequest));
        while ((line = buf.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line);
            while (tok.hasMoreElements()) {
                if (tok.nextToken().compareTo("Host:") != 0) continue;
                port = tok.nextToken();
                break;
            }
            if (port != null) break;
        }
        if (port != null) {
            if (port.indexOf(58) == -1) {
                throw new IOException("Port number missing or invalid format!");
            }
            try {
                port = port.substring(port.lastIndexOf(58) + 1, port.length());
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new IOException("Port number missing!");
            }
        }
        try {
            buf.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return port;
    }
}

