/*
 * Decompiled with CFR 0.152.
 */
package client.matrix.deck.eai;

import client.matrix.deck.ConsumerException;
import client.matrix.deck.Network;
import client.matrix.deck.RealTimeConsumer;
import client.matrix.vrml.Field;
import client.matrix.vrml.InvalidFieldException;
import java.io.IOException;
import vrml.external.Node;
import vrml.external.field.EventIn;
import vrml.external.field.EventOut;
import vrml.external.field.EventOutObserver;
import vrml.external.field.EventOutSFBool;
import vrml.external.field.EventOutSFString;

public class Route
implements RealTimeConsumer,
EventOutObserver,
Runnable {
    private String name;
    private Node myNode;
    private boolean continous = false;
    private boolean valChanged = false;
    private boolean echo = false;
    private boolean dead = false;
    private EventOut callingEvent;
    private EventIn fromnet;
    private Network postOffice;
    private Field val = null;
    private Field lastVal = null;
    private int type;
    private Thread runner = null;

    public Route(Node netnode, Network office) throws RuntimeException {
        this.postOffice = office;
        this.myNode = netnode;
        this.name = ((EventOutSFString)this.myNode.getEventOut("tag")).getValue();
        this.continous = ((EventOutSFBool)this.myNode.getEventOut("cont")).getValue();
        this.echo = ((EventOutSFBool)this.myNode.getEventOut("echo")).getValue();
        this.callingEvent = this.myNode.getEventOut("value_tonet");
        this.fromnet = this.myNode.getEventIn("value_fromnet");
        this.type = this.callingEvent.getType();
        this.callingEvent.advise((EventOutObserver)this, (Object)new Integer(0));
        try {
            this.lastVal = Field.makeField(this.callingEvent);
        }
        catch (InvalidFieldException e) {
            System.err.println("Route " + this.name + " exeption in constructor " + e);
        }
        if (this.continous) {
            this.runner = new Thread((Runnable)this, this.name);
            this.runner.start();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void handleMessage(String tag, Field data) throws ConsumerException {
        if (!tag.equals(this.name)) {
            throw new ConsumerException(String.valueOf(this.name) + " matches not " + tag);
        }
        try {
            Field.setEventIn(this.fromnet, data);
            this.lastVal = data;
        }
        catch (Exception e) {
            throw new ConsumerException(String.valueOf(this.name) + "\n\t" + e);
        }
    }

    public void update() {
        try {
            if (this.lastVal != null) {
                this.postOffice.sendRealTime(this.name, this.lastVal, false);
            }
        }
        catch (IOException e) {
            System.err.println("IOEx in route " + this.name + "\n\t" + e);
        }
    }

    public void run() {
        while (Thread.currentThread() == this.runner) {
            try {
                if (this.valChanged) {
                    this.postOffice.sendRealTime(this.name, this.val, this.echo);
                    this.lastVal = this.val;
                    this.valChanged = false;
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException e) {
                System.err.println("IOEx in route " + this.name + ".run\n\t" + e);
            }
        }
    }

    public void callback(EventOut value, double time, Object data) {
        if (this.dead) {
            return;
        }
        try {
            if (value == null) {
                System.err.println("Got null value from " + this.name);
                return;
            }
            if (!(value instanceof EventOut)) {
                System.err.println("value of class " + value.getClass().getName() + " from " + this.name);
                return;
            }
            this.val = Field.makeField(value);
            if (!this.continous) {
                this.postOffice.sendRealTime(this.name, this.val, this.echo);
                this.lastVal = this.val;
                this.valChanged = false;
            } else {
                this.valChanged = true;
            }
        }
        catch (Exception e) {
            System.err.println("Error converting msg from " + data + ":" + e);
            return;
        }
    }

    public void delete() throws RuntimeException {
        this.runner = null;
        this.dead = true;
    }
}

