/*
 * Decompiled with CFR 0.152.
 */
package client.matrix.deck.eai;

import client.matrix.deck.eai.SdpFileReader;
import client.matrix.deck.eai.SignalingEventListenerImpl;
import client.matrix.guiClient.ClientFrame;
import hr.fer.tel.nims.dsa.client.SignalingAgent;
import hr.fer.tel.nims.dsa.client.SignalingAgentException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import javax.swing.JOptionPane;

public class ServiceHandling
extends Thread {
    private boolean errorFlag = false;
    protected ClientFrame frame;
    private SignalingAgent signalingAgent = null;
    private boolean finalProfileReceived = false;
    private SignalingEventListenerImpl signalingEventListenerImpl;
    private Socket socket = null;
    private Process pr;
    private OutputStream socketOutput = null;
    private InputStream socketInput = null;
    public static final String receiveFile = "ReceiveFile";
    private String serverFile;
    public static final String MatrixAudioVideo = "UMTS_PCHQ_gallery.txt";
    public static final String MatrixAudioOnly = "GPRS_PCHQ_gallery.txt";
    public static final String MatrixWorldOnly = "GPRS_IPAQ_gallery.txt";
    public static final String MatrixWithoutTexturesLQ = "UMTSLow_PCHQ_gallery.txt";

    public ServiceHandling(SignalingAgent signalingAgent, SignalingEventListenerImpl signalingEventListenerImpl) {
        this.signalingEventListenerImpl = signalingEventListenerImpl;
        this.signalingAgent = signalingAgent;
    }

    public void run() {
        System.out.println("Point 5");
        this.frame = new ClientFrame(this);
        System.out.println("Point 6");
    }

    public synchronized void accessService(String profileFileName, String serviceSipUri) {
        block14: {
            String profileString;
            File profileFile;
            FileInputStream terminalCapAndUserPref = null;
            try {
                System.out.println("The profile (request) to be sent: " + profileFileName);
                terminalCapAndUserPref = new FileInputStream(profileFileName);
                this.signalingEventListenerImpl.setProfileFileName(profileFileName);
            }
            catch (FileNotFoundException fnfe) {
                JOptionPane.showMessageDialog(this.frame, "Could not find the request file!", "File Not Found", 0);
                this.frame.setEnabledjMenuMatrix(true);
                return;
            }
            try {
                profileFile = new File(profileFileName);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
                System.out.println("Pathname argument is null!");
                return;
            }
            try {
                profileString = new SdpFileReader(profileFile).getFileText();
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                System.out.println("The specified file doesn't exist!");
                return;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
            try {
                this.signalingAgent.setUserName("branko");
                try {
                    if (serviceSipUri != null) {
                        this.signalingAgent.setServiceSIPURI(serviceSipUri);
                        this.signalingAgent.establishSession(profileString);
                        break block14;
                    }
                    this.signalingAgent.changeInClientProfile(profileString);
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                }
                catch (ClassCastException cce) {
                    cce.printStackTrace();
                }
                catch (SignalingAgentException sae) {
                    sae.printStackTrace();
                }
            }
            catch (SecurityException se) {
                se.printStackTrace();
                JOptionPane.showMessageDialog(this.frame, "Insufficient clearance for opening the socket!", "Security Exception", 0);
                this.closeFile(terminalCapAndUserPref);
                this.frame.setEnabledjMenuMatrix(true);
                return;
            }
        }
    }

    public void closeFile(FileInputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public ClientFrame getFrame() {
        return this.frame;
    }

    public boolean isFinalProfileReceived() {
        return this.finalProfileReceived;
    }

    public void setFinalProfileReceived(boolean finalProfileReceived) {
        this.finalProfileReceived = finalProfileReceived;
    }

    protected void httpResponseReceived(String response) {
        this.frame.setEnabledjMenuMatrix(true);
        if (response.compareTo("wrl") != 0 && response.compareTo("wml") != 0 && response.compareTo("html") != 0) {
            JOptionPane.showMessageDialog(this.frame, "The server has indicated an error!\n" + response, "Error Sent from Server", 0);
            this.closeSocket();
            return;
        }
        try {
            String tag;
            this.closeSocket();
            System.out.println("Sad bih trebao pokrenuti IE.");
            FileReader fr = new FileReader(this.serverFile);
            BufferedReader bf = new BufferedReader(fr);
            while (!(tag = bf.readLine()).equals("<HTML>")) {
            }
            tag = bf.readLine();
            String errorMessage = this.exec("C:\\PROGRA~1\\INTERN~1\\IEXPLORE " + tag);
            if (errorMessage != null) {
                JOptionPane.showMessageDialog(this.frame, "The following error occured while executing the command:\n" + errorMessage, "Execution Error", 0);
            }
            return;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "Unable to execute command!\nDoes the file exist?", "I/O Exception", 0);
            return;
        }
        catch (SecurityException se) {
            se.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "Insufficient clearance for starting IE!", "Security Exception", 0);
            return;
        }
    }

    private String exec(String command) throws IOException, SecurityException {
        String error = new String();
        String line = null;
        System.out.println("Executing comand: " + command);
        Runtime runt = Runtime.getRuntime();
        if (this.pr != null) {
            this.pr.destroy();
        }
        this.pr = runt.exec(command);
        InputStream in = this.pr.getErrorStream();
        BufferedReader buf = new BufferedReader(new InputStreamReader(in));
        if (buf.ready()) {
            line = buf.readLine();
        }
        if (line != null) {
            while (line != null) {
                error = String.valueOf(error) + line;
                line = buf.readLine();
            }
            try {
                buf.close();
                in.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return error;
        }
        return null;
    }

    protected void closeSocket() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            if (this.socketInput != null) {
                this.socketInput.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            if (this.socketOutput != null) {
                this.socketOutput.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String getServerFile() {
        return this.serverFile;
    }

    public void setServerFile(String serverFile) {
        this.serverFile = serverFile;
    }
}

