/*
 * Decompiled with CFR 0.152.
 */
package client.matrix.deck.eai;

import client.matrix.deck.eai.HttpRequestParser;
import client.matrix.deck.eai.ServiceHandling;
import client.matrix.deck.eai.Transceiver;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class ServiceRequestInitiator {
    private ServiceHandling serviceMatchingClient;
    private String requestFile;
    private Transceiver requestSender;
    private Socket socket;
    private InputStream socketInput;
    private OutputStream socketOutput;
    private boolean flag;

    public ServiceRequestInitiator(ServiceHandling serviceMatchingClient, String requestFile, boolean flag) {
        this.serviceMatchingClient = serviceMatchingClient;
        this.requestFile = requestFile;
        this.flag = flag;
    }

    public void run(String callId) {
        FileInputStream httpRequest = null;
        String serverAddress = null;
        String serverPort = null;
        try {
            Object line = null;
            System.out.println("\nThe request to be sent to the server: \n" + this.requestFile);
            httpRequest = new FileInputStream(this.requestFile);
            HttpRequestParser requestParser = new HttpRequestParser(httpRequest);
            serverAddress = requestParser.getServerAddress();
            serverPort = requestParser.getServerPort();
            if (serverAddress == null || serverPort == null) {
                System.out.println("Couldn't find the server's address in the properties file!");
                this.serviceMatchingClient.closeFile(httpRequest);
                return;
            }
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Couldn't find the request file!");
            return;
        }
        catch (IOException ioe) {
            System.out.println("Error reading the request file!");
            this.serviceMatchingClient.closeFile(httpRequest);
            return;
        }
        System.out.println("Sending service request to the NVR content server....");
        try {
            this.socket = new Socket(InetAddress.getByName(serverAddress), (int)new Integer(serverPort));
            this.socket.setKeepAlive(true);
            System.out.print("\nDSAM Client's socket opened to " + this.socket.getInetAddress().getHostName());
            System.out.println(":" + this.socket.getPort());
            this.socketOutput = this.socket.getOutputStream();
            System.out.println("\tSocket output stream opened");
            this.socketInput = this.socket.getInputStream();
            System.out.println("\tSocket input stream opened");
            this.requestSender = new Transceiver(this.serviceMatchingClient, this.socketInput, this.socketOutput, httpRequest, callId);
            if (this.flag) {
                this.requestSender.run();
            }
            this.closeSocket();
            this.serviceMatchingClient.closeFile(httpRequest);
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
            System.out.println("The server's IP address could not be determined!");
            this.serviceMatchingClient.closeFile(httpRequest);
            return;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.closeSocket();
            this.serviceMatchingClient.closeFile(httpRequest);
            return;
        }
    }

    private void closeSocket() {
        try {
            if (this.socketInput != null) {
                this.socketInput.close();
            }
            if (this.socketOutput != null) {
                this.socketOutput.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

