/*
 * Decompiled with CFR 0.152.
 */
package client.matrix.deck.eai;

import client.matrix.deck.eai.NegotiationDialog;
import client.matrix.deck.eai.ServiceHandling;
import client.matrix.deck.eai.ServiceRequestInitiator;
import hr.fer.tel.nims.dsa.client.SignalingAgent;
import hr.fer.tel.nims.dsa.client.SignalingAgentException;
import hr.fer.tel.nims.dsa.client.SignalingEventListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SignalingEventListenerImpl
implements SignalingEventListener {
    private SignalingAgent signalingAgent;
    private String profileFileName;
    private String serviceDescription;
    private String version = null;
    private ServiceRequestInitiator serviceRequestInitiator;
    private ServiceHandling serviceHandling;

    public void handleServiceRequirementsChangedEvent(String message) {
        System.out.println("Uspjesno poslana update poruka.");
        System.out.println(message);
    }

    public void handleSessionEstablishedEvent(String serviceDescription) {
        System.out.println("Session successfully established");
        this.serviceDescription = serviceDescription;
        if (this.serviceDescription.contains("gallery1")) {
            this.version = "gallery1";
        } else if (this.serviceDescription.contains("gallery2")) {
            this.version = "gallery2";
        } else if (this.serviceDescription.contains("gallery3")) {
            this.version = "gallery3";
        } else if (this.serviceDescription.contains("gallery4")) {
            this.version = "gallery4";
        }
        this.serviceRequestInitiator = new ServiceRequestInitiator(this.serviceHandling, this.profileFileName, true);
        try {
            this.serviceRequestInitiator.run(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        StringBuffer contentString = null;
        try {
            contentString = new StringBuffer();
            String contentFile = "establishedupdatecontent.txt";
            File file = new File(contentFile);
            FileReader reader = new FileReader(file);
            int charRead = reader.read();
            while (charRead != -1) {
                contentString.append((char)charRead);
                charRead = reader.read();
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            this.signalingAgent.changeInServiceRequirements(contentString.toString());
        }
        catch (SignalingAgentException e) {
            e.printStackTrace();
        }
    }

    public void handleSessionUpdatedEvent(String serviceDescription) {
        boolean sendUpdate = false;
        System.out.println("Uspjesno updateana sjednica.");
        this.serviceDescription = serviceDescription;
        if (this.serviceDescription.contains("gallery1")) {
            if (!this.version.equals("gallery1")) {
                sendUpdate = true;
                this.version = "gallery1";
            }
        } else if (this.serviceDescription.contains("gallery2")) {
            if (!this.version.equals("gallery2")) {
                sendUpdate = true;
                this.version = "gallery2";
            }
        } else if (this.serviceDescription.contains("gallery3")) {
            if (!this.version.equals("gallery3")) {
                sendUpdate = true;
                this.version = "gallery3";
            }
        } else if (this.serviceDescription.contains("gallery4") && !this.version.equals("gallery4")) {
            sendUpdate = true;
            this.version = "gallery4";
        }
        if (sendUpdate) {
            StringBuffer contentString = null;
            try {
                contentString = new StringBuffer();
                String contentFile = "establishedupdatecontent.txt";
                File file = new File(contentFile);
                FileReader reader = new FileReader(file);
                int charRead = reader.read();
                while (charRead != -1) {
                    contentString.append((char)charRead);
                    charRead = reader.read();
                }
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            try {
                this.signalingAgent.changeInServiceRequirements(contentString.toString());
            }
            catch (SignalingAgentException e) {
                e.printStackTrace();
            }
        }
    }

    public void handleSessionEstablishmentFailedEvent(String message) {
        System.out.println("Neuspjesno uspostavljena sjednica.");
        System.out.println(message);
    }

    public void setSignalingAgent(SignalingAgent signalingAgent) {
        this.signalingAgent = signalingAgent;
    }

    public void setServiceHandling(ServiceHandling serviceHandling) {
        this.serviceHandling = serviceHandling;
    }

    public String getProfileFileName() {
        return this.profileFileName;
    }

    public void setProfileFileName(String profileFileName) {
        this.profileFileName = profileFileName;
    }

    public void handleSessionUpdateFailedEvent(String message) {
        System.out.println("Sjednica neuspjesno updateana...");
        System.out.println(message);
    }

    public void handleClientRegisteredEvent() {
    }

    public void handleClientRegistrationFailedEvent() {
    }

    public void handleSessionTerminatedEvent() {
    }

    public void handleSessionParameterOffer(String sdpParameters) {
        NegotiationDialog snd = new NegotiationDialog(this.signalingAgent, "Call incoming diaog", true, sdpParameters);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension sndSize = snd.getSize();
        if (screenSize.getHeight() < sndSize.getHeight()) {
            sndSize.height = screenSize.height;
        }
        if (screenSize.getWidth() < sndSize.getWidth()) {
            sndSize.width = screenSize.width;
        }
        ((Component)snd).setLocation((screenSize.width - sndSize.width) / 2, (screenSize.height - sndSize.height) / 2);
        ((Component)snd).setVisible(true);
    }
}

