/*
 * Decompiled with CFR 0.152.
 */
package client.matrix.deck.eai;

import client.matrix.deck.ConsumerException;
import client.matrix.deck.Network;
import client.matrix.deck.RealTimeConsumer;
import client.matrix.deck.eai.Beta;
import client.matrix.deck.eai.Route;
import client.matrix.deck.eai.SO;
import client.matrix.vrml.Field;
import client.matrix.vrml.SFRotation;
import client.matrix.vrml.SFString;
import client.matrix.vrml.SFVec3f;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import vrml.external.Browser;
import vrml.external.Node;
import vrml.external.exception.InvalidEventOutException;
import vrml.external.field.EventInMFNode;
import vrml.external.field.EventInSFBool;
import vrml.external.field.EventInSFInt32;
import vrml.external.field.EventInSFRotation;
import vrml.external.field.EventInSFVec3f;
import vrml.external.field.EventOut;
import vrml.external.field.EventOutMFNode;
import vrml.external.field.EventOutMFString;
import vrml.external.field.EventOutObserver;
import vrml.external.field.EventOutSFRotation;
import vrml.external.field.EventOutSFString;
import vrml.external.field.EventOutSFVec3f;

public class UserAvatar
implements RealTimeConsumer,
EventOutObserver,
Runnable {
    private String name;
    private Network postOffice;
    private boolean show = false;
    private Node proxy;
    private Node avatar = null;
    private EventInSFBool bind;
    private EventInSFVec3f pos;
    private EventInSFRotation rot;
    private EventInSFInt32 which;
    private SFVec3f offset = new SFVec3f(0.0f, -1.6f, 0.0f);
    private SFVec3f posVal;
    private SFRotation rotVal;
    private Vector states = new Vector();
    private EventOut proxyPos;
    private EventOut proxyRot;
    private EventOut ch;
    private boolean posChanged = false;
    private boolean rotChanged = false;
    private boolean dead = false;
    private Thread runner = null;
    private String inMotionBehaviour;
    private String notInMotionBehaviour = null;
    private Date lastMoved = null;

    public UserAvatar(SO object, Network post, Browser browser, Node prox, Beta deck) throws RuntimeException {
        this.name = object.getName();
        this.postOffice = post;
        this.proxy = prox;
        Node xform = object.getTransform();
        Node[] nodes = ((EventOutMFNode)xform.getEventOut("children_changed")).getValue();
        if (nodes == null) {
            System.out.println(String.valueOf(this.name) + " nodes not loaded !");
            return;
        }
        if (nodes[0].getType().equals("SharedObject")) {
            Node soNode = nodes[0];
            Node[] statesVal = ((EventOutMFNode)soNode.getEventOut("states_changed")).getValue();
            System.out.println(String.valueOf(this.name) + " is shared object with " + statesVal.length + " states.");
            if (statesVal.length != 0) {
                int i = 0;
                while (i < statesVal.length) {
                    if (statesVal[i].getType().startsWith("Network")) {
                        Route route = new Route(statesVal[i], this.postOffice);
                        route.setName(String.valueOf(this.name) + "_" + route.getName());
                        this.postOffice.addConsumer(route);
                        this.states.addElement(route);
                    }
                    ++i;
                }
            }
        }
        Node[] help = browser.createVrmlFromString("PROTO Avatar [eventIn SFVec3f position eventIn SFRotation rotation exposedField MFNode children []eventIn SFBool bind eventIn SFInt32 which ] { Switch { whichChoice IS which choice [Collision { collide FALSE children [Transform { translation IS position rotation IS rotation children [ Transform { rotation 0 1 0 3.141592 children IS children }, Transform { children [ Transform { translation 0 3 0 children [ Billboard { children [ Shape { geometry Text { string [\"" + this.name.substring(1) + "\"] maxExtent 4" + "fontStyle FontStyle { family [\"SANS\"] justify \"MIDDLE\" } }" + "}" + "]}]" + "}]}," + "Viewpoint { set_bind IS bind " + "jump TRUE " + "position 0 3 5 " + "} " + "] }" + "] }" + " ] " + "} }" + "Avatar {} ");
        try {
            EventOut field = nodes[0].getEventOut("gestures");
            if (field == null) {
                throw new InvalidEventOutException();
            }
            if (field.getType() != 15) {
                throw new InvalidEventOutException();
            }
            deck.addBehavs(((EventOutMFString)field).getValue());
            this.avatar = nodes[0];
            System.out.println(String.valueOf(this.name) + " is BOMU avatar");
        }
        catch (InvalidEventOutException e) {
            this.avatar = null;
            System.out.println(String.valueOf(this.name) + " is not BOMU VRML");
        }
        catch (NullPointerException e) {
            this.avatar = null;
            System.out.println(String.valueOf(this.name) + " is not BOMU VRML");
        }
        if (this.avatar != null) {
            try {
                this.inMotionBehaviour = ((EventOutSFString)nodes[0].getEventOut("inMotionBehaviour")).getValue();
                this.notInMotionBehaviour = ((EventOutSFString)nodes[0].getEventOut("notInMotionBehaviour")).getValue();
                System.out.println("inMotionBehaviour -> " + this.inMotionBehaviour);
                System.out.println("notInMotionBehaviour -> " + this.notInMotionBehaviour);
            }
            catch (Exception ex) {
                this.inMotionBehaviour = null;
                this.notInMotionBehaviour = null;
                System.out.println("avatar does not define motion behaviours");
            }
        }
        Node anchor = help[0];
        ((EventInMFNode)anchor.getEventIn("set_children")).setValue(nodes);
        ((EventInMFNode)xform.getEventIn("set_children")).setValue(help);
        this.pos = (EventInSFVec3f)anchor.getEventIn("position");
        this.rot = (EventInSFRotation)anchor.getEventIn("rotation");
        this.which = (EventInSFInt32)anchor.getEventIn("which");
        this.bind = (EventInSFBool)anchor.getEventIn("bind");
        this.which.setValue(-1);
        this.proxyPos = this.proxy.getEventOut("position_changed");
        this.posVal = this.offset.plus(new SFVec3f(((EventOutSFVec3f)this.proxyPos).getValue()));
        this.posChanged = true;
        this.pos.setValue(this.posVal.getValue());
        this.proxyRot = this.proxy.getEventOut("orientation_changed");
        this.rotVal = new SFRotation(((EventOutSFRotation)this.proxyRot).getValue());
        this.rotChanged = true;
        this.rot.setValue(this.rotVal.getValue());
        this.proxyPos.advise((EventOutObserver)this, (Object)new Integer(0));
        this.proxyRot.advise((EventOutObserver)this, (Object)new Integer(0));
        this.runner = new Thread((Runnable)this, this.name);
        this.runner.start();
    }

    public void show() {
        this.show = true;
        this.which.setValue(0);
        this.bind.setValue(true);
    }

    public void hide() {
        this.show = false;
        this.which.setValue(-1);
        this.bind.setValue(false);
    }

    public void setOffset(float off) {
        this.offset = new SFVec3f(0.0f, -off, 0.0f);
    }

    public String getName() {
        return this.name;
    }

    public void handleMessage(String tag, Field data) throws ConsumerException {
        block8: {
            if (!tag.equals(this.name)) {
                throw new ConsumerException(String.valueOf(this.name) + " matches not " + tag);
            }
            try {
                if (data.getType() == 10) {
                    this.pos.setValue(((SFVec3f)data).getValue());
                    break block8;
                }
                if (data.getType() == 6) {
                    this.rot.setValue(((SFRotation)data).getValue());
                    break block8;
                }
                if (data.getType() != 7) break block8;
                if (this.avatar != null) {
                    System.out.println("try to trigger " + ((SFString)data).getValue());
                    try {
                        EventInSFBool trig = (EventInSFBool)this.avatar.getEventIn(((SFString)data).getValue());
                        trig.setValue(true);
                        System.out.println("triggered " + ((SFString)data).getValue());
                    }
                    catch (Exception e) {
                        System.err.println(String.valueOf(this.name) + " err setting " + ((SFString)data).getValue() + "\n\t" + e);
                    }
                    break block8;
                }
                throw new ConsumerException("Wrong field type for " + this.name);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Wrong type in " + this.name + "\n\t" + e);
            }
        }
    }

    public void update() {
        try {
            if (this.posVal != null) {
                this.postOffice.sendRealTime(this.name, this.posVal, false);
                this.posChanged = false;
            }
            if (this.rotVal != null) {
                this.postOffice.sendRealTime(this.name, this.rotVal, false);
                this.rotChanged = false;
            }
        }
        catch (IOException e) {
            System.err.println("IO in " + this.name + ".update\n\t" + e);
        }
        Enumeration list = this.states.elements();
        while (list.hasMoreElements()) {
            ((Route)list.nextElement()).update();
        }
    }

    public void delete() throws RuntimeException {
        this.runner = null;
        this.dead = true;
        Enumeration list = this.states.elements();
        while (list.hasMoreElements()) {
            this.postOffice.removeConsumer(((Route)list.nextElement()).getName());
        }
    }

    public void run() {
        while (Thread.currentThread() == this.runner) {
            boolean moving = this.posChanged || this.rotChanged;
            try {
                if (this.posChanged) {
                    this.postOffice.sendRealTime(this.name, this.posVal, false);
                    this.posChanged = false;
                }
                if (this.rotChanged) {
                    this.postOffice.sendRealTime(this.name, this.rotVal, false);
                    this.rotChanged = false;
                }
                if (this.inMotionBehaviour != null) {
                    if (moving) {
                        if (this.lastMoved == null) {
                            this.lastMoved = new Date();
                            this.trigger(this.inMotionBehaviour);
                        }
                    } else if (this.lastMoved != null) {
                        this.lastMoved = null;
                        this.trigger(this.notInMotionBehaviour);
                    }
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException e) {
                System.err.println("IOEx in " + this.name + ".run\n\t" + e);
            }
        }
    }

    public void callback(EventOut value, double time, Object data) {
        if (this.show || this.dead) {
            return;
        }
        try {
            if (value == null) {
                System.err.println("Got null value from " + this.name);
                return;
            }
            if (!(value instanceof EventOut)) {
                System.err.println("value of class " + value.getClass().getName() + " from " + this.name);
                return;
            }
            switch (value.getType()) {
                case 18: {
                    this.posVal = this.offset.plus(new SFVec3f(((EventOutSFVec3f)value).getValue()));
                    this.posChanged = true;
                    this.pos.setValue(this.posVal.getValue());
                    break;
                }
                case 12: {
                    this.rotVal = new SFRotation(((EventOutSFRotation)value).getValue());
                    this.rotChanged = true;
                    this.rot.setValue(this.rotVal.getValue());
                    break;
                }
                default: {
                    System.err.println("HUH wrong value type for " + this.name);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error converting msg from " + this.name + "\n\t" + e);
        }
    }

    public void trigger(String behab) {
        try {
            this.postOffice.sendRealTime(this.name, new SFString(behab), true);
        }
        catch (IOException e) {
            System.err.println(String.valueOf(this.name) + " error posting " + behab + "\n\t" + e);
        }
    }
}

