/*
 * Decompiled with CFR 0.152.
 */
package client.matrix.guiClient;

import client.matrix.deck.eai.ServiceHandling;
import client.matrix.guiClient.ClientFrame_AboutBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ClientFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenuItem jMenuFileTerminateSession = new JMenuItem();
    BorderLayout borderLayout1 = new BorderLayout();
    private ServiceHandling serviceHandling;
    private boolean flag = false;
    JMenu jMenuMatrix = new JMenu();
    JMenuItem jMenuRequestMatrixWithTexturesHQ = new JMenuItem();
    JMenuItem jMenuRequestMatrixWithTexturesLQ = new JMenuItem();
    JMenuItem jMenuRequestMatrixWithoutTexturesHQ = new JMenuItem();
    JMenuItem jMenuRequestMatrixWithoutTexturesLQ = new JMenuItem();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JMenu jMenuHelp = new JMenu();

    public ClientFrame(ServiceHandling serviceHandling) {
        this.serviceHandling = serviceHandling;
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        ((Component)this).setSize(new Dimension(400, 300));
        this.setTitle("DeepMatrix SIP negotiation module");
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setText("Exit");
        this.jMenuHelp.setText("Help");
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jMenuFileTerminateSession.setText("Terminate Session");
        this.jMenuFileTerminateSession.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.jMenuFileTerminateSession_actionPerformed(e);
            }
        });
        this.jMenuRequestMatrixWithTexturesHQ.setText("Matrix audio and video HQ");
        this.jMenuRequestMatrixWithTexturesHQ.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.jMenuRequestMatrixWithTexturesHQ_actionPerformed(e);
            }
        });
        this.jMenuRequestMatrixWithTexturesLQ.setText("Matrix audio only");
        this.jMenuRequestMatrixWithTexturesLQ.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.jMenuRequestMatrixWithTexturesLQ_actionPerformed(e);
            }
        });
        this.jMenuMatrix.setText("DeepMatrix");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.jMenuHelpAbout_actionPerformed(e);
            }
        });
        this.jMenuRequestMatrixWithoutTexturesHQ.setText("Matrix world only");
        this.jMenuRequestMatrixWithoutTexturesHQ.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.jMenuRequestMatrixWithoutTexturesHQ_actionPerformed(e);
            }
        });
        this.jMenuRequestMatrixWithoutTexturesLQ.setText("Matrix audio and video LQ");
        this.jMenuRequestMatrixWithoutTexturesLQ.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.jMenuRequestMatrixWithoutTexturesLQ_actionPerformed(e);
            }
        });
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuFile.add(this.jMenuFileTerminateSession);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuMatrix);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.jMenuMatrix.add(this.jMenuRequestMatrixWithoutTexturesHQ);
        this.jMenuMatrix.add(this.jMenuRequestMatrixWithoutTexturesLQ);
        this.jMenuMatrix.add(this.jMenuRequestMatrixWithTexturesHQ);
        this.jMenuMatrix.add(this.jMenuRequestMatrixWithTexturesLQ);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        ((Component)this).setVisible(true);
    }

    private String getServiceSipUri() {
        String serviceSipUri = null;
        while (true) {
            if ((serviceSipUri = (String)JOptionPane.showInputDialog(this, "Enter SIP URI of the service!", "Service SIP URI", 3, null, null, "sip:gallery.qmop@192.168.1.50:4040")) == null) {
                return null;
            }
            try {
                if (serviceSipUri.substring(0, 4).equalsIgnoreCase("sip:")) break;
                JOptionPane.showMessageDialog(this, "URI scheme must be \"sip\" !", "Invalid SIP URI", 0);
            }
            catch (IndexOutOfBoundsException iobe) {
                JOptionPane.showMessageDialog(this, "URI scheme must be \"sip\" !", "Invalid SIP URI", 0);
            }
        }
        return serviceSipUri;
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    public void jMenuFileTerminateSession_actionPerformed(ActionEvent e) {
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        ClientFrame_AboutBox dlg = new ClientFrame_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        ((Component)dlg).setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        ((Component)dlg).setVisible(true);
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    void jMenuRequestMatrixWithTexturesHQ_actionPerformed(ActionEvent e) {
        String serviceSipUri = this.getServiceSipUri();
        if (serviceSipUri == null) {
            return;
        }
        this.jMenuMatrix.setEnabled(true);
        if (!this.flag) {
            this.serviceHandling.accessService("UMTS_PCHQ_gallery.txt", serviceSipUri);
        } else {
            this.serviceHandling.accessService("UMTS_PCHQ_gallery.txt", null);
        }
        this.flag = true;
    }

    void jMenuRequestMatrixWithTexturesLQ_actionPerformed(ActionEvent e) {
        String serviceSipUri = this.getServiceSipUri();
        if (serviceSipUri == null) {
            return;
        }
        this.jMenuMatrix.setEnabled(true);
        if (!this.flag) {
            this.serviceHandling.accessService("GPRS_PCHQ_gallery.txt", serviceSipUri);
        } else {
            this.serviceHandling.accessService("GPRS_PCHQ_gallery.txt", null);
        }
        this.flag = true;
    }

    void jMenuRequestMatrixWithoutTexturesHQ_actionPerformed(ActionEvent e) {
        String serviceSipUri = this.getServiceSipUri();
        if (serviceSipUri == null) {
            return;
        }
        this.jMenuMatrix.setEnabled(true);
        if (!this.flag) {
            this.serviceHandling.accessService("GPRS_IPAQ_gallery.txt", serviceSipUri);
        } else {
            this.serviceHandling.accessService("GPRS_IPAQ_gallery.txt", null);
        }
        this.flag = true;
    }

    void jMenuRequestMatrixWithoutTexturesLQ_actionPerformed(ActionEvent e) {
        String serviceSipUri = this.getServiceSipUri();
        if (serviceSipUri == null) {
            return;
        }
        this.jMenuMatrix.setEnabled(true);
        if (!this.flag) {
            this.serviceHandling.accessService("UMTSLow_PCHQ_gallery.txt", serviceSipUri);
        } else {
            this.serviceHandling.accessService("UMTSLow_PCHQ_gallery.txt", null);
        }
        this.flag = true;
    }

    public void setEnabledjMenuMatrix(boolean enable) {
        this.jMenuMatrix.setEnabled(enable);
    }
}

