/*
 * Decompiled with CFR 0.152.
 */
package client.matrix.vrml;

import client.matrix.vrml.Field;
import client.matrix.vrml.InvalidFieldException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SFImage
extends Field {
    public int width;
    public int height;
    public int components;
    public byte[] pixels;

    public SFImage(int w, int h, int c, byte[] p) {
        this.setValue(w, h, c, p);
    }

    public SFImage(SFImage data) {
        this.width = data.width;
        this.height = data.height;
        this.components = data.components;
        this.pixels = data.pixels;
    }

    public SFImage(DataInputStream in) throws IOException {
        this.width = in.readInt();
        this.height = in.readInt();
        this.components = in.readInt();
        this.pixels = new byte[this.width * this.height * this.components];
        in.readFully(this.pixels);
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.width);
        out.writeInt(this.height);
        out.writeInt(this.components);
        out.write(this.pixels);
    }

    public byte getType() {
        return 3;
    }

    public void set(Field data) throws InvalidFieldException {
        if (data.getType() != 3) {
            throw new InvalidFieldException("Data not SFImage field");
        }
        this.setValue(((SFImage)data).width, ((SFImage)data).height, ((SFImage)data).components, ((SFImage)data).pixels);
    }

    public void setValue(int w, int h, int c, byte[] p) {
        this.width = w;
        this.height = h;
        this.components = c;
        this.pixels = p;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumComponents() {
        return this.components;
    }

    public byte[] getPixels() {
        return this.pixels;
    }
}

