/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.tel.nims.dsa.client;

import hr.fer.tel.nims.dsa.client.ConfigurationHandler;
import hr.fer.tel.nims.dsa.client.SignalingAgentException;
import hr.fer.tel.nims.dsa.client.SignalingEventListener;
import hr.fer.tel.nims.dsa.client.sipAgent.SIPUserAgent;
import hr.fer.tel.nims.dsa.client.sipAgent.SIPUserAgentServer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.SipException;

public class SignalingAgent {
    private SIPUserAgent sipUserAgent;
    private SIPUserAgentServer sipUserAgentServer;
    private String serviceSIPURI = null;
    private SignalingEventListener sel;
    private String userName = null;
    private String domain = null;
    private String configurationFile;
    private ConfigurationHandler configurationHandler;

    public SignalingAgent(SignalingEventListener signalingEventListener, String configurationFile) throws SignalingAgentException {
        this.configurationFile = configurationFile;
        this.configurationHandler = new ConfigurationHandler(configurationFile);
        try {
            this.configurationHandler.init();
        }
        catch (IOException ioe) {
            throw new SignalingAgentException("Configuration file could not be found.");
        }
        catch (IllegalArgumentException iae) {
            throw new SignalingAgentException(iae.getCause());
        }
        if (signalingEventListener == null) {
            throw new SignalingAgentException("SignalingEventListener is not set.");
        }
        if (configurationFile == null) {
            throw new SignalingAgentException("Configuration file is not set.");
        }
        try {
            this.sel = signalingEventListener;
            this.sipUserAgent = new SIPUserAgent(0, this.configurationFile);
            this.sipUserAgentServer = new SIPUserAgentServer(this.sipUserAgent, this.sel);
            this.sipUserAgent.setSipUserAgentServer(this.sipUserAgentServer);
            this.sipUserAgent.start();
        }
        catch (FileNotFoundException fnfe) {
            throw new SignalingAgentException("Could not find the configuration file.");
        }
        catch (NullPointerException npe) {
            throw new SignalingAgentException(npe.getCause());
        }
        catch (IOException ioe) {
            throw new SignalingAgentException(ioe.getCause());
        }
        catch (PeerUnavailableException pue) {
            throw new SignalingAgentException("Could not create stack or factories.", pue.getCause());
        }
        catch (ObjectInUseException oiue) {
            throw new SignalingAgentException(oiue.getCause());
        }
        catch (SipException se) {
            throw new SignalingAgentException("Could not send message.", se.getCause());
        }
    }

    public void establishSession(String sessionDescription) throws SignalingAgentException {
        this.sipUserAgent.setSessionDescription(sessionDescription);
        try {
            if (this.serviceSIPURI != null && this.userName != null) {
                this.sipUserAgent.placeCall(this.serviceSIPURI, this.userName, this.userName);
            } else {
                if (this.serviceSIPURI == null) {
                    throw new SignalingAgentException("serviceSIPURI is not set.");
                }
                if (this.userName == null) {
                    throw new SignalingAgentException("userName is not set.");
                }
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (SipException e) {
            e.printStackTrace();
        }
    }

    public void terminateSession() throws SignalingAgentException {
        try {
            this.sipUserAgent.hangupCall();
        }
        catch (ClassCastException cce) {
            throw new SignalingAgentException("Could not send message.", cce.getCause());
        }
        catch (SipException se) {
            throw new SignalingAgentException("Could not send message.", se.getCause());
        }
        catch (ParseException pe) {
            throw new SignalingAgentException("Could not create message.", pe.getCause());
        }
        catch (InvalidArgumentException iae) {
            throw new SignalingAgentException("Could not create message. Invalid arguments.", iae.getCause());
        }
    }

    public void changeInClientProfile(String sessionDescription) throws SignalingAgentException {
        this.sipUserAgent.setSessionDescription(sessionDescription);
        try {
            this.sipUserAgent.sendReInvite(this.userName, this.userName, sessionDescription);
        }
        catch (NullPointerException npe) {
            throw new SignalingAgentException(npe.getCause());
        }
        catch (ClassCastException cce) {
            throw new SignalingAgentException("Could not create message.", cce.getCause());
        }
        catch (SipException se) {
            throw new SignalingAgentException("Could not send message.", se.getCause());
        }
    }

    public void changeInServiceRequirements(String sessionDescription) throws SignalingAgentException {
        try {
            this.sipUserAgent.sendUPDATE(sessionDescription);
        }
        catch (SipException e) {
            throw new SignalingAgentException("changeInServiceRequirements method can be called only after sessionhas been established.");
        }
    }

    public void setServiceSIPURI(String serviceSIPURI) throws SignalingAgentException {
        if (!serviceSIPURI.substring(0, 4).equalsIgnoreCase("sip:")) {
            throw new SignalingAgentException("Wrong SIP URI format.");
        }
        this.serviceSIPURI = serviceSIPURI;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void register(String userName) throws SignalingAgentException {
        this.domain = this.configurationHandler.getDomain();
        try {
            this.sipUserAgent.register(userName, "sip:" + userName + "@" + this.domain, this.domain);
        }
        catch (InvalidArgumentException iae) {
            throw new SignalingAgentException("Could not create message.", iae.getCause());
        }
        catch (ParseException pe) {
            throw new SignalingAgentException("Could not create message.", pe.getCause());
        }
        catch (SipException se) {
            throw new SignalingAgentException("Could not send message.", se.getCause());
        }
    }

    public void acceptParameterOffer(String sdpParameters) {
        this.sipUserAgentServer.continueSIPNegotiation(sdpParameters);
    }
}

