/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.tel.nims.dsa.client.sipAgent;

import gov.nist.javax.sip.Utils;
import hr.fer.tel.nims.dsa.client.SignalingEventListener;
import hr.fer.tel.nims.dsa.client.sipAgent.ClientInputDialog;
import hr.fer.tel.nims.dsa.client.sipAgent.ProfileManager;
import hr.fer.tel.nims.dsa.client.sipAgent.SIPUserAgent;
import hr.fer.tel.nims.dsa.client.sipAgent.SessionData;
import java.io.IOException;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.ListIterator;
import java.util.Vector;
import javax.sip.ClientTransaction;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.TimeoutEvent;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SIPUserAgentServer
implements SipListener {
    SessionData inviteSessionData;
    SIPUserAgent sipUserAgent;
    private int numberOfWrongAuthorizationAttempts;
    private String sdpParameters;
    private Document finalProfile;
    private SignalingEventListener sel;
    private ResponseEvent responseEvent;

    public SIPUserAgentServer(SIPUserAgent sipUserAgent, SignalingEventListener sel) {
        this.sel = sel;
        this.sipUserAgent = sipUserAgent;
    }

    public void processRequest(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        System.out.println("Received message:");
        System.out.println("-------------------------------------");
        System.out.println(request.toString());
        System.out.println("-------------------------------------");
        String method = request.getMethod();
        if (method.equals("INVITE")) {
            this.processINVITE(requestEvent);
        } else if (method.equals("ACK")) {
            this.processACK(requestEvent);
        } else if (method.equals("BYE")) {
            this.processBYE(requestEvent);
        } else if (method.equals("CANCEL")) {
            this.processCANCEL(requestEvent);
        } else if (method.equals("PRACK")) {
            this.processPRACK(requestEvent);
        } else if (method.equals("UPDATE")) {
            this.processUPDATE(requestEvent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void processResponse(ResponseEvent responseEvent) {
        block59: {
            Response response = responseEvent.getResponse();
            ClientTransaction clientTransaction = responseEvent.getClientTransaction();
            System.out.println("Received message:");
            System.out.println("-------------------------------------");
            System.out.println(response.toString());
            System.out.println("-------------------------------------");
            CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
            if (callIdHeader == null) {
                return;
            }
            String callId = callIdHeader.getCallId();
            ToHeader toHeader = (ToHeader)response.getHeader("To");
            if (toHeader == null) {
                return;
            }
            Address toAddress = toHeader.getAddress();
            SipURI sipURI = (SipURI)toAddress.getURI();
            String user = toAddress.getDisplayName();
            if (user == null) {
                user = sipURI.getUser();
            }
            try {
                String body;
                byte[] rawBody;
                int statusCode = response.getStatusCode();
                CSeqHeader cSeq = (CSeqHeader)response.getHeader("CSeq");
                SessionData sessionData = this.sipUserAgent.getSessionData();
                if (statusCode > 199 && statusCode < 300 && cSeq.getMethod().equals("BYE")) {
                    this.sel.handleSessionTerminatedEvent();
                    sessionData = null;
                }
                if (cSeq.getMethod().equals("REGISTER")) {
                    if (statusCode == 401 || statusCode == 407) {
                        if (this.numberOfWrongAuthorizationAttempts == 3) {
                            throw new SipException("Authorization unsuccessful.");
                        }
                        String password = ClientInputDialog.getPassword();
                        try {
                            this.sipUserAgent.registerWithPassword(user, password, responseEvent);
                            ++this.numberOfWrongAuthorizationAttempts;
                        }
                        catch (InvalidArgumentException iae) {
                            iae.printStackTrace();
                        }
                        catch (ParseException pe) {
                            pe.printStackTrace();
                        }
                    } else if (statusCode > 199 && statusCode < 300) {
                        this.numberOfWrongAuthorizationAttempts = 0;
                        try {
                            this.sel.handleClientRegisteredEvent();
                        }
                        catch (NullPointerException npe) {
                            npe.printStackTrace();
                        }
                        catch (ClassCastException cce) {
                            cce.printStackTrace();
                        }
                    }
                } else {
                    if (sessionData == null) return;
                    if (!(sipURI.getUser().equals(sessionData.getRemoteUser()) && sipURI.getHost().equals(sessionData.getRemoteHost()) && callId.equals(sessionData.getCallId()))) {
                        return;
                    }
                }
                if (cSeq.getMethod().equals("INVITE") && statusCode > 199) {
                    Request ack;
                    if (statusCode > 199 && statusCode < 300) {
                        sessionData.setRouteSet(response);
                        ack = clientTransaction.createAck();
                        try {
                            SipURI requestURI = (SipURI)ack.getRequestURI();
                            requestURI.setTransportParam("TCP");
                        }
                        catch (ParseException pe) {
                            System.out.println("Couldn't set the transport parameter to TCP in the ACK request!");
                            pe.printStackTrace();
                        }
                        ack.removeHeader("Route");
                        ListIterator recordRouteHeaders = response.getHeaders("Record-Route");
                        if (recordRouteHeaders != null) {
                            Vector<RecordRouteHeader> v = new Vector<RecordRouteHeader>();
                            while (recordRouteHeaders.hasNext()) {
                                v.addElement((RecordRouteHeader)recordRouteHeaders.next());
                            }
                            int k = v.size() - 1;
                            while (k >= 0) {
                                RouteHeader routeHeader = this.sipUserAgent.getHeaderFactory().createRouteHeader(((RecordRouteHeader)v.elementAt(k)).getAddress());
                                ack.addHeader((Header)routeHeader);
                                --k;
                            }
                        }
                        ClientTransaction ackTransaction = this.sipUserAgent.getSipProvider().getNewClientTransaction(ack);
                        ackTransaction.sendRequest();
                        System.out.println("Sent message:");
                        System.out.println("-------------------------------------");
                        System.out.println(ack.toString());
                        System.out.println("-------------------------------------");
                        sessionData.setDialog(clientTransaction.getDialog());
                        SipURI requestUri = (SipURI)ack.getRequestURI();
                        ToHeader ackToHeader = (ToHeader)ack.getHeader("To");
                        SipURI toUri = (SipURI)ackToHeader.getAddress().getURI();
                        System.out.println("-------------------------------------");
                        System.out.println("Session successfully setup with " + toUri.getUser() + " at " + requestUri.getHost());
                        System.out.println("-------------------------------------");
                        if (sessionData.getState() == 0) {
                            System.out.println("----------------------");
                            System.out.println("Stanje je " + sessionData.getState());
                            System.out.println("----------------------");
                            this.sel.handleSessionEstablishedEvent(this.getFinalProfileString());
                            sessionData.setState(1);
                            sessionData.setPreviousState(1);
                            System.out.println("----------------------");
                            System.out.println("Stanje je " + sessionData.getState());
                            System.out.println("----------------------");
                        } else if (sessionData.getState() == 3) {
                            if (sessionData.getPreviousState() == 1) {
                                this.sel.handleSessionUpdatedEvent(this.getFinalProfileString());
                                sessionData.setState(1);
                            } else if (sessionData.getPreviousState() == 2) {
                                System.out.println("----------------------");
                                System.out.println("Stanje je " + sessionData.getState());
                                System.out.println("----------------------");
                                sessionData.setState(2);
                                sessionData.setPreviousState(1);
                                System.out.println("----------------------");
                                System.out.println("Stanje je " + this.sipUserAgent.getSessionData().getState());
                                System.out.println("----------------------");
                            }
                        }
                        sessionData.setActive(true);
                        break block59;
                    }
                    if (statusCode > 299) {
                        ack = clientTransaction.createAck();
                        ClientTransaction ackTransaction = this.sipUserAgent.getSipProvider().getNewClientTransaction(ack);
                        ackTransaction.sendRequest();
                        System.out.println("Sent message:");
                        System.out.println("-------------------------------------");
                        System.out.println(ack.toString());
                        System.out.println("-------------------------------------");
                        System.out.println("-------------------------------------");
                        System.out.println("Failed to setup a session with " + user + " at " + sessionData.getRemoteAddress());
                        System.out.println("-------------------------------------");
                        if (sessionData.getState() == 0) {
                            this.sel.handleSessionEstablishmentFailedEvent("\nA > 299 status code response to an INVITE has been received!\n");
                            this.sipUserAgent.setSessionData(null);
                        } else {
                            if (sessionData.getState() == 1) return;
                            this.sel.handleSessionUpdateFailedEvent("\nA > 299 status code response to an INVITE has been received!\n");
                            sessionData.setState(1);
                            sessionData.setPreviousState(1);
                        }
                    }
                    break block59;
                }
                if (cSeq.getMethod().equals("CANCEL")) {
                    if (statusCode > 199 && statusCode < 300) {
                        System.out.println("-------------------------------------");
                        System.out.println("Call to " + user + " at " + sessionData.getRemoteAddress() + " has been cancelled");
                        System.out.println("-------------------------------------");
                        if (sessionData.getState() != 0) return;
                        this.sel.handleSessionEstablishmentFailedEvent("\nA > 199 and < 300 status code response to an CANCEL has been received!\n");
                        this.sipUserAgent.setSessionData(null);
                    } else if (statusCode == 481) {
                        System.out.println("-------------------------------------");
                        System.out.println("Call to " + user + " at " + sessionData.getRemoteAddress() + " has been cancelled");
                        System.out.println("-------------------------------------");
                        if (sessionData.getState() != 0) return;
                        this.sel.handleSessionEstablishmentFailedEvent("\nA 481 status code response to an CANCEL has been received!\n");
                        this.sipUserAgent.setSessionData(null);
                    }
                } else if (cSeq.getMethod().equals("PRACK") && statusCode > 199 && statusCode < 300) {
                    try {
                        rawBody = response.getRawContent();
                        body = new String(rawBody);
                        this.setFinalProfile(body);
                        this.sipUserAgent.sendUPDATE(body);
                    }
                    catch (SipException se) {
                        System.out.println("Could not send the UPDATE request!");
                        se.printStackTrace();
                    }
                } else if (cSeq.getMethod().equals("UPDATE") && statusCode > 199 && statusCode < 300) {
                    if (sessionData.getState() == 1) {
                        System.out.println("----------------------");
                        System.out.println("Stanje je " + sessionData.getState());
                        System.out.println("----------------------");
                        this.sel.handleServiceRequirementsChangedEvent("\nNetwork resources released!\n");
                        sessionData.setPreviousState(1);
                    } else if (sessionData.getState() == 2) {
                        if (sessionData.getPreviousState() == 1) {
                            System.out.println("----------------------");
                            System.out.println("Stanje je " + sessionData.getState());
                            System.out.println("----------------------");
                            System.out.println("Successfully updated 2");
                            this.sel.handleSessionUpdatedEvent(this.getFinalProfileString());
                            sessionData.setState(1);
                            System.out.println("----------------------");
                            System.out.println("Stanje je " + this.sipUserAgent.getSessionData().getState());
                            System.out.println("----------------------");
                        } else if (sessionData.getPreviousState() == 3) {
                            System.out.println("----------------------");
                            System.out.println("Stanje je " + this.sipUserAgent.getSessionData().getState());
                            System.out.println("----------------------");
                            sessionData.setState(3);
                            sessionData.setPreviousState(1);
                            System.out.println("----------------------");
                            System.out.println("Stanje je " + this.sipUserAgent.getSessionData().getState());
                            System.out.println("----------------------");
                        } else if (sessionData.getPreviousState() == 2) {
                            System.out.println("----------------------");
                            System.out.println("Stanje je " + this.sipUserAgent.getSessionData().getState());
                            System.out.println("----------------------");
                            sessionData.setPreviousState(1);
                            System.out.println("----------------------");
                            System.out.println("Stanje je " + this.sipUserAgent.getSessionData().getState());
                            System.out.println("----------------------");
                        }
                    }
                } else if ((statusCode <= 199 || statusCode >= 300) && statusCode <= 299 && statusCode > 99 && statusCode < 200) {
                    if (statusCode == 180) {
                        System.out.println("-------------------------------------");
                        System.out.println("Ringing...");
                        System.out.println("-------------------------------------");
                    } else if (statusCode == 183) {
                        sessionData.setRouteSet(response);
                        rawBody = response.getRawContent();
                        body = new String(rawBody);
                        sessionData.setDialog(clientTransaction.getDialog());
                        System.out.println("----------------------");
                        System.out.println("Stanje je " + sessionData.getState());
                        System.out.println("----------------------");
                        this.NegotiationInProgress(body, null, null, responseEvent, null);
                    }
                }
            }
            catch (TransactionDoesNotExistException tdne) {
                System.out.println("Couldn't send the bye message after the unsuccesful final response!");
                tdne.printStackTrace();
            }
            catch (SipException se) {
                System.out.println("Response received, but could not send ACK or BYE!");
                se.printStackTrace();
            }
        }
        System.out.println("Stanje nakon primljenog odgovora je " + this.sipUserAgent.getSessionData().getState());
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        Object timedoutTransaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
        if (this.sipUserAgent.getSessionData() != null && timedoutTransaction.equals(this.sipUserAgent.getSessionData().getLastTransaction())) {
            if (this.sipUserAgent.getSessionData().isSessionActive()) {
                System.out.println("-------------------------------------");
                System.out.println("A timeout has occured on a transaction belonging to the current session!");
                System.out.println("-------------------------------------");
            } else {
                String user = this.sipUserAgent.getSessionData().getRemoteUserDisplayName();
                if (user == null) {
                    user = this.sipUserAgent.getSessionData().getRemoteUser();
                }
                System.out.println("-------------------------------------");
                System.out.println("Failed to set up a session with " + user + " at " + this.sipUserAgent.getSessionData().getRemoteAddress());
                System.out.println("-------------------------------------");
                this.sel.handleSessionEstablishmentFailedEvent("\nTimeout received!\n");
                this.sipUserAgent.setSessionData(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processINVITE(RequestEvent inviteEvent) {
        try {
            SIPUserAgentServer sIPUserAgentServer = this;
            synchronized (sIPUserAgentServer) {
                ToHeader toHeader;
                CallIdHeader callIdHeader;
                Request invite = inviteEvent.getRequest();
                ServerTransaction inviteTransaction = null;
                inviteTransaction = inviteEvent.getServerTransaction();
                if (inviteTransaction == null) {
                    try {
                        inviteTransaction = this.sipUserAgent.getSipProvider().getNewServerTransaction(invite);
                    }
                    catch (TransactionAlreadyExistsException taee) {
                        taee.printStackTrace();
                    }
                    catch (TransactionUnavailableException tue) {
                        tue.printStackTrace();
                        return;
                    }
                }
                if ((callIdHeader = (CallIdHeader)invite.getHeader("Call-ID")) == null) {
                    return;
                }
                String callId = callIdHeader.getCallId();
                FromHeader fromHeader = (FromHeader)invite.getHeader("From");
                if (fromHeader == null) {
                    return;
                }
                Address fromAddress = fromHeader.getAddress();
                SipURI fromSipURI = (SipURI)fromAddress.getURI();
                String user = fromAddress.getDisplayName();
                if (user == null) {
                    user = fromSipURI.getUser();
                }
                if ((toHeader = (ToHeader)invite.getHeader("To")) == null) {
                    return;
                }
                Address toAddress = toHeader.getAddress();
                SipURI toSipURI = (SipURI)toAddress.getURI();
                SessionData sessionData = this.sipUserAgent.getSessionData();
                if (this.sipUserAgent.getSessionData() != null) {
                    if (!(fromSipURI.getUser().equals(sessionData.getRemoteUser()) && fromSipURI.getHost().equals(sessionData.getRemoteAddress()) && callId.equals(sessionData.getCallId()))) {
                        Response busy = this.sipUserAgent.getMessageFactory().createResponse(486, invite);
                        inviteTransaction.sendResponse(busy);
                        System.out.println("Sent message:");
                        System.out.println("-------------------------------------");
                        System.out.println(busy.toString());
                        System.out.println("-------------------------------------");
                        return;
                    }
                    this.sipUserAgent.getSessionData().setLastTransaction((Transaction)inviteTransaction);
                } else {
                    if (this.sipUserAgent.getUser() != null && !this.sipUserAgent.getUser().equals(toSipURI.getUser())) {
                        Response forbidden = this.sipUserAgent.getMessageFactory().createResponse(403, invite);
                        inviteTransaction.sendResponse(forbidden);
                        System.out.println("Sent message:");
                        System.out.println("-------------------------------------");
                        System.out.println(forbidden.toString());
                        System.out.println("-------------------------------------");
                        return;
                    }
                    this.sipUserAgent.setSessionData(new SessionData(toAddress, fromAddress, callIdHeader, (Transaction)inviteTransaction, false));
                }
                byte[] rawBody = invite.getRawContent();
                String body = new String(rawBody);
                this.setSdpParameters(body);
                this.setInviteSessionData(sessionData);
                Response ringing = this.sipUserAgent.getMessageFactory().createResponse(180, invite);
                inviteTransaction.sendResponse(ringing);
            }
        }
        catch (ParseException pe) {
            System.out.println("Invite received, but could not send response! Status code not supported!");
            pe.printStackTrace();
        }
        catch (SipException se) {
            System.out.println("Invite received, but could not send response!");
            se.printStackTrace();
        }
    }

    private synchronized void processACK(RequestEvent ackEvent) {
        Request ack = ackEvent.getRequest();
        ServerTransaction ackTransaction = ackEvent.getServerTransaction();
        CallIdHeader callIdHeader = (CallIdHeader)ack.getHeader("Call-ID");
        if (callIdHeader == null) {
            return;
        }
        String callId = callIdHeader.getCallId();
        FromHeader fromHeader = (FromHeader)ack.getHeader("From");
        if (fromHeader == null) {
            return;
        }
        Address fromAddress = fromHeader.getAddress();
        SipURI sipURI = (SipURI)fromAddress.getURI();
        String user = fromAddress.getDisplayName();
        if (user == null) {
            user = sipURI.getUser();
        }
        SessionData sessionData = this.sipUserAgent.getSessionData();
        if (this.sipUserAgent.getSessionData() != null) {
            if (!(sipURI.getUser().equals(sessionData.getRemoteUser()) && sipURI.getHost().equals(sessionData.getRemoteHost()) && callId.equals(sessionData.getCallId()))) {
                return;
            }
        } else {
            return;
        }
        this.sipUserAgent.getSessionData().setLastTransaction((Transaction)ackTransaction);
        DialogState dialogState = ackTransaction.getDialog().getState();
        if (dialogState.getValue() == 1) {
            System.out.println("-------------------------------------");
            System.out.println("Session successfully set up with " + user + " at " + sipURI.getHost());
            System.out.println("-------------------------------------");
            this.sipUserAgent.getSessionData().setActive(true);
        }
    }

    private synchronized void processBYE(RequestEvent byeEvent) {
        Request bye = byeEvent.getRequest();
        ServerTransaction byeTransaction = byeEvent.getServerTransaction();
        CallIdHeader callIdHeader = (CallIdHeader)bye.getHeader("Call-ID");
        if (callIdHeader == null) {
            return;
        }
        String callId = callIdHeader.getCallId();
        FromHeader fromHeader = (FromHeader)bye.getHeader("From");
        if (fromHeader == null) {
            return;
        }
        Address fromAddress = fromHeader.getAddress();
        SipURI sipURI = (SipURI)fromAddress.getURI();
        String user = fromAddress.getDisplayName();
        if (user == null) {
            user = sipURI.getUser();
        }
        SessionData sessionData = this.sipUserAgent.getSessionData();
        if (this.sipUserAgent.getSessionData() != null) {
            if (!(sipURI.getUser().equals(sessionData.getRemoteUser()) && sipURI.getHost().equals(sessionData.getRemoteHost()) && callId.equals(sessionData.getCallId()))) {
                return;
            }
        } else {
            return;
        }
        try {
            Response response = this.sipUserAgent.getMessageFactory().createResponse(200, bye);
            byeTransaction.sendResponse(response);
            System.out.println("Sent message:");
            System.out.println("-------------------------------------");
            System.out.println(response.toString());
            System.out.println("-------------------------------------");
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        catch (SipException se) {
            se.printStackTrace();
            System.out.println("Bye received, but could not send response!");
        }
        System.out.println("-------------------------------------");
        System.out.println("Call to " + user + " at " + sessionData.getRemoteAddress() + " has been terminated");
        System.out.println("-------------------------------------");
        this.sipUserAgent.setSessionData(null);
    }

    private synchronized void processCANCEL(RequestEvent cancelEvent) {
        ServerTransaction cancelTransaction = cancelEvent.getServerTransaction();
        Request cancel = cancelEvent.getRequest();
        try {
            SessionData sessionData = this.sipUserAgent.getSessionData();
            if (sessionData == null) {
                Response response = this.sipUserAgent.getMessageFactory().createResponse(481, cancel);
                cancelTransaction.sendResponse(response);
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(response.toString());
                System.out.println("-------------------------------------");
                return;
            }
            CallIdHeader callIdHeader = (CallIdHeader)cancel.getHeader("Call-ID");
            if (callIdHeader == null) {
                return;
            }
            String callId = callIdHeader.getCallId();
            FromHeader fromHeader = (FromHeader)cancel.getHeader("From");
            if (fromHeader == null) {
                return;
            }
            Address fromAddress = fromHeader.getAddress();
            SipURI sipURI = (SipURI)fromAddress.getURI();
            String user = fromAddress.getDisplayName();
            if (user == null) {
                user = sipURI.getUser();
            }
            if (!(sipURI.getUser().equals(sessionData.getRemoteUser()) && sipURI.getHost().equals(sessionData.getRemoteHost()) && callId.equals(sessionData.getCallId()))) {
                Response response = this.sipUserAgent.getMessageFactory().createResponse(481, cancel);
                cancelTransaction.sendResponse(response);
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(response.toString());
                System.out.println("-------------------------------------");
                return;
            }
            if (sessionData.isSessionActive()) {
                Response response = this.sipUserAgent.getMessageFactory().createResponse(481, cancel);
                cancelTransaction.sendResponse(response);
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(response.toString());
                System.out.println("-------------------------------------");
            } else {
                ServerTransaction lastTransaction = (ServerTransaction)sessionData.getLastTransaction();
                Request lastRequest = lastTransaction.getRequest();
                if (lastRequest.getMethod().equals("INVITE")) {
                    Response inviteResponse = this.sipUserAgent.getMessageFactory().createResponse(487, lastRequest);
                    inviteResponse.setReasonPhrase("Request Terminated");
                    lastTransaction.sendResponse(inviteResponse);
                    System.out.println("Sent message:");
                    System.out.println("-------------------------------------");
                    System.out.println(inviteResponse.toString());
                    System.out.println("-------------------------------------");
                }
                Response cancelResponse = this.sipUserAgent.getMessageFactory().createResponse(200, cancel);
                cancelTransaction.sendResponse(cancelResponse);
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(cancelResponse.toString());
                System.out.println("-------------------------------------");
                this.sipUserAgent.setSessionData(null);
            }
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            System.out.println("Cancel received, but could not send response!");
        }
        catch (SipException se) {
            se.printStackTrace();
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
        }
    }

    private void processPRACK(RequestEvent prackEvent) {
        Request prack = prackEvent.getRequest();
        CallIdHeader callIdHeader = (CallIdHeader)prack.getHeader("Call-ID");
        if (callIdHeader == null) {
            return;
        }
        String callId = callIdHeader.getCallId();
        FromHeader fromHeader = (FromHeader)prack.getHeader("From");
        if (fromHeader == null) {
            return;
        }
        Address fromAddress = fromHeader.getAddress();
        SipURI sipURI = (SipURI)fromAddress.getURI();
        String user = fromAddress.getDisplayName();
        if (user == null) {
            user = sipURI.getUser();
        }
        SessionData sessionData = this.sipUserAgent.getSessionData();
        if (this.sipUserAgent.getSessionData() != null) {
            if (!(sipURI.getUser().equals(sessionData.getRemoteUser()) && sipURI.getHost().equals(sessionData.getRemoteHost()) && callId.equals(sessionData.getCallId()))) {
                return;
            }
        } else {
            return;
        }
        ContentTypeHeader contentType = (ContentTypeHeader)prack.getHeader("Content-Type");
        byte[] bodyInBytes = prack.getRawContent();
        String body = new String(bodyInBytes);
        try {
            if (contentType != null && body != null) {
                this.sipUserAgent.answerCall(body);
                if (this.inviteSessionData != null) {
                    this.sipUserAgent.setSessionData(this.inviteSessionData);
                    this.sipUserAgent.answerCall(body);
                }
            } else {
                this.callIncoming(String.valueOf(user) + "@" + sipURI.getHost(), this.sdpParameters);
            }
        }
        catch (TransactionDoesNotExistException tdne) {
            System.out.println("PRACK received, but could not send response!");
            tdne.printStackTrace();
        }
        catch (ParseException pe) {
            System.out.println("PRACK received, but could not send response!");
            pe.printStackTrace();
        }
        catch (SipException se) {
            System.out.println("PRACK received, but could not send response!");
            se.printStackTrace();
        }
        catch (InvalidArgumentException iae) {
            System.out.println("PRACK received, but could not send response!");
            iae.printStackTrace();
        }
    }

    private void processUPDATE(RequestEvent updateEvent) {
        Request update = updateEvent.getRequest();
        ServerTransaction updateTransaction = updateEvent.getServerTransaction();
        CallIdHeader callIdHeader = (CallIdHeader)update.getHeader("Call-ID");
        if (callIdHeader == null) {
            return;
        }
        String callId = callIdHeader.getCallId();
        FromHeader fromHeader = (FromHeader)update.getHeader("From");
        if (fromHeader == null) {
            return;
        }
        Address fromAddress = fromHeader.getAddress();
        SipURI sipURI = (SipURI)fromAddress.getURI();
        String user = fromAddress.getDisplayName();
        if (user == null) {
            user = sipURI.getUser();
        }
        SessionData sessionData = this.sipUserAgent.getSessionData();
        if (this.sipUserAgent.getSessionData() != null) {
            if (!(sipURI.getUser().equals(sessionData.getRemoteUser()) && sipURI.getHost().equals(sessionData.getRemoteHost()) && callId.equals(sessionData.getCallId()))) {
                return;
            }
        } else {
            return;
        }
        if (sessionData.getState() == 1) {
            System.out.println("----------------------");
            System.out.println("Stanje je " + this.sipUserAgent.getSessionData().getState());
            System.out.println("----------------------");
            sessionData.setState(2);
            sessionData.setPreviousState(1);
            System.out.println("----------------------");
            System.out.println("Stanje je " + this.sipUserAgent.getSessionData().getState());
            System.out.println("----------------------");
        } else if (sessionData.getState() == 2) {
            System.out.println("----------------------");
            System.out.println("Stanje je " + this.sipUserAgent.getSessionData().getState());
            System.out.println("----------------------");
            sessionData.setPreviousState(2);
            System.out.println("----------------------");
            System.out.println("Stanje je " + this.sipUserAgent.getSessionData().getState());
            System.out.println("----------------------");
        } else if (sessionData.getState() == 3) {
            System.out.println("----------------------");
            System.out.println("Stanje je " + this.sipUserAgent.getSessionData().getState());
            System.out.println("----------------------");
            sessionData.setState(2);
            sessionData.setPreviousState(3);
            System.out.println("----------------------");
            System.out.println("Stanje je " + this.sipUserAgent.getSessionData().getState());
            System.out.println("----------------------");
        }
        ContentTypeHeader contentType = (ContentTypeHeader)update.getHeader("Content-Type");
        byte[] bodyInBytes = update.getRawContent();
        String body = new String(bodyInBytes);
        try {
            Response response;
            if (contentType != null && body != null) {
                response = this.sipUserAgent.getMessageFactory().createResponse(200, update, contentType, (Object)body);
                ToHeader responseToHeader = (ToHeader)response.getHeader("To");
                if (sessionData != null && sessionData.getDialog() != null) {
                    responseToHeader.setTag(sessionData.getDialog().getLocalTag());
                } else {
                    responseToHeader.setTag(Utils.generateTag());
                }
                SipURI responseContactURI = this.sipUserAgent.getAddressFactory().createSipURI(this.sipUserAgent.getUser(), this.sipUserAgent.getSipStack().getIPAddress());
                responseContactURI.setPort(this.sipUserAgent.getSipProvider().getListeningPoint().getPort());
                Address responseContactAddress = this.sipUserAgent.getAddressFactory().createAddress(this.sipUserAgent.getUser(), (URI)responseContactURI);
                ContactHeader responseContactHeader = this.sipUserAgent.getHeaderFactory().createContactHeader(responseContactAddress);
                response.addHeader((Header)responseContactHeader);
                updateTransaction.sendResponse(response);
                try {
                    this.sipUserAgent.sendUPDATE(body);
                }
                catch (SipException se) {
                    System.out.println("Could not send the UPDATE request!");
                    se.printStackTrace();
                }
            } else {
                response = this.sipUserAgent.getMessageFactory().createResponse(200, update);
                ToHeader responseToHeader = (ToHeader)response.getHeader("To");
                responseToHeader.setTag(Utils.generateTag());
                SipURI responseContactURI = this.sipUserAgent.getAddressFactory().createSipURI(this.sipUserAgent.getUser(), this.sipUserAgent.getSipStack().getIPAddress());
                responseContactURI.setPort(this.sipUserAgent.getSipProvider().getListeningPoint().getPort());
                Address responseContactAddress = this.sipUserAgent.getAddressFactory().createAddress(this.sipUserAgent.getUser(), (URI)responseContactURI);
                ContactHeader responseContactHeader = this.sipUserAgent.getHeaderFactory().createContactHeader(responseContactAddress);
                response.addHeader((Header)responseContactHeader);
                updateTransaction.sendResponse(response);
            }
            if (response != null) {
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(response.toString());
                System.out.println("-------------------------------------");
            }
        }
        catch (ParseException pe) {
            System.out.println("UPDATE received, but could not send response! Status code not supported!");
            pe.printStackTrace();
        }
        catch (SipException se) {
            System.out.println("UPDATE received, but could not send response!");
            se.printStackTrace();
        }
    }

    protected void setSdpParameters(String sdpParameters) {
        this.sdpParameters = sdpParameters;
    }

    public Document getFinalProfile() {
        return this.finalProfile;
    }

    void setFinalProfile(String profile) {
        if (profile == null) {
            this.finalProfile = null;
        } else {
            try {
                this.finalProfile = new ProfileManager().stringToDocument(profile);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (SAXException saxe) {
                saxe.printStackTrace();
            }
        }
    }

    protected void NegotiationInProgress(String sdpParameters, Vector AuthorizationToken, String callID, ResponseEvent responseEvent, SIPUserAgent sipUserAgent) {
        this.responseEvent = responseEvent;
        this.sel.handleSessionParameterOffer(sdpParameters);
    }

    public void continueSIPNegotiation(String sdpParameters) {
        try {
            System.out.println("Tu sam 3");
            if (this.responseEvent != null) {
                if (sdpParameters == null) {
                    System.out.println("SDP parametri su null!!!");
                }
                this.sipUserAgent.sendPRACK(sdpParameters, this.responseEvent);
            } else {
                this.sipUserAgent.setSessionData(this.getInviteSessionData());
                this.sipUserAgent.answerCall(sdpParameters);
            }
        }
        catch (TransactionDoesNotExistException tdnee) {
            tdnee.printStackTrace();
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        catch (SipException se) {
            se.printStackTrace();
        }
        catch (InvalidArgumentException iae) {
            iae.printStackTrace();
        }
    }

    public void callIncoming(String caller, String sdpParameters) {
        this.responseEvent = null;
        this.sel.handleSessionParameterOffer(sdpParameters);
    }

    public void setInviteSessionData(SessionData sessionData) {
        this.inviteSessionData = this.inviteSessionData == null ? new SessionData(sessionData.getLocalAddress(), sessionData.getRemoteAddress(), sessionData.getCallIdHeader(), sessionData.getLastTransaction(), sessionData.isLocallyInitiated()) : sessionData;
    }

    public SessionData getInviteSessionData() {
        return this.inviteSessionData;
    }

    private String getFinalProfileString() {
        try {
            DOMSource source = new DOMSource(this.getFinalProfile());
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }
}

