/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.tel.nims.dsa.server.sipagent;

import hr.fer.tel.nims.dsa.server.profilehandling.ProfileManager;
import hr.fer.tel.nims.dsa.server.sipagent.SIPUserAgent;
import hr.fer.tel.nims.dsa.server.sipagent.SessionData;
import hr.fer.tel.nims.dsa.server.sipagent.SessionMapping;
import hr.fer.tel.nims.dsa.server.sipinterface.SipInterface;
import java.text.ParseException;
import java.util.ListIterator;
import javax.sip.ClientTransaction;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.TimeoutEvent;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class SIPUserAgentServer
implements SipListener {
    private SIPUserAgent sipUserAgent;
    private SipInterface si;
    private SessionMapping inviteSessionData;

    public SIPUserAgentServer(SipInterface si) {
        this.si = si;
        this.inviteSessionData = new SessionMapping();
    }

    public void processRequest(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        System.out.println("Received message:");
        System.out.println("-------------------------------------");
        System.out.println(request.toString());
        System.out.println("-------------------------------------");
        String method = request.getMethod();
        if (method.equals("INVITE")) {
            try {
                this.processINVITE(requestEvent);
            }
            catch (InvalidArgumentException invalidArgumentException) {}
        } else if (method.equals("ACK")) {
            this.processACK(requestEvent);
        } else if (method.equals("BYE")) {
            this.processBYE(requestEvent);
        } else if (method.equals("CANCEL")) {
            this.processCANCEL(requestEvent);
        } else if (method.equals("PRACK")) {
            this.processPRACK(requestEvent);
        } else if (method.equals("UPDATE")) {
            this.processUPDATE(requestEvent);
        }
    }

    public synchronized void processResponse(ResponseEvent responseEvent) {
        FromHeader fromHeader;
        Response response = responseEvent.getResponse();
        ClientTransaction clientTransaction = responseEvent.getClientTransaction();
        System.out.println("Received message:");
        System.out.println("-------------------------------------");
        System.out.println(response.toString());
        System.out.println("-------------------------------------");
        CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
        if (callIdHeader == null) {
            return;
        }
        String callId = callIdHeader.getCallId();
        ToHeader toHeader = (ToHeader)response.getHeader("To");
        if (toHeader == null) {
            return;
        }
        Address toAddress = toHeader.getAddress();
        SipURI toSipURI = (SipURI)toAddress.getURI();
        String user = toAddress.getDisplayName();
        if (user == null) {
            user = toSipURI.getUser();
        }
        if ((fromHeader = (FromHeader)response.getHeader("From")) == null) {
            return;
        }
        try {
            SessionData sessionData;
            int statusCode = response.getStatusCode();
            CSeqHeader cSeq = (CSeqHeader)response.getHeader("CSeq");
            if (statusCode > 199 && statusCode < 300) {
                cSeq.getMethod().equals("BYE");
            }
            if ((sessionData = this.sipUserAgent.getSessionDataMapping().getSessionData(callId)) != null) {
                if (!(toSipURI.getUser().equals(sessionData.getRemoteUser()) && toSipURI.getHost().equals(sessionData.getRemoteHost()) && callId.equals(sessionData.getCallId()))) {
                    return;
                }
            } else {
                return;
            }
            if ((cSeq.getMethod().equals("INVITE") || cSeq.getMethod().equals("UPDATE") || cSeq.getMethod().equals("PRACK")) && statusCode > 199) {
                if (statusCode > 199 && statusCode < 300) {
                    if (cSeq.getMethod().equals("INVITE")) {
                        RouteHeader routeHeader;
                        Request ack = clientTransaction.createAck();
                        ack.removeHeader("Route");
                        ListIterator routeHeaders = sessionData.getDialog().getFirstTransaction().getRequest().getHeaders("Route");
                        ListIterator recordRouteHeaders = sessionData.getDialog().getFirstTransaction().getRequest().getHeaders("Record-Route");
                        if (routeHeaders != null) {
                            while (routeHeaders.hasNext()) {
                                routeHeader = this.sipUserAgent.getHeaderFactory().createRouteHeader(((RouteHeader)routeHeaders.next()).getAddress());
                                ack.addHeader((Header)routeHeader);
                            }
                        }
                        if (recordRouteHeaders != null) {
                            while (recordRouteHeaders.hasNext()) {
                                routeHeader = this.sipUserAgent.getHeaderFactory().createRouteHeader(((RecordRouteHeader)recordRouteHeaders.next()).getAddress());
                                ack.addHeader((Header)routeHeader);
                            }
                        }
                        ClientTransaction ackTransaction = this.sipUserAgent.getSipProvider().getNewClientTransaction(ack);
                        ackTransaction.sendRequest();
                        System.out.println("Sent message:");
                        System.out.println("-------------------------------------");
                        System.out.println(ack.toString());
                        System.out.println("-------------------------------------");
                        if (!sessionData.isSessionActive()) {
                            sessionData.setActive(true);
                            sessionData.setDialog(clientTransaction.getDialog());
                            SipURI requestUri = (SipURI)ack.getRequestURI();
                            ToHeader ackToHeader = (ToHeader)ack.getHeader("To");
                            SipURI toUri = (SipURI)ackToHeader.getAddress().getURI();
                            System.out.println("-------------------------------------");
                            System.out.println("Session successfully setup with " + toUri.getUser() + " at " + requestUri.getHost());
                            System.out.println("-------------------------------------");
                            if (this.si != null && !this.sipUserAgent.isClient) {
                                this.si.handleSipSessionEstablishedEvent(null, null);
                            }
                        }
                    } else if (!cSeq.getMethod().equals("PRACK")) {
                        cSeq.getMethod().equals("UPDATE");
                    }
                } else if (statusCode > 299) {
                    Request ack = clientTransaction.createAck();
                    ClientTransaction ackTransaction = this.sipUserAgent.getSipProvider().getNewClientTransaction(ack);
                    ackTransaction.sendRequest();
                    System.out.println("Sent message:");
                    System.out.println("-------------------------------------");
                    System.out.println(ack.toString());
                    System.out.println("-------------------------------------");
                    System.out.println("-------------------------------------");
                    System.out.println("Failed to setup a session with " + user + " at " + sessionData.getRemoteAddress());
                    System.out.println("-------------------------------------");
                    if (this.si != null) {
                        if (sessionData.getState() == 0) {
                            this.si.handleSipSessionEstablishmentFailedEvent("\nA status code > 299 response to an INVITE, a PRACK or an UPDATE has been received!\n", sessionData.getRemoteHost());
                            this.sipUserAgent.getSessionDataMapping().removeSessionData(callId);
                        } else {
                            this.si.handleSipSessionUpdateFailedEvent("\nA status code > 299 response to an INVITE, a PRACK or an UPDATE has been received!\n", sessionData.getRemoteHost());
                            sessionData.setState(1);
                            sessionData.setPreviousState(1);
                        }
                    }
                }
            } else if (cSeq.getMethod().equals("CANCEL")) {
                if (statusCode > 199 && statusCode < 300) {
                    System.out.println("-------------------------------------");
                    System.out.println("Call to " + user + " at " + sessionData.getRemoteAddress() + " has been cancelled");
                    System.out.println("-------------------------------------");
                    this.sipUserAgent.getSessionDataMapping().removeSessionData(callId);
                } else if (statusCode == 481) {
                    System.out.println("-------------------------------------");
                    System.out.println("Call to " + user + " at " + sessionData.getRemoteAddress() + " has been cancelled");
                    System.out.println("-------------------------------------");
                    this.sipUserAgent.getSessionDataMapping().removeSessionData(callId);
                }
            } else if ((statusCode <= 199 || statusCode >= 300) && statusCode <= 299 && statusCode > 99 && statusCode < 200 && statusCode == 180) {
                System.out.println("-------------------------------------");
                System.out.println("Ringing...");
                System.out.println("-------------------------------------");
                sessionData.setDialog(clientTransaction.getDialog());
            }
        }
        catch (TransactionDoesNotExistException tdne) {
            System.out.println("Couldn't send the bye message after the unsuccesful final response!");
            tdne.printStackTrace();
        }
        catch (SipException se) {
            System.out.println("Response received, but could not send ACK or BYE!");
            se.printStackTrace();
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        Object timedoutTransaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
        Request request = timedoutTransaction.getRequest();
        CallIdHeader callIdHeader = (CallIdHeader)request.getHeader("Call-ID");
        if (callIdHeader == null) {
            return;
        }
        String callId = callIdHeader.getCallId();
        SessionData sessionData = this.sipUserAgent.getSessionDataMapping().getSessionData(callId);
        if (sessionData != null && timedoutTransaction.equals(sessionData.getLastTransaction())) {
            if (sessionData.isSessionActive()) {
                System.out.println("-------------------------------------");
                System.out.println("A timeout has occured on a transaction belonging to the current session!");
                System.out.println("-------------------------------------");
            } else {
                String user = sessionData.getRemoteUserDisplayName();
                if (user == null) {
                    user = sessionData.getRemoteUser();
                }
                System.out.println("-------------------------------------");
                System.out.println("Failed to set up a session with " + user + " at " + sessionData.getRemoteAddress());
                System.out.println("-------------------------------------");
                if (this.si != null && sessionData.getState() == 0) {
                    this.si.handleSipSessionEstablishmentFailedEvent("\nA timeout event has been receieved!\n", sessionData.getRemoteHost());
                    this.sipUserAgent.getSessionDataMapping().removeSessionData(callId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processINVITE(RequestEvent inviteEvent) throws InvalidArgumentException {
        try {
            SessionData sessionData;
            SIPUserAgentServer sIPUserAgentServer = this;
            synchronized (sIPUserAgentServer) {
                ToHeader toHeader;
                Request invite = inviteEvent.getRequest();
                CallIdHeader callIdHeader = (CallIdHeader)invite.getHeader("Call-ID");
                if (callIdHeader == null) {
                    return;
                }
                String callId = callIdHeader.getCallId();
                FromHeader fromHeader = (FromHeader)invite.getHeader("From");
                if (fromHeader == null) {
                    return;
                }
                Address fromAddress = fromHeader.getAddress();
                SipURI sipURI = (SipURI)fromAddress.getURI();
                String user = fromAddress.getDisplayName();
                if (user == null) {
                    user = sipURI.getUser();
                }
                if ((toHeader = (ToHeader)invite.getHeader("To")) == null) {
                    return;
                }
                Address toAddress = toHeader.getAddress();
                ServerTransaction inviteTransaction = null;
                inviteTransaction = inviteEvent.getServerTransaction();
                if (inviteTransaction == null) {
                    try {
                        inviteTransaction = this.sipUserAgent.getSipProvider().getNewServerTransaction(invite);
                    }
                    catch (TransactionAlreadyExistsException taee) {
                        taee.printStackTrace();
                    }
                    catch (TransactionUnavailableException tue) {
                        tue.printStackTrace();
                        return;
                    }
                }
                if (!this.sipUserAgent.isClient) {
                    Response decline = this.sipUserAgent.getMessageFactory().createResponse(603, invite);
                    inviteTransaction.sendResponse(decline);
                }
                if ((sessionData = this.sipUserAgent.getSessionDataMapping().getSessionData(callId)) != null) {
                    if (!(sipURI.getUser().equals(sessionData.getRemoteUser()) && sipURI.getHost().equals(sessionData.getRemoteHost()) && callId.equals(sessionData.getCallId()))) {
                        Response busy = this.sipUserAgent.getMessageFactory().createResponse(486, invite);
                        inviteTransaction.sendResponse(busy);
                        System.out.println("Sent message:");
                        System.out.println("-------------------------------------");
                        System.out.println(busy.toString());
                        System.out.println("-------------------------------------");
                        return;
                    }
                    sessionData.setLastTransaction((Transaction)inviteTransaction);
                    if (sessionData.getState() == 1) {
                        sessionData.setPreviousState(1);
                    } else if (sessionData.getState() == 3) {
                        sessionData.setPreviousState(3);
                    } else if (sessionData.getState() == 2) {
                        sessionData.setPreviousState(2);
                    }
                    sessionData.setState(4);
                } else {
                    sessionData = new SessionData(toAddress, fromAddress, callIdHeader, (Transaction)inviteTransaction, false);
                    this.sipUserAgent.getSessionDataMapping().addSessionData(sessionData);
                }
                if (this.si != null) {
                    Response ringing = this.sipUserAgent.getMessageFactory().createResponse(180, invite);
                    inviteTransaction.sendResponse(ringing);
                    System.out.println("Sent message:");
                    System.out.println("-------------------------------------");
                    System.out.println(ringing.toString());
                    System.out.println("-------------------------------------");
                }
            }
            if (this.si != null) {
                this.callIncoming(sessionData);
            }
        }
        catch (ParseException pe) {
            System.out.println("Invite received, but could not send response! Status code not supported!");
            pe.printStackTrace();
        }
        catch (SipException se) {
            System.out.println("Invite received, but could not send response!");
            se.printStackTrace();
        }
        catch (ClassCastException cce) {
            System.out.println("Received a corrupt invitation! Ignoring...");
            cce.printStackTrace();
        }
    }

    private synchronized void processACK(RequestEvent ackEvent) {
        ToHeader toHeader;
        Request ack = ackEvent.getRequest();
        ServerTransaction ackTransaction = ackEvent.getServerTransaction();
        CallIdHeader callIdHeader = (CallIdHeader)ack.getHeader("Call-ID");
        if (callIdHeader == null) {
            return;
        }
        String callId = callIdHeader.getCallId();
        FromHeader fromHeader = (FromHeader)ack.getHeader("From");
        if (fromHeader == null) {
            return;
        }
        Address fromAddress = fromHeader.getAddress();
        SipURI fromSipURI = (SipURI)fromAddress.getURI();
        String user = fromAddress.getDisplayName();
        if (user == null) {
            user = fromSipURI.getUser();
        }
        if ((toHeader = (ToHeader)ack.getHeader("To")) == null) {
            return;
        }
        SessionData sessionData = this.sipUserAgent.getSessionDataMapping().getSessionData(callId);
        if (sessionData != null) {
            if (!(fromSipURI.getUser().equals(sessionData.getRemoteUser()) && fromSipURI.getHost().equals(sessionData.getRemoteHost()) && callId.equals(sessionData.getCallId()))) {
                return;
            }
        } else {
            return;
        }
        sessionData.setLastTransaction((Transaction)ackTransaction);
        DialogState dialogState = ackTransaction.getDialog().getState();
        if (dialogState.getValue() == 1) {
            System.out.println("-------------------------------------");
            System.out.println("Session successfully set up with " + user + " at " + fromSipURI.getHost());
            System.out.println("-------------------------------------");
            sessionData.setActive(true);
            if (sessionData.getState() == 0) {
                System.out.println("ISPIS ZA OGIJA " + new ProfileManager().getStringFromDocument(sessionData.getFinalProfile()));
                this.si.handleSipSessionEstablishedEvent(new ProfileManager().getStringFromDocument(sessionData.getFinalProfile()), sessionData.getRemoteHost());
                sessionData.setState(1);
                sessionData.setPreviousState(1);
            } else if (sessionData.getState() == 1) {
                this.si.handleFinalServiceProfileChangedEvent(new ProfileManager().getStringFromDocument(sessionData.getFinalProfile()), "\nSession updated!\n", sessionData.getRemoteHost());
            }
        } else if (sessionData.getState() == 0) {
            this.si.handleSipSessionEstablishmentFailedEvent("\nSIP stack error!\nAn ACK has been received, but the session has not been properly established!\n", sessionData.getRemoteHost());
            this.sipUserAgent.getSessionDataMapping().removeSessionData(callId);
        } else if (sessionData.getState() == 1) {
            this.si.handleSipSessionUpdateFailedEvent("\nSIP stack error!\nAn ACK has been received, but the session has not been properly updated!\n", sessionData.getRemoteHost());
        }
    }

    private synchronized void processBYE(RequestEvent byeEvent) {
        SessionData sessionData;
        Request bye = byeEvent.getRequest();
        ServerTransaction byeTransaction = byeEvent.getServerTransaction();
        CallIdHeader callIdHeader = (CallIdHeader)bye.getHeader("Call-ID");
        if (callIdHeader == null) {
            return;
        }
        String callId = callIdHeader.getCallId();
        FromHeader fromHeader = (FromHeader)bye.getHeader("From");
        if (fromHeader == null) {
            return;
        }
        Address fromAddress = fromHeader.getAddress();
        SipURI sipURI = (SipURI)fromAddress.getURI();
        String user = fromAddress.getDisplayName();
        if (user == null) {
            user = sipURI.getUser();
        }
        if ((sessionData = this.sipUserAgent.getSessionDataMapping().getSessionData(callId)) != null) {
            if (!(sipURI.getUser().equals(sessionData.getRemoteUser()) && sipURI.getHost().equals(sessionData.getRemoteHost()) && callId.equals(sessionData.getCallId()))) {
                return;
            }
        } else {
            return;
        }
        try {
            Response response = this.sipUserAgent.getMessageFactory().createResponse(200, bye);
            byeTransaction.sendResponse(response);
            System.out.println("Sent message:");
            System.out.println("-------------------------------------");
            System.out.println(response.toString());
            System.out.println("-------------------------------------");
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        catch (SipException se) {
            se.printStackTrace();
            System.out.println("Bye received, but could not send response!");
        }
        System.out.println("-------------------------------------");
        System.out.println("Call to " + user + " at " + sessionData.getRemoteAddress() + " has been terminated");
        System.out.println("-------------------------------------");
        this.si.handleSipSessionTerminatedEvent(sessionData.getRemoteHost());
        this.sipUserAgent.getSessionDataMapping().removeSessionData(callId);
        this.inviteSessionData.removeSessionData(callId);
    }

    private synchronized void processCANCEL(RequestEvent cancelEvent) {
        ServerTransaction cancelTransaction = cancelEvent.getServerTransaction();
        Request cancel = cancelEvent.getRequest();
        try {
            CallIdHeader callIdHeader = (CallIdHeader)cancel.getHeader("Call-ID");
            if (callIdHeader == null) {
                return;
            }
            String callId = callIdHeader.getCallId();
            SessionData sessionData = this.sipUserAgent.getSessionDataMapping().getSessionData(callId);
            if (sessionData == null) {
                Response response = this.sipUserAgent.getMessageFactory().createResponse(481, cancel);
                cancelTransaction.sendResponse(response);
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(response.toString());
                System.out.println("-------------------------------------");
                return;
            }
            FromHeader fromHeader = (FromHeader)cancel.getHeader("From");
            if (fromHeader == null) {
                return;
            }
            Address fromAddress = fromHeader.getAddress();
            SipURI sipURI = (SipURI)fromAddress.getURI();
            String user = fromAddress.getDisplayName();
            if (user == null) {
                user = sipURI.getUser();
            }
            if (!(sipURI.getUser().equals(sessionData.getRemoteUser()) && sipURI.getHost().equals(sessionData.getRemoteHost()) && callId.equals(sessionData.getCallId()))) {
                Response response = this.sipUserAgent.getMessageFactory().createResponse(481, cancel);
                cancelTransaction.sendResponse(response);
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(response.toString());
                System.out.println("-------------------------------------");
                return;
            }
            if (sessionData.isSessionActive()) {
                Response response = this.sipUserAgent.getMessageFactory().createResponse(481, cancel);
                cancelTransaction.sendResponse(response);
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(response.toString());
                System.out.println("-------------------------------------");
            } else {
                ServerTransaction lastTransaction = (ServerTransaction)sessionData.getLastTransaction();
                Request lastRequest = lastTransaction.getRequest();
                if (lastRequest.getMethod().equals("INVITE")) {
                    Response inviteResponse = this.sipUserAgent.getMessageFactory().createResponse(487, lastRequest);
                    inviteResponse.setReasonPhrase("Request Terminated");
                    lastTransaction.sendResponse(inviteResponse);
                    System.out.println("Sent message:");
                    System.out.println("-------------------------------------");
                    System.out.println(inviteResponse.toString());
                    System.out.println("-------------------------------------");
                }
                Response cancelResponse = this.sipUserAgent.getMessageFactory().createResponse(200, cancel);
                cancelTransaction.sendResponse(cancelResponse);
                System.out.println("Sent message:");
                System.out.println("-------------------------------------");
                System.out.println(cancelResponse.toString());
                System.out.println("-------------------------------------");
                this.si.handleSipSessionEstablishmentFailedEvent("\nA CANCEL has been received!\nSession is cancelled!\n", sessionData.getRemoteHost());
                this.sipUserAgent.getSessionDataMapping().removeSessionData(callId);
            }
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            System.out.println("Cancel received, but could not send response!");
        }
        catch (SipException se) {
            se.printStackTrace();
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
        }
    }

    private void processPRACK(RequestEvent prackEvent) {
        try {
            SessionData sessionData;
            ToHeader toHeader;
            Request prack = prackEvent.getRequest();
            CallIdHeader callIdHeader = (CallIdHeader)prack.getHeader("Call-ID");
            if (callIdHeader == null) {
                return;
            }
            String callId = callIdHeader.getCallId();
            FromHeader fromHeader = (FromHeader)prack.getHeader("From");
            if (fromHeader == null) {
                return;
            }
            Address fromAddress = fromHeader.getAddress();
            SipURI sipURI = (SipURI)fromAddress.getURI();
            String user = fromAddress.getDisplayName();
            if (user == null) {
                user = sipURI.getUser();
            }
            if ((toHeader = (ToHeader)prack.getHeader("To")) == null) {
                return;
            }
            Address toAddress = toHeader.getAddress();
            ServerTransaction PrackTransaction = null;
            PrackTransaction = prackEvent.getServerTransaction();
            if (PrackTransaction == null) {
                try {
                    PrackTransaction = this.sipUserAgent.getSipProvider().getNewServerTransaction(prack);
                }
                catch (TransactionAlreadyExistsException taee) {
                    taee.printStackTrace();
                }
                catch (TransactionUnavailableException tue) {
                    tue.printStackTrace();
                    return;
                }
            }
            if (!this.sipUserAgent.isClient) {
                Response decline = this.sipUserAgent.getMessageFactory().createResponse(603, prack);
                PrackTransaction.sendResponse(decline);
            }
            if ((sessionData = this.sipUserAgent.getSessionDataMapping().getSessionData(callId)) != null) {
                if (!(sipURI.getUser().equals(sessionData.getRemoteUser()) && sipURI.getHost().equals(sessionData.getRemoteHost()) && callId.equals(sessionData.getCallId()))) {
                    Response busy = this.sipUserAgent.getMessageFactory().createResponse(486, prack);
                    PrackTransaction.sendResponse(busy);
                    System.out.println("Sent message:");
                    System.out.println("-------------------------------------");
                    System.out.println(busy.toString());
                    System.out.println("-------------------------------------");
                    return;
                }
                sessionData.setLastTransaction((Transaction)PrackTransaction);
            } else {
                sessionData = new SessionData(toAddress, fromAddress, callIdHeader, (Transaction)PrackTransaction, false);
                this.sipUserAgent.getSessionDataMapping().addSessionData(sessionData);
            }
            byte[] bodyInBytes = prack.getRawContent();
            String profile = new String(bodyInBytes);
            System.out.println("\nFinal profile:\n" + profile);
            sessionData.setFinalProfile(profile);
            System.out.println("ISPIS ZA OGIJA " + new ProfileManager().getStringFromDocument(sessionData.getFinalProfile()));
            if (this.si != null) {
                this.sipUserAgent.answerCall(null, prack);
            }
        }
        catch (ParseException pe) {
            System.out.println("Prack received, but could not send response! Status code not supported!");
            pe.printStackTrace();
        }
        catch (SipException se) {
            System.out.println("Invite received, but could not send response!");
            se.printStackTrace();
        }
        catch (ClassCastException cce) {
            System.out.println("Received a corrupt invitation! Ignoring...");
            cce.printStackTrace();
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public void processUPDATE(RequestEvent updateEvent) {
        try {
            ToHeader toHeader;
            Request update = updateEvent.getRequest();
            CallIdHeader callIdHeader = (CallIdHeader)update.getHeader("Call-ID");
            if (callIdHeader == null) {
                return;
            }
            String callId = callIdHeader.getCallId();
            FromHeader fromHeader = (FromHeader)update.getHeader("From");
            if (fromHeader == null) {
                return;
            }
            Address fromAddress = fromHeader.getAddress();
            SipURI sipURI = (SipURI)fromAddress.getURI();
            String user = fromAddress.getDisplayName();
            if (user == null) {
                user = sipURI.getUser();
            }
            if ((toHeader = (ToHeader)update.getHeader("To")) == null) {
                return;
            }
            Address toAddress = toHeader.getAddress();
            ServerTransaction UpdateTransaction = null;
            UpdateTransaction = updateEvent.getServerTransaction();
            if (UpdateTransaction == null) {
                try {
                    UpdateTransaction = this.sipUserAgent.getSipProvider().getNewServerTransaction(update);
                }
                catch (TransactionAlreadyExistsException taee) {
                    taee.printStackTrace();
                }
                catch (TransactionUnavailableException tue) {
                    tue.printStackTrace();
                    return;
                }
            }
            if (!this.sipUserAgent.isClient) {
                Response decline = this.sipUserAgent.getMessageFactory().createResponse(603, update);
                UpdateTransaction.sendResponse(decline);
            }
            SessionData sessionData = this.sipUserAgent.getSessionDataMapping().getSessionData(callId);
            System.out.println("ISPIS ZA OGIJA " + new ProfileManager().getStringFromDocument(sessionData.getFinalProfile()));
            if (sessionData != null) {
                if (!(sipURI.getUser().equals(sessionData.getRemoteUser()) && sipURI.getHost().equals(sessionData.getRemoteHost()) && callId.equals(sessionData.getCallId()))) {
                    Response busy = this.sipUserAgent.getMessageFactory().createResponse(486, update);
                    UpdateTransaction.sendResponse(busy);
                    System.out.println("Sent message:");
                    System.out.println("-------------------------------------");
                    System.out.println(busy.toString());
                    System.out.println("-------------------------------------");
                    return;
                }
                sessionData.setLastTransaction((Transaction)UpdateTransaction);
            } else {
                sessionData = new SessionData(toAddress, fromAddress, callIdHeader, (Transaction)UpdateTransaction, false);
                this.sipUserAgent.getSessionDataMapping().addSessionData(sessionData);
            }
            byte[] bodyInBytes = update.getRawContent();
            String body = new String(bodyInBytes);
            boolean remoteUserOriginatingSender = this.isRemoteUserOriginatingSender(update, sessionData);
            if (this.si != null) {
                boolean is;
                this.sipUserAgent.answerCall(null, update);
                if (sessionData.getState() == 1) {
                    if (remoteUserOriginatingSender) {
                        this.si.handleNetworkResourcesReleasedEvent(sessionData.getRemoteUser());
                    } else {
                        sessionData.setState(3);
                        sessionData.setPreviousState(1);
                        this.sipUserAgent.sendUpdate(body, callId);
                    }
                } else if (sessionData.getState() == 2) {
                    if (remoteUserOriginatingSender) {
                        if (sessionData.getPreviousState() == 1) {
                            System.out.println("setam 1 " + body);
                            sessionData.setFinalProfile(body);
                            this.si.handleFinalServiceProfileChangedEvent(new ProfileManager().getStringFromDocument(sessionData.getFinalProfile()), "\nSession updated or resources used for streaming released!\n", sessionData.getRemoteHost());
                            sessionData.setState(1);
                        } else if (sessionData.getPreviousState() == 3) {
                            sessionData.setState(3);
                            sessionData.setPreviousState(1);
                        } else if (sessionData.getPreviousState() == 4) {
                            sessionData.setState(4);
                            sessionData.setPreviousState(1);
                        }
                    } else {
                        sessionData.setState(3);
                        sessionData.setPreviousState(2);
                        this.sipUserAgent.sendUpdate(body, callId);
                    }
                } else if (sessionData.getState() == 3) {
                    if (sessionData.getPreviousState() == 1) {
                        System.out.println("Setam 2" + body);
                        sessionData.setFinalProfile(body);
                        this.si.handleFinalServiceProfileChangedEvent(new ProfileManager().getStringFromDocument(sessionData.getFinalProfile()), "\nSession updated!\n", sessionData.getRemoteHost());
                        sessionData.setState(1);
                    } else if (sessionData.getPreviousState() == 2) {
                        sessionData.setState(2);
                        sessionData.setPreviousState(1);
                    } else if (sessionData.getPreviousState() == 4) {
                        sessionData.setState(4);
                        sessionData.setPreviousState(1);
                    }
                } else if (sessionData.getState() == 4) {
                    if (remoteUserOriginatingSender) {
                        if (sessionData.getPreviousState() == 1) {
                            System.out.println("Setam 3 " + body);
                            sessionData.setFinalProfile(body);
                            sessionData.setState(1);
                        } else if (sessionData.getPreviousState() == 2) {
                            sessionData.setState(2);
                            sessionData.setPreviousState(1);
                        } else if (sessionData.getPreviousState() == 3) {
                            sessionData.setState(3);
                            sessionData.setPreviousState(1);
                        }
                    } else {
                        sessionData.setState(3);
                        sessionData.setPreviousState(4);
                        this.sipUserAgent.sendUpdate(body, callId);
                    }
                }
                if (!sessionData.getOKInviteSent() && (is = this.establishDialog(callId))) {
                    sessionData.setOKInviteSent(true);
                }
            }
        }
        catch (ParseException pe) {
            System.out.println("Update received, but could not send response! Status code not supported!");
            pe.printStackTrace();
        }
        catch (SipException se) {
            System.out.println("Update received, but could not send response!");
            se.printStackTrace();
        }
        catch (ClassCastException cce) {
            System.out.println("Received a corrupt invitation! Ignoring...");
            cce.printStackTrace();
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public SIPUserAgent getSipUserAgent() {
        return this.sipUserAgent;
    }

    public void setSipUserAgent(SIPUserAgent sipUserAgent) {
        this.sipUserAgent = sipUserAgent;
    }

    private void callIncoming(SessionData inviteSessionData) {
        try {
            this.setInviteSessionData(inviteSessionData);
            String sessionId = new String(inviteSessionData.getCallId());
            SessionData sessionData = this.sipUserAgent.getSessionDataMapping().getSessionData(sessionId);
            if (sessionData != null) {
                sessionData.setOKInviteSent(false);
            }
            this.answerCall(new ProfileManager().getServiceProfiles(inviteSessionData.getLocalUser()), inviteSessionData.getLastTransaction().getRequest());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean establishDialog(String sessionId) {
        SessionData inviteSessionData = this.getInviteSessionData(sessionId);
        if (inviteSessionData == null) {
            return false;
        }
        SessionData sessionData = this.sipUserAgent.getSessionDataMapping().getSessionData(sessionId);
        sessionData.setLastTransaction(inviteSessionData.getLastTransaction());
        try {
            return this.sipUserAgent.sendEmpty200OK(sessionId);
        }
        catch (SipException se) {
            se.printStackTrace();
            return false;
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            return false;
        }
    }

    private boolean answerCall(String responseBody, Request request) {
        try {
            return this.sipUserAgent.answerCall(responseBody, request);
        }
        catch (SipException se) {
            se.printStackTrace();
            return false;
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            return false;
        }
        catch (InvalidArgumentException iae) {
            iae.printStackTrace();
            return false;
        }
    }

    private void setInviteSessionData(SessionData sessionData) {
        SessionData sessionDataCopy = new SessionData(sessionData.getLocalAddress(), sessionData.getRemoteAddress(), sessionData.getCallIdHeader(), sessionData.getLastTransaction(), sessionData.isLocallyInitiated());
        this.inviteSessionData.addSessionData(sessionDataCopy);
    }

    private SessionData getInviteSessionData(String sessionId) {
        return this.inviteSessionData.getSessionData(sessionId);
    }

    public void updateSipSession(String clientIpAddress, String sessionDescription) {
        String sessionId = this.sipUserAgent.getSessionDataMapping().getKey(clientIpAddress);
        SessionData sessionData = this.sipUserAgent.getSessionDataMapping().getSessionData(sessionId);
        if (sessionData.getState() == 1) {
            sessionData.setPreviousState(1);
        } else if (sessionData.getState() == 3) {
            sessionData.setPreviousState(3);
        } else if (sessionData.getState() == 4) {
            sessionData.setPreviousState(4);
        }
        sessionData.setState(2);
        try {
            this.sipUserAgent.sendReInvite(sessionData.getLocalUser(), sessionData.getLocalUserDisplayName(), sessionDescription, sessionId);
        }
        catch (SipException se) {
            se.printStackTrace();
        }
    }

    protected SessionMapping getInviteSessionMapping() {
        return this.inviteSessionData;
    }

    private boolean isRemoteUserOriginatingSender(Request request, SessionData sessionData) {
        ViaHeader viaHeader = null;
        ListIterator viaHeaders = request.getHeaders("Via");
        if (viaHeaders != null) {
            while (viaHeaders.hasNext()) {
                viaHeader = (ViaHeader)viaHeaders.next();
            }
            if (viaHeader != null) {
                return viaHeader.getHost().equals(sessionData.getRemoteHost()) && viaHeader.getPort() == sessionData.getRemotePort();
            }
        }
        return true;
    }
}

