/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.address;

import gov.nist.core.GenericObject;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.address.NetObject;
import java.util.Iterator;

public class TelephoneNumber
extends NetObject {
    public static final String POSTDIAL = "postdial";
    public static final String PHONE_CONTEXT_TAG = "context-tag";
    public static final String ISUB = "isub";
    public static final String PROVIDER_TAG = "provider-tag";
    protected boolean isglobal;
    protected String phoneNumber;
    protected NameValueList parms = new NameValueList("telparms");

    public void deleteParm(String string) {
        this.parms.delete(string);
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getPostDial() {
        return (String)this.parms.getValue(POSTDIAL);
    }

    public String getIsdnSubaddress() {
        return (String)this.parms.getValue(ISUB);
    }

    public boolean hasPostDial() {
        return this.parms.getValue(POSTDIAL) != null;
    }

    public boolean hasParm(String string) {
        return this.parms.hasNameValue(string);
    }

    public boolean hasIsdnSubaddress() {
        return this.hasParm(ISUB);
    }

    public boolean isGlobal() {
        return this.isglobal;
    }

    public void removePostDial() {
        this.parms.delete(POSTDIAL);
    }

    public void removeIsdnSubaddress() {
        this.deleteParm(ISUB);
    }

    public void setParameters(NameValueList nameValueList) {
        this.parms = nameValueList;
    }

    public void setGlobal(boolean bl) {
        this.isglobal = bl;
    }

    public void setPostDial(String string) {
        NameValue nameValue = new NameValue(POSTDIAL, string);
        this.parms.add(nameValue);
    }

    public void setParm(String string, Object object) {
        NameValue nameValue = new NameValue(string, object);
        this.parms.add(nameValue);
    }

    public void setIsdnSubaddress(String string) {
        this.setParm(ISUB, string);
    }

    public void setPhoneNumber(String string) {
        this.phoneNumber = string;
    }

    public String encode() {
        String string = "";
        if (this.isglobal) {
            string = string + "+";
        }
        string = string + this.phoneNumber;
        if (!this.parms.isEmpty()) {
            string = string + ";";
            string = string + this.parms.encode();
        }
        return string;
    }

    public String getParameter(String string) {
        Object object = this.parms.getValue(string);
        if (object == null) {
            return null;
        }
        if (object instanceof GenericObject) {
            return ((GenericObject)object).encode();
        }
        return object.toString();
    }

    public Iterator getParameterNames() {
        return this.parms.getNames();
    }

    public void removeParameter(String string) {
        this.parms.delete(string);
    }

    public void setParameter(String string, String string2) {
        NameValue nameValue = new NameValue(string, string2);
        this.parms.add(nameValue);
    }

    public Object clone() {
        TelephoneNumber telephoneNumber = (TelephoneNumber)super.clone();
        if (this.parms != null) {
            telephoneNumber.parms = (NameValueList)this.parms.clone();
        }
        return telephoneNumber;
    }
}

