/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.MediaRange;
import gov.nist.javax.sip.header.ParametersHeader;
import javax.sip.InvalidArgumentException;
import javax.sip.header.AcceptHeader;

public class Accept
extends ParametersHeader
implements AcceptHeader {
    protected MediaRange mediaRange;

    public Accept() {
        super("Accept");
    }

    public boolean allowsAllContentTypes() {
        if (this.mediaRange == null) {
            return false;
        }
        return this.mediaRange.type.compareTo("*") == 0;
    }

    public boolean allowsAllContentSubTypes() {
        if (this.mediaRange == null) {
            return false;
        }
        return this.mediaRange.getSubtype().compareTo("*") == 0;
    }

    protected String encodeBody() {
        String string = "";
        if (this.mediaRange != null) {
            string = string + this.mediaRange.encode();
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            string = string + " ;" + this.parameters.encode();
        }
        return string;
    }

    public MediaRange getMediaRange() {
        return this.mediaRange;
    }

    public String getContentType() {
        if (this.mediaRange == null) {
            return null;
        }
        return this.mediaRange.getType();
    }

    public String getContentSubType() {
        if (this.mediaRange == null) {
            return null;
        }
        return this.mediaRange.getSubtype();
    }

    public float getQValue() {
        return this.getParameterAsFloat("q");
    }

    public boolean hasQValue() {
        return super.hasParameter("q");
    }

    public void removeQValue() {
        super.removeParameter("q");
    }

    public void setContentSubType(String string) {
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setSubtype(string);
    }

    public void setContentType(String string) {
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setType(string);
    }

    public void setQValue(float f) throws InvalidArgumentException {
        if (f == -1.0f) {
            super.removeParameter("q");
        }
        super.setParameter("q", f);
    }

    public void setMediaRange(MediaRange mediaRange) {
        this.mediaRange = mediaRange;
    }

    public Object clone() {
        Accept accept = (Accept)super.clone();
        if (this.mediaRange != null) {
            accept.mediaRange = (MediaRange)this.mediaRange.clone();
        }
        return accept;
    }
}

