/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.message.SIPRequest;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.CSeqHeader;

public class CSeq
extends SIPHeader
implements CSeqHeader {
    protected Integer seqno;
    protected String method;

    public CSeq() {
        super("CSeq");
    }

    public CSeq(int n, String string) {
        this();
        this.seqno = new Integer(n);
        this.method = SIPRequest.getCannonicalName(string);
    }

    public boolean equals(Object object) {
        try {
            CSeq cSeq = (CSeq)object;
            if (!this.seqno.equals(cSeq.seqno)) {
                return false;
            }
            return this.method.compareToIgnoreCase(cSeq.method) == 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String encode() {
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    public String encodeBody() {
        return this.seqno + " " + this.method.toUpperCase();
    }

    public String getMethod() {
        return this.method;
    }

    public void setSequenceNumber(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, CSeq, setSequenceNumber(), the sequence number parameter is < 0");
        }
        this.seqno = new Integer(n);
    }

    public void setMethod(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, CSeq, setMethod(), the meth parameter is null");
        }
        this.method = SIPRequest.getCannonicalName(string);
    }

    public int getSequenceNumber() {
        if (this.seqno == null) {
            return 0;
        }
        return this.seqno;
    }
}

