/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;

public class Pipeline
extends InputStream {
    private LinkedList buffList;
    private Buffer currentBuffer;
    private boolean isClosed;
    private Timer timer;
    private InputStream pipe;
    private int readTimeout;
    private TimerTask myTimerTask;

    public void startTimer() {
        if (this.readTimeout == -1) {
            return;
        }
        this.myTimerTask = new MyTimer(this);
        this.timer.schedule(this.myTimerTask, this.readTimeout);
    }

    public void stopTimer() {
        if (this.readTimeout == -1) {
            return;
        }
        if (this.myTimerTask != null) {
            this.myTimerTask.cancel();
        }
    }

    public Pipeline(InputStream inputStream, int n, Timer timer) {
        this.timer = timer;
        this.pipe = inputStream;
        this.buffList = new LinkedList();
        this.readTimeout = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("Closed!!");
        }
        Buffer buffer = new Buffer(byArray, n2);
        buffer.ptr = n;
        LinkedList linkedList = this.buffList;
        synchronized (linkedList) {
            this.buffList.add(buffer);
            this.buffList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray) throws IOException {
        if (this.isClosed) {
            throw new IOException("Closed!!");
        }
        Buffer buffer = new Buffer(byArray, byArray.length);
        LinkedList linkedList = this.buffList;
        synchronized (linkedList) {
            this.buffList.add(buffer);
            this.buffList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.isClosed = true;
        LinkedList linkedList = this.buffList;
        synchronized (linkedList) {
            this.buffList.notifyAll();
        }
    }

    public int read() throws IOException {
        LinkedList linkedList = this.buffList;
        synchronized (linkedList) {
            if (this.currentBuffer != null && this.currentBuffer.ptr < this.currentBuffer.length) {
                int n = this.currentBuffer.getNextByte();
                if (this.currentBuffer.ptr == this.currentBuffer.length) {
                    this.currentBuffer = null;
                }
                return n;
            }
            if (this.isClosed && this.buffList.isEmpty()) {
                return -1;
            }
            try {
                while (this.buffList.isEmpty()) {
                    this.buffList.wait();
                    if (!this.isClosed) continue;
                    return -1;
                }
                this.currentBuffer = (Buffer)this.buffList.removeFirst();
                int n = this.currentBuffer.getNextByte();
                if (this.currentBuffer.ptr == this.currentBuffer.length) {
                    this.currentBuffer = null;
                }
                return n;
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException.getMessage());
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
                throw new IOException(noSuchElementException.getMessage());
            }
        }
    }

    class Buffer {
        byte[] bytes;
        int length;
        int ptr = 0;

        public Buffer(byte[] byArray, int n) {
            this.length = n;
            this.bytes = byArray;
        }

        public int getNextByte() {
            int n = this.bytes[this.ptr++] & 0xFF;
            return n;
        }
    }

    class MyTimer
    extends TimerTask {
        Pipeline pipeline;
        private boolean isCancelled;

        protected MyTimer(Pipeline pipeline2) {
            this.pipeline = pipeline2;
        }

        public void run() {
            if (this.isCancelled) {
                return;
            }
            this.pipeline.close();
            try {
                this.pipeline.pipe.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean cancel() {
            boolean bl = super.cancel();
            this.isCancelled = true;
            return bl;
        }
    }
}

