/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.HostNameParser;
import gov.nist.core.HostPort;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.core.Token;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.address.TelURLImpl;
import gov.nist.javax.sip.address.TelephoneNumber;
import gov.nist.javax.sip.parser.Lexer;
import gov.nist.javax.sip.parser.Parser;
import java.text.ParseException;
import java.util.Vector;

public class URLParser
extends Parser {
    public URLParser(String string) {
        this.lexer = new Lexer("sip_urlLexer", string);
    }

    URLParser(Lexer lexer) {
        this.lexer = lexer;
        this.lexer.selectLexer("sip_urlLexer");
    }

    protected static boolean isMark(char c) {
        return c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')';
    }

    protected static boolean isUnreserved(char c) {
        return Lexer.isAlpha(c) || Lexer.isDigit(c) || URLParser.isMark(c);
    }

    protected static boolean isReservedNoSlash(char c) {
        return c == ';' || c == '?' || c == ':' || c == '@' || c == '&' || c == '+' || c == '$' || c == ',';
    }

    protected static boolean isUserUnreserved(char c) {
        return c == '&' || c == '?' || c == '+' || c == '$' || c == '#' || c == '/' || c == ',' || c == ';' || c == '=';
    }

    protected String unreserved() throws ParseException {
        char c = this.lexer.lookAhead(0);
        if (URLParser.isUnreserved(c)) {
            this.lexer.consume(1);
            return "" + c;
        }
        throw this.createParseException("unreserved");
    }

    protected String paramNameOrValue() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.lexer.hasMoreChars()) {
            char c = this.lexer.lookAhead(0);
            if (c == '[' || c == '[' || c == '/' || c == ':' || c == '&' || c == '+' || c == '$' || URLParser.isUnreserved(c)) {
                stringBuffer.append(c);
                this.lexer.consume(1);
                continue;
            }
            if (!this.isEscaped()) break;
            String string = this.lexer.charAsString(3);
            this.lexer.consume(3);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameValue uriParam() throws ParseException {
        String string;
        String string2;
        block4: {
            string2 = null;
            string = this.paramNameOrValue();
            char c = this.lexer.lookAhead(0);
            if (c == '=') {
                this.lexer.consume(1);
                string2 = this.paramNameOrValue();
            }
            if (!string.toString().equals("") || string2 != null && !string2.toString().equals("")) break block4;
            NameValue nameValue = null;
            return nameValue;
        }
        NameValue nameValue = new NameValue(string, string2);
        return nameValue;
    }

    protected static boolean isReserved(char c) {
        return c == ';' || c == '/' || c == '?' || c == ':' || c == '=' || c == '@' || c == '&' || c == '+' || c == '$' || c == ',';
    }

    protected String reserved() throws ParseException {
        char c = this.lexer.lookAhead(0);
        if (URLParser.isReserved(c)) {
            this.lexer.consume(1);
            return "" + c;
        }
        throw this.createParseException("reserved");
    }

    protected boolean isEscaped() {
        try {
            char c = this.lexer.lookAhead(0);
            char c2 = this.lexer.lookAhead(1);
            char c3 = this.lexer.lookAhead(2);
            return c == '%' && Lexer.isHexDigit(c2) && Lexer.isHexDigit(c3);
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String escaped() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        char c = this.lexer.lookAhead(0);
        char c2 = this.lexer.lookAhead(1);
        char c3 = this.lexer.lookAhead(2);
        if (c != '%' || !Lexer.isHexDigit(c2) || !Lexer.isHexDigit(c3)) {
            throw this.createParseException("escaped");
        }
        this.lexer.consume(3);
        stringBuffer.append(c);
        stringBuffer.append(c2);
        stringBuffer.append(c3);
        String string = stringBuffer.toString();
        return string;
    }

    protected String mark() throws ParseException {
        block3: {
            char c = this.lexer.lookAhead(0);
            if (!URLParser.isMark(c)) break block3;
            this.lexer.consume(1);
            String string = "" + c;
            return string;
        }
        throw this.createParseException("mark");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uric() {
        block9: {
            block8: {
                char c;
                block7: {
                    c = this.lexer.lookAhead(0);
                    if (!URLParser.isUnreserved(c)) break block7;
                    this.lexer.consume(1);
                    String string = Lexer.charAsString(c);
                    return string;
                }
                if (!URLParser.isReserved(c)) break block8;
                this.lexer.consume(1);
                String string = Lexer.charAsString(c);
                return string;
            }
            if (!this.isEscaped()) break block9;
            String string = this.lexer.charAsString(3);
            this.lexer.consume(3);
            String string2 = string;
            return string2;
        }
        try {
            String string = null;
            return string;
        }
        catch (Exception exception) {
            String string = null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uricNoSlash() {
        block9: {
            char c;
            block8: {
                block7: {
                    c = this.lexer.lookAhead(0);
                    if (!this.isEscaped()) break block7;
                    String string = this.lexer.charAsString(3);
                    this.lexer.consume(3);
                    String string2 = string;
                    return string2;
                }
                if (!URLParser.isUnreserved(c)) break block8;
                this.lexer.consume(1);
                String string = Lexer.charAsString(c);
                return string;
            }
            if (!URLParser.isReservedNoSlash(c)) break block9;
            this.lexer.consume(1);
            String string = Lexer.charAsString(c);
            return string;
        }
        try {
            String string = null;
            return string;
        }
        catch (ParseException parseException) {
            String string = null;
            return string;
        }
    }

    protected String uricString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.uric()) != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericURI uriReference() throws ParseException {
        GenericURI genericURI;
        block8: {
            genericURI = null;
            Vector vector = this.lexer.peekNextToken(2);
            Token token = (Token)vector.elementAt(0);
            Token token2 = (Token)vector.elementAt(1);
            if (token.getTokenType() == 2051) {
                if (token2.getTokenType() == 58) {
                    genericURI = this.sipURL();
                    break block8;
                }
                throw this.createParseException("Expecting ':'");
            }
            if (token.getTokenType() == 2105) {
                if (token2.getTokenType() == 58) {
                    genericURI = this.telURL();
                    break block8;
                }
                throw this.createParseException("Expecting ':'");
            }
            String string = this.uricString();
            try {
                genericURI = new GenericURI(string);
            }
            catch (ParseException parseException) {
                throw this.createParseException(parseException.getMessage());
            }
        }
        return genericURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String base_phone_number() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (this.lexer.hasMoreChars()) {
            char c = this.lexer.lookAhead(0);
            if (Lexer.isDigit(c) || c == '-' || c == '.' || c == '(' || c == ')') {
                this.lexer.consume(1);
                stringBuffer.append(c);
                ++n;
                continue;
            }
            if (n > 0) break;
            throw this.createParseException("unexpected " + c);
        }
        String string = stringBuffer.toString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String local_number() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (this.lexer.hasMoreChars()) {
            char c = this.lexer.lookAhead(0);
            if (c == '*' || c == '#' || c == '-' || c == '.' || c == '(' || c == ')' || Lexer.isDigit(c)) {
                this.lexer.consume(1);
                stringBuffer.append(c);
                ++n;
                continue;
            }
            if (n > 0) break;
            throw this.createParseException("unexepcted " + c);
        }
        String string = stringBuffer.toString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TelephoneNumber parseTelephoneNumber() throws ParseException {
        TelephoneNumber telephoneNumber;
        this.lexer.selectLexer("charLexer");
        char c = this.lexer.lookAhead(0);
        if (c == '+') {
            telephoneNumber = this.global_phone_number();
        } else if (Lexer.isAlpha(c) || Lexer.isDigit(c) || c == '-' || c == '*' || c == '.' || c == '(' || c == ')' || c == '#') {
            telephoneNumber = this.local_phone_number();
        } else {
            throw this.createParseException("unexpected char " + c);
        }
        TelephoneNumber telephoneNumber2 = telephoneNumber;
        return telephoneNumber2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TelephoneNumber global_phone_number() throws ParseException {
        char c;
        TelephoneNumber telephoneNumber = new TelephoneNumber();
        telephoneNumber.setGlobal(true);
        NameValueList nameValueList = null;
        this.lexer.match(43);
        String string = this.base_phone_number();
        telephoneNumber.setPhoneNumber(string);
        if (this.lexer.hasMoreChars() && (c = this.lexer.lookAhead(0)) == ';') {
            this.lexer.consume(1);
            nameValueList = this.tel_parameters();
            telephoneNumber.setParameters(nameValueList);
        }
        TelephoneNumber telephoneNumber2 = telephoneNumber;
        return telephoneNumber2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TelephoneNumber local_phone_number() throws ParseException {
        TelephoneNumber telephoneNumber = new TelephoneNumber();
        telephoneNumber.setGlobal(false);
        NameValueList nameValueList = null;
        String string = null;
        string = this.local_number();
        telephoneNumber.setPhoneNumber(string);
        if (this.lexer.hasMoreChars()) {
            Token token = this.lexer.peekNextToken();
            switch (token.getTokenType()) {
                case 59: {
                    this.lexer.consume(1);
                    nameValueList = this.tel_parameters();
                    telephoneNumber.setParameters(nameValueList);
                    break;
                }
            }
        }
        return telephoneNumber;
    }

    private NameValueList tel_parameters() throws ParseException {
        char c;
        NameValueList nameValueList = new NameValueList();
        do {
            NameValue nameValue = this.nameValue('=');
            nameValueList.add(nameValue);
            c = this.lexer.lookAhead(0);
        } while (c == ';');
        return nameValueList;
    }

    public TelURLImpl telURL() throws ParseException {
        this.lexer.match(2105);
        this.lexer.match(58);
        TelephoneNumber telephoneNumber = this.parseTelephoneNumber();
        TelURLImpl telURLImpl = new TelURLImpl();
        telURLImpl.setTelephoneNumber(telephoneNumber);
        return telURLImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipUri sipURL() throws ParseException {
        Object object;
        Object object2;
        Object object3;
        SipUri sipUri = new SipUri();
        this.lexer.match(2051);
        this.lexer.match(58);
        sipUri.setScheme("sip");
        int n = this.lexer.markInputPosition();
        try {
            object3 = this.user();
            char c = this.lexer.lookAhead(0);
            this.lexer.match(58);
            object2 = this.password();
            this.lexer.match(64);
            object = new HostNameParser(this.getLexer());
            HostPort hostPort = ((HostNameParser)object).hostPort();
            sipUri.setUser((String)object3);
            sipUri.setUserPassword((String)object2);
            sipUri.setHostPort(hostPort);
        }
        catch (ParseException parseException) {
            try {
                this.lexer.rewindInputPosition(n);
                String string = this.user();
                this.lexer.match(64);
                object2 = new HostNameParser(this.getLexer());
                object = ((HostNameParser)object2).hostPort();
                sipUri.setUser(string);
                sipUri.setHostPort((HostPort)object);
            }
            catch (ParseException parseException2) {
                this.lexer.rewindInputPosition(n);
                object2 = new HostNameParser(this.getLexer());
                object = ((HostNameParser)object2).hostPort();
                sipUri.setHostPort((HostPort)object);
            }
        }
        this.lexer.selectLexer("charLexer");
        while (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == ';') {
            this.lexer.consume(1);
            object3 = this.uriParam();
            if (object3 == null) continue;
            sipUri.setUriParameter((NameValue)object3);
        }
        if (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == '?') {
            this.lexer.consume(1);
            while (this.lexer.hasMoreChars()) {
                object3 = this.qheader();
                sipUri.setQHeader((NameValue)object3);
                if (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) != '&') break;
                this.lexer.consume(1);
            }
        }
        object3 = sipUri;
        return object3;
    }

    public String peekScheme() throws ParseException {
        Vector vector = this.lexer.peekNextToken(1);
        if (vector.size() == 0) {
            return null;
        }
        String string = ((Token)vector.elementAt(0)).getTokenValue();
        return string;
    }

    protected NameValue qheader() throws ParseException {
        String string = this.lexer.getNextToken('=');
        this.lexer.consume(1);
        String string2 = this.hvalue();
        return new NameValue(string, string2);
    }

    protected String hvalue() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.lexer.hasMoreChars()) {
            char c = this.lexer.lookAhead(0);
            if (c == '+' || c == '?' || c == ':' || c == '[' || c == ']' || c == '/' || c == '$' || c == '_' || c == '-' || c == '\"' || c == '!' || c == '~' || c == '*' || c == '.' || c == '(' || c == ')' || Lexer.isAlpha(c) || Lexer.isDigit(c)) {
                this.lexer.consume(1);
                stringBuffer.append(c);
                continue;
            }
            if (c != '%') break;
            stringBuffer.append(this.escaped());
        }
        return stringBuffer.toString();
    }

    protected String urlString() throws ParseException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        this.lexer.selectLexer("charLexer");
        while (this.lexer.hasMoreChars() && (c = this.lexer.lookAhead(0)) != ' ' && c != '\t' && c != '\n' && c != '>' && c != '<') {
            this.lexer.consume(0);
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String user() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.lexer.hasMoreChars()) {
            char c = this.lexer.lookAhead(0);
            if (URLParser.isUnreserved(c) || URLParser.isUserUnreserved(c)) {
                stringBuffer.append(c);
                this.lexer.consume(1);
                continue;
            }
            if (!this.isEscaped()) break;
            String string = this.lexer.charAsString(3);
            this.lexer.consume(3);
            stringBuffer.append(string);
        }
        String string = stringBuffer.toString();
        return string;
    }

    protected String password() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c;
            if (URLParser.isUnreserved(c = this.lexer.lookAhead(0)) || c == '&' || c == '=' || c == '+' || c == '$' || c == ',') {
                stringBuffer.append(c);
                this.lexer.consume(1);
                continue;
            }
            if (!this.isEscaped()) break;
            String string = this.lexer.charAsString(3);
            stringBuffer.append(string);
            this.lexer.consume(3);
        }
        return stringBuffer.toString();
    }

    public GenericURI parse() throws ParseException {
        return this.uriReference();
    }
}

