/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.stack.SIPMessageStack;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.SSLSocket;

class IOHandler {
    private SIPMessageStack sipStack;
    private static String UDP = "udp";
    private static String TCP = "tcp";
    private static String TLS = "tls";
    private Hashtable socketTable;

    protected static String makeKey(InetAddress inetAddress, int n) {
        return inetAddress.getHostAddress() + ":" + n;
    }

    protected IOHandler(SIPMessageStack sIPMessageStack) {
        this.sipStack = sIPMessageStack;
        this.socketTable = new Hashtable();
    }

    protected synchronized void putSocket(String string, Socket socket) {
        this.socketTable.put(string, socket);
    }

    private synchronized Socket getSocket(String string) {
        return (Socket)this.socketTable.get(string);
    }

    private void removeSocket(String string) {
        this.socketTable.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChunks(OutputStream outputStream, byte[] byArray, int n) throws IOException {
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            int n2 = 8192;
            for (int i = 0; i < n; i += n2) {
                int n3 = i + n2 < n ? n2 : n - i;
                outputStream.write(byArray, i, n3);
            }
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket sendBytes(InetAddress inetAddress, int n, String string, byte[] byArray, boolean bl) throws IOException {
        int n2 = 0;
        int n3 = bl ? 2 : 1;
        int n4 = byArray.length;
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("sendBytes " + string + " inAddr " + inetAddress.getHostAddress() + " port = " + n + " length = " + n4);
        }
        if (string.compareToIgnoreCase(TCP) == 0) {
            String string2 = IOHandler.makeKey(inetAddress, n);
            Hashtable hashtable = this.socketTable;
            synchronized (hashtable) {
                Socket socket = this.getSocket(string2);
                while (n2 < n3) {
                    if (socket == null) {
                        if (LogWriter.needsLogging) {
                            this.sipStack.logWriter.logMessage("inaddr = " + inetAddress);
                            this.sipStack.logWriter.logMessage("port = " + n);
                        }
                        socket = this.sipStack.getNetworkLayer().createSocket(inetAddress, n, this.sipStack.getRealIPAddress());
                        OutputStream outputStream = socket.getOutputStream();
                        this.writeChunks(outputStream, byArray, n4);
                        this.putSocket(string2, socket);
                        break;
                    }
                    try {
                        OutputStream outputStream = socket.getOutputStream();
                        this.writeChunks(outputStream, byArray, n4);
                        break;
                    }
                    catch (IOException iOException) {
                        if (LogWriter.needsLogging) {
                            this.sipStack.logWriter.logException(iOException);
                        }
                        this.removeSocket(string2);
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        socket = null;
                        ++n2;
                    }
                }
                if (socket == null) {
                    throw new IOException("Could not connect to " + inetAddress + ":" + n);
                }
                return socket;
            }
        }
        if (string.compareToIgnoreCase(TLS) == 0) {
            String string3 = IOHandler.makeKey(inetAddress, n);
            Hashtable hashtable = this.socketTable;
            synchronized (hashtable) {
                SSLSocket sSLSocket = (SSLSocket)this.getSocket(string3);
                while (n2 < n3) {
                    if (sSLSocket == null) {
                        if (LogWriter.needsLogging) {
                            this.sipStack.logWriter.logMessage("inaddr = " + inetAddress);
                            this.sipStack.logWriter.logMessage("port = " + n);
                        }
                        sSLSocket = this.sipStack.getNetworkLayer().createSSLSocket(inetAddress, n, this.sipStack.getRealIPAddress());
                        OutputStream outputStream = sSLSocket.getOutputStream();
                        this.writeChunks(outputStream, byArray, n4);
                        this.putSocket(string3, sSLSocket);
                        break;
                    }
                    try {
                        OutputStream outputStream = sSLSocket.getOutputStream();
                        this.writeChunks(outputStream, byArray, n4);
                        break;
                    }
                    catch (IOException iOException) {
                        if (LogWriter.needsLogging) {
                            this.sipStack.logWriter.logException(iOException);
                        }
                        this.removeSocket(string3);
                        try {
                            sSLSocket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        sSLSocket = null;
                        ++n2;
                    }
                }
                if (sSLSocket == null) {
                    throw new IOException("Could not connect to " + inetAddress + ":" + n);
                }
                return sSLSocket;
            }
        }
        DatagramSocket datagramSocket = this.sipStack.getNetworkLayer().createDatagramSocket();
        datagramSocket.connect(inetAddress, n);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 0, n4, inetAddress, n);
        datagramSocket.send(datagramPacket);
        datagramSocket.close();
        return null;
    }

    public void closeAll() {
        Enumeration enumeration = this.socketTable.elements();
        while (enumeration.hasMoreElements()) {
            Socket socket = (Socket)enumeration.nextElement();
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

