/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.GenericObject;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.PendingRecord;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.message.Request;

public class SIPClientTransaction
extends SIPTransaction
implements ServerResponseInterface,
ClientTransaction,
PendingRecord {
    private static final int MAX_PENDING_RESPONSES = 4;
    private LinkedList pendingResponses;
    private SIPRequest lastRequest;
    private int viaPort;
    private String viaHost;
    private ServerResponseInterface respondTo;

    protected SIPClientTransaction(SIPTransactionStack sIPTransactionStack, MessageChannel messageChannel) {
        super(sIPTransactionStack, messageChannel);
        this.setBranch(Utils.generateBranchId());
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Creating clientTransaction " + this);
            this.sipStack.logWriter.logStackTrace();
        }
        this.pendingResponses = new LinkedList();
    }

    public void setResponseInterface(ServerResponseInterface serverResponseInterface) {
        this.respondTo = serverResponseInterface;
    }

    public String getProcessingInfo() {
        return this.respondTo.getProcessingInfo();
    }

    public MessageChannel getRequestChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage sIPMessage) {
        ViaList viaList = sIPMessage.getViaHeaders();
        String string = ((Via)viaList.getFirst()).getBranch();
        boolean bl = this.getBranch() != null && string != null && this.getBranch().startsWith("z9hG4bK") && string.startsWith("z9hG4bK");
        boolean bl2 = false;
        if (TransactionState.COMPLETED == this.getState()) {
            bl2 = bl ? this.getBranch().equals(((Via)viaList.getFirst()).getBranch()) && this.getMethod().equals(sIPMessage.getCSeq().getMethod()) : this.getBranch().equals(sIPMessage.getTransactionId());
        } else if (!this.isTerminated()) {
            if (bl) {
                if (viaList != null && this.getBranch().equals(((Via)viaList.getFirst()).getBranch())) {
                    bl2 = this.getOriginalRequest().getCSeq().getMethod().equals(sIPMessage.getCSeq().getMethod());
                }
            } else {
                bl2 = this.getBranch() != null ? this.getBranch().equals(sIPMessage.getTransactionId()) : this.getOriginalRequest().getTransactionId().equals(sIPMessage.getTransactionId());
            }
        }
        return bl2;
    }

    public void sendMessage(SIPMessage sIPMessage) throws IOException {
        SIPRequest sIPRequest = (SIPRequest)sIPMessage;
        Via via = (Via)sIPRequest.getViaHeaders().getFirst();
        try {
            via.setBranch(this.getBranch());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if ((TransactionState.PROCEEDING == this.getState() || TransactionState.CALLING == this.getState()) && sIPRequest.getMethod().equals("ACK")) {
            if (this.isReliable()) {
                this.setState(TransactionState.TERMINATED);
            } else {
                this.setState(TransactionState.COMPLETED);
            }
            super.sendMessage(sIPRequest);
            return;
        }
        try {
            this.lastRequest = sIPRequest;
            if (this.getState() == null) {
                this.setOriginalRequest(sIPRequest);
                if (sIPRequest.getMethod().equals("INVITE")) {
                    this.setState(TransactionState.CALLING);
                } else if (sIPRequest.getMethod().equals("ACK")) {
                    this.setState(TransactionState.TERMINATED);
                } else {
                    this.setState(TransactionState.TRYING);
                }
                if (!this.isReliable()) {
                    this.enableRetransmissionTimer();
                }
                if (this.isInviteTransaction()) {
                    this.enableTimeoutTimer(64);
                } else {
                    this.enableTimeoutTimer(64);
                }
            }
            super.sendMessage(sIPRequest);
        }
        catch (IOException iOException) {
            this.setState(TransactionState.TERMINATED);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processResponse(SIPResponse sIPResponse, MessageChannel messageChannel) {
        if (this.sipStack.serverLog.needsLogging(16)) {
            this.logResponse(sIPResponse, System.currentTimeMillis(), "normal processing");
        }
        if (this.getState() == null) {
            return;
        }
        if (TransactionState.COMPLETED == this.getState() && sIPResponse.getStatusCode() / 100 == 1) {
            return;
        }
        if (TransactionState.PROCEEDING == this.getState() && sIPResponse.getStatusCode() == 100) {
            this.processPending();
        }
        if (this.eventPending) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Discarding early arriving Response " + sIPResponse.getFirstLine());
            }
            LinkedList linkedList = this.pendingResponses;
            synchronized (linkedList) {
                if (this.pendingResponses.size() < 4) {
                    this.pendingResponses.add(new PendingResponse(sIPResponse, messageChannel));
                }
            }
            this.sipStack.putPending(this);
            return;
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("processing " + sIPResponse.getFirstLine() + "current state = " + this.getState());
        }
        this.lastResponse = sIPResponse;
        if (this.dialog != null) {
            this.dialog.addRoute(sIPResponse);
        }
        String string = sIPResponse.getCSeq().getMethod();
        if (this.dialog != null) {
            boolean bl = false;
            SIPTransactionStack sIPTransactionStack = (SIPTransactionStack)this.getSIPStack();
            if (this.dialog.getRemoteTag() == null && sIPResponse.getTo().getTag() != null) {
                if (sIPResponse.getStatusCode() != 100) {
                    this.dialog.setRemoteTag(sIPResponse.getToTag());
                }
                String string2 = sIPResponse.getDialogId(false);
                this.dialog.setDialogId(string2);
                if (sIPTransactionStack.isDialogCreated(string) && sIPResponse.getStatusCode() != 100) {
                    sIPTransactionStack.putDialog(this.dialog);
                    bl = true;
                }
            } else if (this.dialog.getRemoteTag() != null && sIPResponse.getToTag() != null && !this.dialog.getRemoteTag().equals(sIPResponse.getToTag())) {
                String string3 = sIPResponse.getDialogId(false);
                this.dialog.setRemoteTag(sIPResponse.getToTag());
                this.dialog.setDialogId(string3);
                if (sIPTransactionStack.isDialogCreated(string)) {
                    sIPTransactionStack.putDialog(this.dialog);
                    bl = true;
                }
            }
            if (sIPTransactionStack.isDialogCreated(string)) {
                if (this.dialog.getState() == null && sIPResponse.getStatusCode() / 100 == 1) {
                    this.dialog.setState(0);
                } else if (sIPResponse.getToTag() != null && sIPResponse.getStatusCode() / 100 == 2) {
                    this.dialog.setRemoteTag(sIPResponse.getToTag());
                    this.dialog.setState(1);
                } else if (sIPResponse.getStatusCode() >= 300 && sIPResponse.getStatusCode() <= 699 && (this.dialog.getState() == null || this.dialog.getMethod().equals(this.getMethod()) && this.dialog.getState().getValue() == 0)) {
                    this.dialog.setState(3);
                }
            }
            if (this.getMethod().equals("BYE") && sIPResponse.getStatusCode() == 200) {
                this.dialog.setState(3);
            }
        }
        try {
            if (this.isInviteTransaction()) {
                this.inviteClientTransaction(sIPResponse, messageChannel);
            } else {
                this.nonInviteClientTransaction(sIPResponse, messageChannel);
            }
        }
        catch (IOException iOException) {
            this.setState(TransactionState.TERMINATED);
            this.raiseErrorEvent(2);
        }
    }

    private void nonInviteClientTransaction(SIPResponse sIPResponse, MessageChannel messageChannel) throws IOException {
        int n = sIPResponse.getStatusCode();
        if (TransactionState.TRYING == this.getState()) {
            if (n / 100 == 1) {
                this.setState(TransactionState.PROCEEDING);
                this.enableRetransmissionTimer(8);
                this.enableTimeoutTimer(64);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this);
                }
            } else if (200 <= n && n <= 699) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this);
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(10);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.PROCEEDING == this.getState()) {
            if (n / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this);
                }
            } else if (200 <= n && n <= 699) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this);
                }
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(10);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (LogWriter.needsLogging) {
            this.getSIPStack().logWriter.logMessage(" Not sending response to TU! " + this.getState());
        }
    }

    private void inviteClientTransaction(SIPResponse sIPResponse, MessageChannel messageChannel) throws IOException {
        int n = sIPResponse.getStatusCode();
        if (TransactionState.TERMINATED == this.getState()) {
            return;
        }
        if (TransactionState.CALLING == this.getState()) {
            if (n / 100 == 2) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this);
                }
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(TransactionState.TERMINATED);
            } else if (n / 100 == 1) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this);
                }
                this.setState(TransactionState.PROCEEDING);
            } else if (300 <= n && n <= 699) {
                try {
                    this.sendMessage((SIPRequest)this.createAck());
                }
                catch (SipException sipException) {
                    InternalErrorHandler.handleException((Exception)((Object)sipException));
                }
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this);
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.PROCEEDING == this.getState()) {
            if (n / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this);
                }
            } else if (n / 100 == 2) {
                this.setState(TransactionState.TERMINATED);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this);
                }
            } else if (300 <= n && n <= 699) {
                try {
                    this.sendMessage((SIPRequest)this.createAck());
                }
                catch (SipException sipException) {
                    InternalErrorHandler.handleException((Exception)((Object)sipException));
                }
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this);
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.COMPLETED == this.getState() && 300 <= n && n <= 699) {
            try {
                this.sendMessage((SIPRequest)this.createAck());
            }
            catch (SipException sipException) {
                InternalErrorHandler.handleException((Exception)((Object)sipException));
            }
        }
    }

    public void sendRequest() throws SipException {
        SIPRequest sIPRequest = this.getOriginalRequest();
        try {
            this.isMapped = true;
            this.sendMessage(sIPRequest);
        }
        catch (IOException iOException) {
            throw new SipException(iOException.getMessage());
        }
    }

    protected void fireRetransmissionTimer() {
        try {
            if (this.getState() == null || !this.isMapped) {
                return;
            }
            if (TransactionState.CALLING == this.getState() || TransactionState.TRYING == this.getState()) {
                if (!((SIPTransactionStack)this.getSIPStack()).retransmissionFilter && this.isInviteTransaction()) {
                    this.raiseErrorEvent(3);
                } else if (this.lastRequest != null) {
                    super.sendMessage(this.lastRequest);
                }
            }
        }
        catch (IOException iOException) {
            this.setState(TransactionState.TERMINATED);
            this.raiseErrorEvent(2);
        }
    }

    protected void fireTimeoutTimer() {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("fireTimeoutTimer " + this);
        }
        SIPDialog sIPDialog = this.dialog;
        if ((TransactionState.CALLING == this.getState() || TransactionState.TRYING == this.getState() || TransactionState.PROCEEDING == this.getState()) && sIPDialog != null) {
            if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(this.getOriginalRequest().getMethod())) {
                sIPDialog.setState(3);
            } else if (this.getOriginalRequest().getMethod().equalsIgnoreCase("BYE")) {
                sIPDialog.setState(3);
            }
        }
        if (TransactionState.COMPLETED != this.getState()) {
            this.raiseErrorEvent(1);
        } else {
            this.setState(TransactionState.TERMINATED);
        }
    }

    public Request createCancel() throws SipException {
        SIPRequest sIPRequest = this.getOriginalRequest();
        if (sIPRequest == null) {
            throw new SipException("Bad state " + this.getState());
        }
        if (sIPRequest.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot Cancel ACK!");
        }
        return sIPRequest.createCancelRequest();
    }

    public Request createAck() throws SipException {
        Route route;
        GenericObject genericObject;
        AddressParametersHeader addressParametersHeader;
        SIPRequest sIPRequest = this.getOriginalRequest();
        if (sIPRequest == null) {
            throw new SipException("bad state " + this.getState());
        }
        if (this.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot ACK an ACK!");
        }
        if (this.lastResponse == null) {
            throw new SipException("bad Transaction state");
        }
        if (this.lastResponse.getStatusCode() < 200) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("lastResponse = " + this.lastResponse);
            }
            throw new SipException("Cannot ACK a provisional response!");
        }
        SIPRequest sIPRequest2 = sIPRequest.createAckRequest((To)this.lastResponse.getTo());
        RecordRouteList recordRouteList = this.lastResponse.getRecordRouteHeaders();
        if (recordRouteList == null) {
            Contact contact = null;
            if (this.lastResponse.getContactHeaders() != null) {
                contact = (Contact)this.lastResponse.getContactHeaders().getFirst();
                URI uRI = (URI)contact.getAddress().getURI().clone();
                sIPRequest2.setRequestURI(uRI);
            }
            return sIPRequest2;
        }
        sIPRequest2.removeHeader("Route");
        RouteList routeList = new RouteList();
        ListIterator listIterator = recordRouteList.listIterator(recordRouteList.size());
        while (listIterator.hasPrevious()) {
            addressParametersHeader = (RecordRoute)listIterator.previous();
            genericObject = (AddressImpl)addressParametersHeader.getAddress();
            route = new Route();
            route.setAddress((AddressImpl)((AddressImpl)addressParametersHeader.getAddress()).clone());
            route.setParameters((NameValueList)addressParametersHeader.getParameters().clone());
            routeList.add(route);
        }
        addressParametersHeader = null;
        if (this.lastResponse.getContactHeaders() != null) {
            addressParametersHeader = (Contact)this.lastResponse.getContactHeaders().getFirst();
        }
        if (!((SipURI)((Route)routeList.getFirst()).getAddress().getURI()).hasLrParam()) {
            genericObject = null;
            if (addressParametersHeader != null) {
                genericObject = new Route();
                ((AddressParametersHeader)genericObject).setAddress((AddressImpl)((AddressImpl)((Contact)addressParametersHeader).getAddress()).clone());
            }
            route = (Route)routeList.getFirst();
            routeList.removeFirst();
            URI uRI = route.getAddress().getURI();
            sIPRequest2.setRequestURI(uRI);
            if (genericObject != null) {
                routeList.add(genericObject);
            }
            sIPRequest2.addHeader(routeList);
        } else if (addressParametersHeader != null) {
            genericObject = (URI)((Contact)addressParametersHeader).getAddress().getURI().clone();
            sIPRequest2.setRequestURI((URI)genericObject);
            sIPRequest2.addHeader(routeList);
        }
        return sIPRequest2;
    }

    protected void setViaPort(int n) {
        this.viaPort = n;
    }

    protected void setViaHost(String string) {
        this.viaHost = string;
    }

    public int getViaPort() {
        return this.viaPort;
    }

    public String getViaHost() {
        return this.viaHost;
    }

    public Via getOutgoingViaHeader() {
        return this.getMessageProcessor().getViaHeader();
    }

    public boolean isSecure() {
        return this.encapsulatedChannel.isSecure();
    }

    public void clearState() {
        this.lastRequest = null;
        this.originalRequest = null;
        this.lastResponse = null;
    }

    public void setState(TransactionState transactionState) {
        if (transactionState == TransactionState.TERMINATED && this.isReliable() && !this.getSIPStack().cacheClientConnections) {
            this.collectionTime = 64;
        }
        super.setState(transactionState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPending() {
        PendingResponse pendingResponse;
        LinkedList linkedList = this.pendingResponses;
        synchronized (linkedList) {
            if (this.pendingResponses.isEmpty()) {
                return;
            }
            pendingResponse = (PendingResponse)this.pendingResponses.removeFirst();
        }
        this.processResponse(pendingResponse.sipResponse, pendingResponse.messageChannel);
        this.eventPending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPending() {
        LinkedList linkedList = this.pendingResponses;
        synchronized (linkedList) {
            return !this.pendingResponses.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPending() {
        boolean bl = false;
        LinkedList linkedList = this.pendingResponses;
        synchronized (linkedList) {
            super.clearPending();
            if (this.isTerminated() || !this.pendingResponses.isEmpty()) {
                if (LogWriter.needsLogging) {
                    this.sipStack.logWriter.logMessage("signaling pending response scanner!");
                }
                bl = true;
            }
        }
        if (bl) {
            this.sipStack.notifyPendingRecordScanner();
        }
    }

    protected void startTransactionTimer() {
        this.myTimer = new TransactionTimer(this);
        this.sipStack.timer.schedule(this.myTimer, 500L, 500L);
    }

    public class TransactionTimer
    extends TimerTask {
        protected SIPClientTransaction clientTransaction;
        protected SIPTransactionStack sipStack;

        public TransactionTimer(SIPClientTransaction sIPClientTransaction2) {
            this.clientTransaction = sIPClientTransaction2;
            this.sipStack = sIPClientTransaction2.sipStack;
        }

        public void run() {
            if (this.clientTransaction.isTerminated()) {
                block10: {
                    if (LogWriter.needsLogging) {
                        this.sipStack.logWriter.logMessage("removing  = " + this.clientTransaction + " isReliable " + this.clientTransaction.isReliable());
                    }
                    this.sipStack.removeTransaction(this.clientTransaction);
                    try {
                        this.cancel();
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (this.sipStack.isAlive()) break block10;
                        return;
                    }
                }
                if (!this.sipStack.cacheClientConnections && this.clientTransaction.isReliable()) {
                    int n = this.clientTransaction.encapsulatedChannel instanceof TCPMessageChannel ? --((TCPMessageChannel)this.clientTransaction.encapsulatedChannel).useCount : --((TLSMessageChannel)this.clientTransaction.encapsulatedChannel).useCount;
                    if (n == 0) {
                        this.clientTransaction.myTimer = new SIPTransaction.LingerTimer(SIPClientTransaction.this, this.clientTransaction);
                        this.sipStack.timer.schedule(SIPClientTransaction.this.myTimer, 32000L);
                    }
                } else if (LogWriter.needsLogging && this.clientTransaction.isReliable()) {
                    int n = this.clientTransaction.encapsulatedChannel instanceof TCPMessageChannel ? ((TCPMessageChannel)this.clientTransaction.encapsulatedChannel).useCount : ((TLSMessageChannel)this.clientTransaction.encapsulatedChannel).useCount;
                    if (LogWriter.needsLogging) {
                        this.sipStack.logWriter.logMessage("Client Use Count = " + n);
                    }
                }
            } else {
                this.clientTransaction.fireTimer();
            }
        }
    }

    class PendingResponse {
        protected SIPResponse sipResponse;
        protected MessageChannel messageChannel;

        public PendingResponse(SIPResponse sIPResponse, MessageChannel messageChannel) {
            this.sipResponse = sIPResponse;
            this.messageChannel = messageChannel;
        }
    }
}

