/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.GenericObject;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.NistSipMessageHandlerImpl;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.SIPHeaderList;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.PendingRecord;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.address.Address;
import javax.sip.address.Hop;
import javax.sip.address.URI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.message.Request;

public class SIPDialog
implements Dialog,
PendingRecord {
    private boolean reInviteFlag;
    private Object applicationData;
    private SIPRequest originalRequest;
    private SIPTransaction firstTransaction;
    private SIPTransaction lastTransaction;
    private String dialogId;
    private int localSequenceNumber = 0;
    private int remoteSequenceNumber = -1;
    private String myTag;
    private String hisTag;
    private RouteList routeList;
    private Route contactRoute;
    private String user;
    private Route defaultRoute;
    private SIPTransactionStack sipStack;
    private int dialogState = -1;
    private boolean ackSeen;
    protected SIPRequest lastAck;
    protected boolean ackProcessed;
    protected DialogTimerTask timerTask;
    protected Integer nextSeqno;
    protected static final int WINDOW_SIZE = 8;
    protected Hashtable pendingRecords = new Hashtable();
    private int retransmissionTicksLeft;
    private int prevRetransmissionTicks;
    protected boolean inPendingQueue;
    private int increment;
    private int ackLine;
    protected Address localParty;
    protected Address remoteParty;
    protected CallIdHeader callIdHeader;
    public static final int EARLY_STATE = 0;
    public static final int CONFIRMED_STATE = 1;
    public static final int COMPLETED_STATE = 2;
    public static final int TERMINATED_STATE = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPending(NistSipMessageHandlerImpl nistSipMessageHandlerImpl, int n) {
        boolean bl = false;
        Hashtable hashtable = this.pendingRecords;
        synchronized (hashtable) {
            if (this.nextSeqno != null && n > this.nextSeqno + 8) {
                return;
            }
            if (this.pendingRecords.containsKey(new Integer(n))) {
                return;
            }
            this.pendingRecords.put(new Integer(n), nistSipMessageHandlerImpl);
            bl = true;
        }
        if (bl) {
            this.sipStack.putPending(this);
        }
    }

    public boolean isTerminated() {
        return this.dialogState == 3;
    }

    public void setApplicationData(Object object) {
        this.applicationData = object;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestConsumed() {
        boolean bl = false;
        this.nextSeqno = new Integer(this.getRemoteSequenceNumber() + 1);
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Request Consumed -- next consumable Request Seqno = " + this.nextSeqno);
        }
        Hashtable hashtable = this.pendingRecords;
        synchronized (hashtable) {
            if (this.pendingRecords.containsKey(this.nextSeqno)) {
                bl = true;
            }
        }
        if (bl) {
            this.sipStack.notifyPendingRecordScanner();
        }
    }

    public boolean isRequestConsumable(SIPRequest sIPRequest) {
        if (this.getRemoteSequenceNumber() == -1) {
            return true;
        }
        if (this.nextSeqno == null) {
            return false;
        }
        return this.nextSeqno.intValue() == sIPRequest.getCSeq().getSequenceNumber();
    }

    private void printRouteList() {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("this : " + this);
            this.sipStack.logWriter.logMessage("printRouteList : " + this.routeList.encode());
            if (this.contactRoute != null) {
                this.sipStack.logWriter.logMessage("contactRoute : " + this.contactRoute.encode());
            } else {
                this.sipStack.logWriter.logMessage("contactRoute : null");
            }
        }
    }

    public HopImpl getNextHop() throws SipException {
        Object object;
        RouteList routeList = this.getRouteList();
        SipUri sipUri = null;
        if (routeList != null && !routeList.isEmpty()) {
            object = (Route)this.getRouteList().getFirst();
            sipUri = (SipUri)((AddressParametersHeader)object).getAddress().getURI();
        } else if (this.contactRoute != null && this.contactRoute.getAddress().getURI() instanceof SipUri) {
            sipUri = (SipUri)this.contactRoute.getAddress().getURI();
        } else {
            throw new SipException("No route found!");
        }
        object = sipUri.getMAddrParam() != null ? sipUri.getMAddrParam() : sipUri.getHost();
        String string = sipUri.getTransportParam();
        if (string == null) {
            string = "udp";
        }
        int n = sipUri.getPort();
        if ("tls".equalsIgnoreCase(string)) {
            n = 5061;
        }
        if (n == -1) {
            n = 5060;
        }
        return new HopImpl((String)object, n, string);
    }

    public boolean isClientDialog() {
        SIPTransaction sIPTransaction = (SIPTransaction)this.getFirstTransaction();
        return sIPTransaction instanceof SIPClientTransaction;
    }

    public void setState(int n) {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Setting dialog state for " + this);
            this.sipStack.logWriter.logStackTrace();
            if (n != -1 && n != this.dialogState && LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("New dialog state is " + DialogState.getObject((int)n) + "dialogId = " + this.getDialogId());
            }
        }
        this.dialogState = n;
        if (n == 3) {
            this.sipStack.removeDialog(this);
            this.stopTimer();
            this.sipStack.removePending(this);
        }
    }

    public void printDebugInfo() {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("isServer = " + this.isServer());
            this.sipStack.logWriter.logMessage("localTag = " + this.getLocalTag());
            this.sipStack.logWriter.logMessage("remoteTag = " + this.getRemoteTag());
            this.sipStack.logWriter.logMessage("localSequenceNumer = " + this.getLocalSequenceNumber());
            this.sipStack.logWriter.logMessage("remoteSequenceNumer = " + this.getRemoteSequenceNumber());
            this.sipStack.logWriter.logMessage("ackLine:" + this.getRemoteTag() + " " + this.ackLine);
        }
    }

    public void ackReceived(SIPRequest sIPRequest) {
        if (this.ackSeen) {
            return;
        }
        SIPServerTransaction sIPServerTransaction = this.getInviteTransaction();
        if (sIPServerTransaction != null && sIPServerTransaction.getCSeq() == sIPRequest.getCSeq().getSequenceNumber()) {
            this.ackSeen = true;
            this.lastAck = sIPRequest;
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("ackReceived for " + sIPServerTransaction.getMethod());
                this.ackLine = this.sipStack.logWriter.getLineCount();
                this.printDebugInfo();
            }
            this.setState(1);
        }
    }

    public boolean isAckSeen() {
        return this.ackSeen;
    }

    public SIPRequest getLastAck() {
        return this.lastAck;
    }

    public Transaction getFirstTransaction() {
        return this.firstTransaction;
    }

    public Iterator getRouteSet() {
        if (this.routeList == null) {
            return new LinkedList().listIterator();
        }
        return this.getRouteList().listIterator();
    }

    private synchronized RouteList getRouteList() {
        Route route;
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("getRouteList " + this);
        }
        ListIterator listIterator = this.routeList.listIterator(this.routeList.size());
        boolean bl = true;
        RouteList routeList = new RouteList();
        while (listIterator.hasPrevious()) {
            route = (Route)listIterator.previous();
            String string = ((SipUri)route.getAddress().getURI()).getHost();
            int n = ((SipUri)route.getAddress().getURI()).getPort();
            if (n == -1) {
                n = 5060;
            }
            String string2 = ((SipUri)route.getAddress().getURI()).getTransportParam();
            String string3 = this.sipStack.getHostAddress();
            int n2 = this.firstTransaction.getPort();
            if (bl && string3.equalsIgnoreCase(string) && n == n2) {
                bl = false;
                continue;
            }
            routeList.addFirst(route.clone());
        }
        if (bl) {
            routeList = new RouteList();
            listIterator = this.routeList.listIterator();
            while (listIterator.hasNext()) {
                route = (Route)listIterator.next();
                routeList.add(route.clone());
            }
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("----- ");
            this.sipStack.logWriter.logMessage("getRouteList for " + this);
            if (routeList != null) {
                this.sipStack.logWriter.logMessage("RouteList = " + routeList.encode());
            }
            this.sipStack.logWriter.logMessage("myRouteList = " + this.routeList.encode());
            this.sipStack.logWriter.logMessage("----- ");
        }
        return routeList;
    }

    public void setStack(SIPTransactionStack sIPTransactionStack) {
        this.sipStack = sIPTransactionStack;
    }

    public void setDefaultRoute(Route route) {
        this.defaultRoute = (Route)route.clone();
    }

    public void setUser(String string) {
        this.user = string;
    }

    private void addRoute(RecordRouteList recordRouteList) {
        if (this.isClientDialog()) {
            this.routeList = new RouteList();
            ListIterator listIterator = recordRouteList.listIterator(recordRouteList.size());
            while (listIterator.hasPrevious()) {
                RecordRoute recordRoute = (RecordRoute)listIterator.previous();
                AddressImpl addressImpl = (AddressImpl)recordRoute.getAddress();
                Route route = new Route();
                route.setAddress((AddressImpl)((AddressImpl)recordRoute.getAddress()).clone());
                route.setParameters((NameValueList)recordRoute.getParameters().clone());
                this.routeList.add(route);
            }
        } else {
            this.routeList = new RouteList();
            ListIterator listIterator = recordRouteList.listIterator();
            while (listIterator.hasNext()) {
                RecordRoute recordRoute = (RecordRoute)listIterator.next();
                Route route = new Route();
                route.setAddress((AddressImpl)((AddressImpl)recordRoute.getAddress()).clone());
                route.setParameters((NameValueList)recordRoute.getParameters().clone());
                this.routeList.add(route);
            }
        }
    }

    private void addRoute(ContactList contactList) {
        if (contactList.size() == 0) {
            return;
        }
        Contact contact = (Contact)contactList.getFirst();
        Route route = new Route();
        route.setAddress((AddressImpl)((AddressImpl)contact.getAddress()).clone());
        this.contactRoute = route;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void addRoute(SIPMessage sIPMessage) {
        block16: {
            block17: {
                try {
                    block19: {
                        block18: {
                            if (LogWriter.needsLogging) {
                                this.sipStack.logWriter.logMessage("addRoute: dialogState: " + this + "state = " + this.getState());
                            }
                            if (this.dialogState == 1 || this.dialogState == 2) break block18;
                            if (this.dialogState != 3) break block19;
                        }
                        Object var6_2 = null;
                        if (!LogWriter.needsLogging) return;
                        this.sipStack.logWriter.logStackTrace();
                        this.sipStack.logWriter.logMessage("added a route = " + this.routeList.encode() + "contactRoute = " + this.contactRoute);
                        return;
                    }
                    if (!this.isServer()) {
                        if (!(sIPMessage instanceof SIPResponse)) break block16;
                        SIPResponse sIPResponse = (SIPResponse)sIPMessage;
                        if (sIPResponse.getStatusCode() == 100) {
                            break block17;
                        }
                        RecordRouteList recordRouteList = sIPMessage.getRecordRouteHeaders();
                        if (recordRouteList != null) {
                            this.addRoute(recordRouteList);
                        } else {
                            this.routeList = new RouteList();
                        }
                        ContactList contactList = sIPMessage.getContactHeaders();
                        if (contactList != null) {
                            this.addRoute(contactList);
                        }
                        break block16;
                    }
                    if (!(sIPMessage instanceof SIPRequest)) break block16;
                    RecordRouteList recordRouteList = sIPMessage.getRecordRouteHeaders();
                    if (recordRouteList != null) {
                        this.addRoute(recordRouteList);
                    } else {
                        this.routeList = new RouteList();
                    }
                    ContactList contactList = sIPMessage.getContactHeaders();
                    if (contactList != null) {
                        this.addRoute(contactList);
                    }
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    if (!LogWriter.needsLogging) throw throwable;
                    this.sipStack.logWriter.logStackTrace();
                    this.sipStack.logWriter.logMessage("added a route = " + this.routeList.encode() + "contactRoute = " + this.contactRoute);
                    throw throwable;
                }
            }
            Object var6_3 = null;
            if (!LogWriter.needsLogging) return;
            this.sipStack.logWriter.logStackTrace();
            this.sipStack.logWriter.logMessage("added a route = " + this.routeList.encode() + "contactRoute = " + this.contactRoute);
            return;
        }
        Object var6_4 = null;
        if (!LogWriter.needsLogging) return;
        this.sipStack.logWriter.logStackTrace();
        this.sipStack.logWriter.logMessage("added a route = " + this.routeList.encode() + "contactRoute = " + this.contactRoute);
    }

    protected SIPDialog() {
        this.routeList = new RouteList();
    }

    public void setDialogId(String string) {
        this.dialogId = string;
    }

    protected SIPDialog(SIPTransaction sIPTransaction) {
        this();
        this.sipStack = sIPTransaction.sipStack;
        this.addTransaction(sIPTransaction);
    }

    public boolean isServer() {
        return this.firstTransaction instanceof SIPServerTransaction;
    }

    protected boolean isReInvite() {
        return this.reInviteFlag;
    }

    public String getDialogId() {
        if (this.firstTransaction instanceof SIPServerTransaction) {
            if (this.originalRequest != null) {
                this.dialogId = this.originalRequest.getDialogId(true, this.myTag);
            }
        } else if (this.getFirstTransaction() != null && ((SIPClientTransaction)this.getFirstTransaction()).getLastResponse() != null) {
            this.dialogId = ((SIPClientTransaction)this.firstTransaction).getLastResponse().getDialogId(false, this.hisTag);
        }
        return this.dialogId;
    }

    public void addTransaction(SIPTransaction sIPTransaction) {
        SIPRequest sIPRequest = sIPTransaction.getOriginalRequest();
        if (this.firstTransaction != null && this.firstTransaction != sIPTransaction && sIPTransaction.getMethod().equals(this.firstTransaction.getMethod())) {
            this.reInviteFlag = true;
        }
        if (sIPRequest.getMethod().equals("BYE")) {
            this.setState(2);
        }
        if (this.firstTransaction == null) {
            this.firstTransaction = sIPTransaction;
            this.setLocalParty(sIPRequest);
            this.setRemoteParty(sIPRequest);
            this.setCallId(sIPRequest);
            this.originalRequest = sIPRequest;
            if (sIPTransaction instanceof SIPServerTransaction) {
                this.hisTag = sIPRequest.getFrom().getTag();
            } else {
                this.setLocalSequenceNumber(sIPRequest.getCSeq().getSequenceNumber());
                this.myTag = sIPRequest.getFrom().getTag();
                if (this.myTag == null) {
                    throw new RuntimeException("The request's From header is missing the required Tag parameter.");
                }
            }
        } else if (sIPTransaction.getMethod().equals(this.firstTransaction.getMethod()) && (this.firstTransaction instanceof SIPServerTransaction && sIPTransaction instanceof SIPClientTransaction || this.firstTransaction instanceof SIPClientTransaction && sIPTransaction instanceof SIPServerTransaction)) {
            this.firstTransaction = sIPTransaction;
            this.setLocalParty(sIPRequest);
            this.setRemoteParty(sIPRequest);
            this.setCallId(sIPRequest);
            this.originalRequest = sIPRequest;
        }
        if (sIPTransaction instanceof SIPServerTransaction) {
            this.setRemoteSequenceNumber(sIPRequest.getCSeq().getSequenceNumber());
        }
        this.lastTransaction = sIPTransaction;
        sIPTransaction.setDialog(this);
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Transaction Added " + this + this.myTag + "/" + this.hisTag);
            this.sipStack.logWriter.logMessage("TID = " + sIPTransaction.getTransactionId() + "/" + sIPTransaction.IsServerTransaction());
            this.sipStack.logWriter.logStackTrace();
        }
    }

    public void setRemoteTag(String string) {
        this.hisTag = string;
    }

    public SIPTransaction getLastTransaction() {
        return this.lastTransaction;
    }

    public SIPServerTransaction getInviteTransaction() {
        if (this.timerTask != null) {
            return this.timerTask.transaction;
        }
        return null;
    }

    protected void setLocalSequenceNumber(int n) {
        this.localSequenceNumber = n;
    }

    public void setRemoteSequenceNumber(int n) {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("setRemoteSeqno " + this + "/" + n);
        }
        this.remoteSequenceNumber = n;
    }

    public void incrementLocalSequenceNumber() {
        ++this.localSequenceNumber;
    }

    public int getRemoteSequenceNumber() {
        return this.remoteSequenceNumber;
    }

    public int getLocalSequenceNumber() {
        return this.localSequenceNumber;
    }

    public String getLocalTag() {
        return this.myTag;
    }

    public String getRemoteTag() {
        return this.hisTag;
    }

    public void setLocalTag(String string) {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("set Local tag " + string + " " + this.dialogId);
            this.sipStack.logWriter.logStackTrace();
        }
        this.myTag = string;
    }

    protected void deleteTransactions() {
        this.firstTransaction = null;
        this.lastTransaction = null;
    }

    public void delete() {
        this.setState(3);
    }

    public CallIdHeader getCallId() {
        return this.callIdHeader;
    }

    private void setCallId(SIPRequest sIPRequest) {
        this.callIdHeader = sIPRequest.getCallId();
    }

    public Address getLocalParty() {
        return this.localParty;
    }

    private void setLocalParty(SIPRequest sIPRequest) {
        this.localParty = !this.isServer() ? sIPRequest.getFrom().getAddress() : sIPRequest.getTo().getAddress();
    }

    public Address getRemoteParty() {
        return this.remoteParty;
    }

    private void setRemoteParty(SIPRequest sIPRequest) {
        this.remoteParty = !this.isServer() ? sIPRequest.getTo().getAddress() : sIPRequest.getFrom().getAddress();
    }

    public Address getRemoteTarget() {
        if (this.contactRoute == null) {
            return null;
        }
        return this.contactRoute.getAddress();
    }

    public DialogState getState() {
        if (this.dialogState == -1) {
            return null;
        }
        return DialogState.getObject((int)this.dialogState);
    }

    public boolean isSecure() {
        return this.getFirstTransaction().getRequest().getRequestURI().getScheme().equalsIgnoreCase("sips");
    }

    public void sendAck(Request request) throws SipException {
        Object object;
        Object object2;
        Object object3;
        SIPRequest sIPRequest = (SIPRequest)request;
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("sendAck" + this);
        }
        if (!sIPRequest.getMethod().equals("ACK") && !sIPRequest.getMethod().equals("PRACK")) {
            throw new SipException("Bad request method -- should be ACK");
        }
        if (sIPRequest.getMethod().equals("ACK") && (this.getState() == null || this.getState().getValue() == 0)) {
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (sIPRequest.getMethod().equals("PRACK") && this.getState() == null) {
            throw new SipException("Bad dialog state sending PRACK" + this.getState());
        }
        if (sIPRequest.getMethod().equals("PRACK") && this.getState().getValue() == 0) {
            this.setState(1);
        }
        if (!this.getCallId().getCallId().equals(((SIPRequest)request).getCallId().getCallId())) {
            throw new SipException("Bad call ID in request");
        }
        try {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("setting from tag For outgoing ACK= " + this.getLocalTag());
                this.sipStack.logWriter.logMessage("setting To tag for outgoing ACK = " + this.getRemoteTag());
            }
            if (this.getLocalTag() != null) {
                sIPRequest.getFrom().setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                sIPRequest.getTo().setTag(this.getRemoteTag());
            }
        }
        catch (ParseException parseException) {
            throw new SipException(parseException.getMessage());
        }
        if (sIPRequest.getHeader("Route") == null) {
            object3 = this.getRouteList();
            if (((SIPHeaderList)object3).size() > 0) {
                object2 = (Route)((SIPHeaderList)object3).getFirst();
                object = (SipUri)((AddressParametersHeader)object2).getAddress().getURI();
                if (object.hasLrParam()) {
                    sIPRequest.setRequestURI(this.getRemoteTarget().getURI());
                    sIPRequest.addHeader((Header)object3);
                } else {
                    ((SIPHeaderList)object3).removeFirst();
                    sIPRequest.setRequestURI((URI)object);
                    if (((SIPHeaderList)object3).size() > 0) {
                        sIPRequest.addHeader((Header)object3);
                    }
                    if (this.contactRoute != null) {
                        sIPRequest.addHeader(this.contactRoute);
                    }
                }
            } else if (this.getRemoteTarget() != null) {
                sIPRequest.setRequestURI(this.getRemoteTarget().getURI());
            }
        }
        object3 = this.getNextHop();
        try {
            object2 = this.sipStack.createRawMessageChannel(this.firstTransaction.getPort(), (Hop)object3);
            if (object2 == null) {
                object = this.sipStack.getRouter().getOutboundProxy();
                if (object == null) {
                    throw new SipException("No route found!");
                }
                object2 = this.sipStack.createRawMessageChannel(this.firstTransaction.getPort(), (Hop)object);
            }
            object = (SIPClientTransaction)this.sipStack.createMessageChannel((MessageChannel)object2);
            ((SIPTransaction)object).setOriginalRequest(sIPRequest);
            ((SIPClientTransaction)object).sendMessage(sIPRequest);
            this.lastAck = sIPRequest;
            ((SIPClientTransaction)object).setState(SIPTransaction.TERMINATED_STATE);
        }
        catch (Exception exception) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logException(exception);
            }
            throw new SipException("Cold not create message channel");
        }
    }

    public Request createRequest(String string) throws SipException {
        SIPHeader sIPHeader;
        GenericObject genericObject;
        Object object;
        if (string == null) {
            throw new NullPointerException("null method");
        }
        if (this.getState() == null || this.getState().getValue() == 3 && !string.equalsIgnoreCase("BYE") || this.isServer() && this.getState().getValue() == 0 && string.equalsIgnoreCase("BYE")) {
            throw new SipException("Dialog  " + this.getDialogId() + " not yet established or terminated " + this.getState());
        }
        RequestLine requestLine = new RequestLine();
        requestLine.setUri((GenericURI)this.getRemoteParty().getURI());
        requestLine.setMethod(string);
        SIPRequest sIPRequest = this.originalRequest.createSIPRequest(requestLine, this.isServer());
        try {
            if (!string.equals("ACK")) {
                object = (CSeq)sIPRequest.getCSeq();
                ((CSeq)object).setSequenceNumber(this.localSequenceNumber + 1);
            } else {
                object = this.lastTransaction;
                if (object == null) {
                    throw new SipException("Could not create ack!");
                }
                genericObject = this.lastTransaction.getLastResponse();
                if (genericObject == null) {
                    throw new SipException("Could not find response!");
                }
                int n = ((SIPMessage)genericObject).getCSeq().getSequenceNumber();
                sIPHeader = (CSeq)sIPRequest.getCSeq();
                ((CSeq)sIPHeader).setSequenceNumber(n);
            }
        }
        catch (InvalidArgumentException invalidArgumentException) {
            InternalErrorHandler.handleException((Exception)((Object)invalidArgumentException));
        }
        if (this.isServer()) {
            sIPRequest.removeHeader("Via");
            object = this.sipStack.getMessageProcessor(this.firstTransaction.encapsulatedChannel.getTransport());
            genericObject = ((MessageProcessor)object).getViaHeader();
            sIPRequest.addHeader((Header)genericObject);
        }
        object = (From)sIPRequest.getFrom();
        genericObject = (To)sIPRequest.getTo();
        try {
            if (this.getLocalTag() != null) {
                ((From)object).setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                ((To)genericObject).setTag(this.getRemoteTag());
            }
        }
        catch (ParseException parseException) {
            InternalErrorHandler.handleException(parseException);
        }
        RouteList routeList = this.getRouteList();
        if (routeList.size() > 0) {
            sIPHeader = (Route)routeList.getFirst();
            SipUri sipUri = (SipUri)((AddressParametersHeader)sIPHeader).getAddress().getURI();
            if (sipUri.hasLrParam()) {
                if (this.getRemoteTarget() != null) {
                    sIPRequest.setRequestURI(this.getRemoteTarget().getURI());
                }
                sIPRequest.addHeader(routeList);
            } else {
                routeList.removeFirst();
                sIPRequest.setRequestURI(sipUri);
                if (routeList.size() > 0) {
                    sIPRequest.addHeader(routeList);
                }
                if (this.contactRoute != null) {
                    sIPRequest.addHeader(this.contactRoute);
                }
            }
        } else if (this.getRemoteTarget() != null) {
            sIPRequest.setRequestURI(this.getRemoteTarget().getURI());
        }
        try {
            if (sIPRequest.getRequestURI() instanceof SipUri) {
                ((SipUri)sIPRequest.getRequestURI()).setTransportParam(sIPRequest.getTopmostVia().getTransport());
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return sIPRequest;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendRequest(ClientTransaction clientTransaction) throws TransactionDoesNotExistException, SipException {
        Object object;
        Object object2;
        Object object3;
        ParametersHeader parametersHeader;
        SIPRequest sIPRequest = ((SIPClientTransaction)clientTransaction).getOriginalRequest();
        if (clientTransaction == null) {
            throw new NullPointerException("null parameter");
        }
        if (sIPRequest.getMethod().equals("ACK") || sIPRequest.getMethod().equals("CANCEL")) {
            throw new SipException("Bad Request Method. " + sIPRequest.getMethod());
        }
        if (this.getState() == null) {
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("dialog.sendRequest  dialog = " + this + "\ndialogRequest = \n" + sIPRequest);
        }
        if (sIPRequest.getTopmostVia() == null) {
            parametersHeader = ((SIPClientTransaction)clientTransaction).getOutgoingViaHeader();
            sIPRequest.addHeader(parametersHeader);
        }
        if (!this.getCallId().getCallId().equals(sIPRequest.getCallId().getCallId())) {
            throw new SipException("Bad call ID in request");
        }
        ((SIPClientTransaction)clientTransaction).dialog = this;
        this.addTransaction((SIPTransaction)clientTransaction);
        ((SIPClientTransaction)clientTransaction).isMapped = true;
        parametersHeader = (From)sIPRequest.getFrom();
        To to = (To)sIPRequest.getTo();
        try {
            if (this.getLocalTag() != null) {
                ((From)parametersHeader).setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                to.setTag(this.getRemoteTag());
            }
        }
        catch (ParseException parseException) {
            System.out.println("Huh??");
            parseException.printStackTrace();
        }
        if (sIPRequest.getHeader("Route") == null) {
            object3 = this.getRouteList();
            if (((SIPHeaderList)object3).size() > 0) {
                object2 = (Route)((SIPHeaderList)object3).getFirst();
                object = (SipUri)((AddressParametersHeader)object2).getAddress().getURI();
                if (object.hasLrParam()) {
                    sIPRequest.setRequestURI(this.getRemoteTarget().getURI());
                    sIPRequest.addHeader((Header)object3);
                } else {
                    ((SIPHeaderList)object3).removeFirst();
                    sIPRequest.setRequestURI((URI)object);
                    if (((SIPHeaderList)object3).size() > 0) {
                        sIPRequest.addHeader((Header)object3);
                    }
                    if (this.contactRoute != null) {
                        sIPRequest.addHeader(this.contactRoute);
                    }
                }
            } else if (this.getRemoteTarget() != null) {
                sIPRequest.setRequestURI(this.getRemoteTarget().getURI());
            }
        }
        try {
            object3 = this.getNextHop();
        }
        catch (SipException sipException) {
            object = this.sipStack.getNextHop(sIPRequest);
            if (!object.hasNext()) throw sipException;
            Hop hop = (Hop)object.next();
            object3 = new HopImpl(hop.getHost(), hop.getPort(), hop.getTransport());
        }
        try {
            void var8_19;
            object2 = null;
            object = null;
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(this.firstTransaction.getPort(), (Hop)object3);
            if (((SIPClientTransaction)clientTransaction).encapsulatedChannel instanceof TCPMessageChannel) {
                object2 = (TCPMessageChannel)((SIPClientTransaction)clientTransaction).encapsulatedChannel;
                if (((TCPMessageChannel)object2).isCached && !((TCPMessageChannel)object2).isRunning) {
                    ((TCPMessageChannel)object2).uncache();
                }
                if (!this.sipStack.cacheClientConnections) {
                    --((TCPMessageChannel)object2).useCount;
                    if (LogWriter.needsLogging) {
                        this.sipStack.logWriter.logMessage("oldChannel: useCount " + ((TCPMessageChannel)object2).useCount);
                    }
                }
            } else if (((SIPClientTransaction)clientTransaction).encapsulatedChannel instanceof TLSMessageChannel) {
                object = (TLSMessageChannel)((SIPClientTransaction)clientTransaction).encapsulatedChannel;
                if (((TLSMessageChannel)object).isCached && !((TLSMessageChannel)object).isRunning) {
                    ((TLSMessageChannel)object).uncache();
                }
                if (!this.sipStack.cacheClientConnections) {
                    --((TLSMessageChannel)object).useCount;
                    if (LogWriter.needsLogging) {
                        this.sipStack.logWriter.logMessage("oldChannel: useCount " + ((TLSMessageChannel)object).useCount);
                    }
                }
            }
            ((SIPClientTransaction)clientTransaction).setEncapsulatedChannel(messageChannel);
            if (messageChannel == null) {
                Hop hop;
                if (LogWriter.needsLogging) {
                    this.sipStack.logWriter.logMessage("Null message channel using outbound proxy !");
                }
                if ((hop = this.sipStack.getRouter().getOutboundProxy()) == null) {
                    throw new SipException("No route found!");
                }
                MessageChannel messageChannel2 = this.sipStack.createRawMessageChannel(this.firstTransaction.getPort(), hop);
                ((SIPClientTransaction)clientTransaction).setEncapsulatedChannel(messageChannel2);
            } else if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("using message channel " + messageChannel);
            }
            if (var8_19 != null && var8_19 instanceof TCPMessageChannel) {
                ++((TCPMessageChannel)var8_19).useCount;
            }
            if (var8_19 != null && var8_19 instanceof TLSMessageChannel) {
                ++((TLSMessageChannel)var8_19).useCount;
            }
            if (!this.sipStack.cacheClientConnections && object2 != null && ((TCPMessageChannel)object2).useCount == 0) {
                ((TCPMessageChannel)object2).close();
            }
            if (!this.sipStack.cacheClientConnections && object != null && ((TLSMessageChannel)object).useCount == 0) {
                ((TLSMessageChannel)object).close();
            }
        }
        catch (Exception exception) {
            if (!LogWriter.needsLogging) throw new SipException("Cold not create message channel");
            this.sipStack.logWriter.logException(exception);
            throw new SipException("Cold not create message channel");
        }
        try {
            ++this.localSequenceNumber;
            sIPRequest.getCSeq().setSequenceNumber(this.getLocalSequenceNumber());
        }
        catch (InvalidArgumentException invalidArgumentException) {
            invalidArgumentException.printStackTrace();
        }
        if (this.isServer()) {
            object2 = (SIPServerTransaction)this.getFirstTransaction();
            try {
                if (this.myTag != null) {
                    ((From)parametersHeader).setTag(this.myTag);
                }
                if (this.hisTag != null) {
                    to.setTag(this.hisTag);
                }
            }
            catch (ParseException parseException) {
                throw new SipException(parseException.getMessage());
            }
            try {
                ((SIPClientTransaction)clientTransaction).sendMessage(sIPRequest);
                if (!sIPRequest.getMethod().equals("BYE")) return;
                this.setState(2);
                return;
            }
            catch (IOException iOException) {
                throw new SipException("error sending message");
            }
        }
        try {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("setting tags from " + this.getDialogId());
                this.sipStack.logWriter.logMessage("fromTag " + this.myTag);
                this.sipStack.logWriter.logMessage("toTag " + this.hisTag);
            }
            if (this.myTag != null) {
                ((From)parametersHeader).setTag(this.myTag);
            }
            if (this.hisTag != null) {
                to.setTag(this.hisTag);
            }
        }
        catch (ParseException parseException) {
            throw new SipException(parseException.getMessage());
        }
        try {
            ((SIPClientTransaction)clientTransaction).sendMessage(sIPRequest);
            if (!sIPRequest.getMethod().equalsIgnoreCase("BYE")) return;
            this.setState(2);
            return;
        }
        catch (IOException iOException) {
            if (!LogWriter.needsLogging) throw new SipException("error sending message");
            this.sipStack.logWriter.logException(iOException);
            throw new SipException("error sending message");
        }
    }

    protected boolean toRetransmitFinalResponse() {
        if (--this.retransmissionTicksLeft == 0) {
            this.prevRetransmissionTicks = this.retransmissionTicksLeft = 2 * this.prevRetransmissionTicks;
            return true;
        }
        return false;
    }

    protected void setRetransmissionTicks() {
        this.retransmissionTicksLeft = 1;
        this.prevRetransmissionTicks = 1;
    }

    public void resendAck() throws SipException {
        if (this.lastAck != null) {
            this.sendAck(this.lastAck);
        }
    }

    protected String getMethod() {
        return this.originalRequest.getMethod();
    }

    public boolean isInviteDialog() {
        return this.originalRequest.getMethod().equals("INVITE");
    }

    protected void startTimer(SIPServerTransaction sIPServerTransaction) {
        if (this.timerTask != null && this.timerTask.transaction == sIPServerTransaction) {
            this.sipStack.logMessage("Timer already running for " + this.getDialogId());
            return;
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logMessage("Starting dialog timer for " + this.getDialogId());
        }
        this.ackSeen = false;
        if (this.timerTask != null) {
            this.timerTask.transaction = sIPServerTransaction;
        } else {
            this.timerTask = new DialogTimerTask(this, sIPServerTransaction);
            this.sipStack.timer.schedule((TimerTask)this.timerTask, 500L, 500L);
        }
        this.setRetransmissionTicks();
    }

    protected void stopTimer() {
        try {
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearPending() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPending() {
        Hashtable hashtable = this.pendingRecords;
        synchronized (hashtable) {
            return this.nextSeqno != null && this.pendingRecords.containsKey(this.nextSeqno);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPending() {
        NistSipMessageHandlerImpl nistSipMessageHandlerImpl = null;
        Hashtable hashtable = this.pendingRecords;
        synchronized (hashtable) {
            nistSipMessageHandlerImpl = (NistSipMessageHandlerImpl)this.pendingRecords.remove(this.nextSeqno);
            if (this.pendingRecords.size() != 0) {
                this.sipStack.putPending(this);
            }
        }
        if (nistSipMessageHandlerImpl != null) {
            nistSipMessageHandlerImpl.processPending();
        }
    }

    public class DialogTimerTask
    extends TimerTask {
        SIPDialog dialog;
        SIPTransactionStack stack;
        SIPServerTransaction transaction;

        public DialogTimerTask(SIPDialog sIPDialog2, SIPServerTransaction sIPServerTransaction) {
            this.dialog = sIPDialog2;
            this.stack = sIPDialog2.sipStack;
            this.transaction = sIPServerTransaction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SIPResponse sIPResponse;
            if (LogWriter.needsLogging) {
                SIPDialog.this.sipStack.logMessage("Running dialog timer");
            }
            if (!this.dialog.ackSeen && (sIPResponse = this.transaction.getLastResponse()).getStatusCode() == 200) {
                try {
                    if (((SIPDialog)SIPDialog.this).sipStack.retransmissionFilter && this.dialog.toRetransmitFinalResponse()) {
                        this.transaction.sendMessage(sIPResponse);
                    }
                }
                catch (IOException iOException) {
                    this.dialog.setState(3);
                }
                finally {
                    this.transaction.fireTimer();
                }
            }
            if (this.dialog.isAckSeen() || this.dialog.dialogState == 3) {
                this.cancel();
                this.dialog.timerTask = null;
            }
        }
    }
}

