/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.Host;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.PendingRecord;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import java.io.IOException;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.TimerTask;
import javax.sip.DialogState;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.message.Response;

public class SIPServerTransaction
extends SIPTransaction
implements ServerRequestInterface,
ServerTransaction,
PendingRecord {
    protected boolean toListener;
    private LinkedList pendingRequests;
    private ServerRequestInterface requestOf;

    private void sendResponse(SIPResponse sIPResponse) throws IOException {
        if (this.isReliable()) {
            this.getMessageChannel().sendMessage(sIPResponse);
        } else {
            Via via = sIPResponse.getTopmostVia();
            String string = via.getTransport();
            if (string == null) {
                throw new IOException("missing transport!");
            }
            int n = via.getrport();
            if (n == -1) {
                n = via.getPort();
            }
            if (n == -1) {
                n = string.equalsIgnoreCase("TLS") ? 5061 : 5060;
            }
            Host host = via.getMaddr();
            String string2 = null;
            if (host != null) {
                string2 = host.getHostname();
            } else {
                string2 = via.getParameter("received");
                if (string2 == null) {
                    string2 = via.getHost();
                }
            }
            HopImpl hopImpl = new HopImpl(string2, n, string);
            MessageChannel messageChannel = ((SIPTransactionStack)this.getSIPStack()).createRawMessageChannel(this.getPort(), hopImpl);
            messageChannel.sendMessage(sIPResponse);
        }
    }

    protected SIPServerTransaction(SIPTransactionStack sIPTransactionStack, MessageChannel messageChannel) {
        super(sIPTransactionStack, messageChannel);
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Creating Server Transaction" + this);
            this.sipStack.logWriter.logStackTrace();
        }
        this.pendingRequests = new LinkedList();
    }

    public void setRequestInterface(ServerRequestInterface serverRequestInterface) {
        this.requestOf = serverRequestInterface;
    }

    public String getProcessingInfo() {
        return this.requestOf != null ? this.requestOf.getProcessingInfo() : null;
    }

    public MessageChannel getResponseChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage sIPMessage) {
        ViaList viaList;
        boolean bl = false;
        if ((((SIPRequest)sIPMessage).getMethod().equals("CANCEL") || ((SIPTransactionStack)this.getSIPStack()).isDialogCreated(((SIPRequest)sIPMessage).getMethod()) || !this.isTerminated()) && (viaList = sIPMessage.getViaHeaders()) != null) {
            Via via = (Via)viaList.getFirst();
            String string = via.getBranch();
            if (string != null && !string.startsWith("z9hG4bK")) {
                string = null;
            }
            if (string != null && this.getBranch() != null) {
                if (this.getBranch().equals(string) && via.getSentBy().equals(((Via)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy())) {
                    bl = true;
                }
            } else {
                boolean bl2;
                String string2 = this.fromTag;
                String string3 = sIPMessage.getFrom().getTag();
                boolean bl3 = string2 == null || string3 == null;
                String string4 = this.toTag;
                String string5 = sIPMessage.getTo().getTag();
                boolean bl4 = bl2 = string4 == null || string5 == null;
                if (this.getOriginalRequest().getRequestURI().equals(((SIPRequest)sIPMessage).getRequestURI()) && (bl3 || string2.equals(string3)) && (bl2 || string4.equals(string5)) && this.getOriginalRequest().getCallId().getCallId().equals(sIPMessage.getCallId().getCallId()) && this.getOriginalRequest().getCSeq().getSequenceNumber() == sIPMessage.getCSeq().getSequenceNumber() && via.equals(this.getOriginalRequest().getViaHeaders().getFirst())) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    protected void map() {
        if (this.getRealState() == null || this.getRealState() == TransactionState.TRYING) {
            if (this.isInviteTransaction() && !this.isMapped) {
                this.isMapped = true;
                this.sipStack.timer.schedule((TimerTask)new SendTrying(this), 200L);
            } else {
                this.isMapped = true;
            }
        }
        this.sipStack.removePendingTransaction(this);
    }

    public boolean isTransactionMapped() {
        return this.isMapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(SIPRequest sIPRequest, MessageChannel messageChannel) {
        block37: {
            boolean bl = false;
            if (this.eventPending) {
                LinkedList linkedList = this.pendingRequests;
                synchronized (linkedList) {
                    if (this.pendingRequests.size() < 4) {
                        this.pendingRequests.add(new PendingRequest(sIPRequest, messageChannel));
                    }
                }
                this.sipStack.putPending(this);
                return;
            }
            try {
                if (this.getRealState() == null) {
                    this.setOriginalRequest(sIPRequest);
                    this.setState(TransactionState.TRYING);
                    bl = true;
                    if (this.isInviteTransaction() && this.isMapped) {
                        this.sendMessage(sIPRequest.createResponse(100, "Trying"));
                    }
                } else {
                    if (this.isInviteTransaction() && TransactionState.COMPLETED == this.getRealState() && sIPRequest.getMethod().equals("ACK")) {
                        this.setState(TransactionState.CONFIRMED);
                        this.disableRetransmissionTimer();
                        if (!this.isReliable()) {
                            if (this.lastResponse != null && this.lastResponse.getStatusCode() == 487) {
                                this.setState(TransactionState.TERMINATED);
                            } else {
                                this.enableTimeoutTimer(10);
                            }
                        } else {
                            this.setState(TransactionState.TERMINATED);
                        }
                        return;
                    }
                    if (sIPRequest.getMethod().equals(this.getOriginalRequest().getMethod())) {
                        if (TransactionState.PROCEEDING == this.getRealState() || TransactionState.COMPLETED == this.getRealState()) {
                            if (this.lastResponse != null) {
                                try {
                                    super.sendMessage(this.lastResponse);
                                }
                                catch (IOException iOException) {
                                    this.setState(TransactionState.TERMINATED);
                                    throw iOException;
                                }
                            }
                        } else if (sIPRequest.getMethod().equals("ACK") && this.requestOf != null) {
                            this.requestOf.processRequest(sIPRequest, this);
                        }
                        return;
                    }
                }
                if (TransactionState.COMPLETED != this.getRealState() && TransactionState.TERMINATED != this.getRealState() && this.requestOf != null) {
                    if (this.getOriginalRequest().getMethod().equals(sIPRequest.getMethod())) {
                        if (bl) {
                            this.requestOf.processRequest(sIPRequest, this);
                        }
                    } else if (this.requestOf != null) {
                        this.requestOf.processRequest(sIPRequest, this);
                    }
                    break block37;
                }
                if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(this.getOriginalRequest().getMethod()) && this.getRealState() == TransactionState.TERMINATED && sIPRequest.getMethod().equals("ACK") && this.requestOf != null) {
                    SIPDialog sIPDialog = this.dialog;
                    sIPDialog.ackReceived(sIPRequest);
                    if (((SIPTransactionStack)this.getSIPStack()).retransmissionFilter) {
                        if (!sIPDialog.ackProcessed) {
                            sIPDialog.ackProcessed = true;
                            this.requestOf.processRequest(sIPRequest, this);
                        }
                    } else if (this.requestOf != null) {
                        this.requestOf.processRequest(sIPRequest, this);
                    }
                } else if (sIPRequest.getMethod().equals("CANCEL")) {
                    if (LogWriter.needsLogging) {
                        this.sipStack.logWriter.logMessage("Too late to cancel Transaction");
                    }
                    try {
                        this.sendMessage(sIPRequest.createResponse(200));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.sipStack.logWriter.logMessage("Dropping request " + this.getRealState());
            }
            catch (IOException iOException) {
                this.raiseErrorEvent(2);
            }
        }
    }

    public void sendMessage(SIPMessage sIPMessage) throws IOException {
        SIPResponse sIPResponse = (SIPResponse)sIPMessage;
        int n = sIPResponse.getStatusCode();
        SIPDialog sIPDialog = this.dialog;
        try {
            if (this.getOriginalRequest().getTopmostVia().getBranch() != null) {
                sIPResponse.getTopmostVia().setBranch(this.getBranch());
            } else {
                sIPResponse.getTopmostVia().removeParameter("branch");
            }
            if (!this.getOriginalRequest().getTopmostVia().hasPort()) {
                sIPResponse.getTopmostVia().removePort();
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        if (!sIPResponse.getCSeq().getMethod().equals(this.getOriginalRequest().getMethod())) {
            this.sendResponse(sIPResponse);
            return;
        }
        if (this.dialog != null) {
            if (this.dialog.getRemoteTag() == null && sIPResponse.getTo().getTag() != null && ((SIPTransactionStack)this.getSIPStack()).isDialogCreated(sIPResponse.getCSeq().getMethod())) {
                this.dialog.setRemoteTag(sIPResponse.getTo().getTag());
                ((SIPTransactionStack)this.getSIPStack()).putDialog(this.dialog);
                if (n / 100 == 1) {
                    this.dialog.setState(0);
                }
            }
            if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(sIPResponse.getCSeq().getMethod()) && sIPResponse.getCSeq().getMethod().equals(this.getOriginalRequest().getMethod())) {
                if (n / 100 == 2) {
                    if (!this.isInviteTransaction()) {
                        this.dialog.setState(1);
                    } else if (this.dialog.getState() == null) {
                        this.dialog.setState(0);
                    }
                } else if (n >= 300 && n <= 699 && (this.dialog.getState() == null || this.dialog.getState().equals(DialogState.EARLY))) {
                    this.dialog.setState(3);
                }
            } else if (sIPResponse.getCSeq().getMethod().equals("BYE") && n / 100 == 2 && sIPDialog != null) {
                if (!this.isReliable()) {
                    this.dialog.setState(2);
                } else {
                    this.dialog.setState(3);
                }
            }
        }
        if (this.getRealState() == TransactionState.TRYING) {
            if (n / 100 == 1) {
                this.setState(TransactionState.PROCEEDING);
            } else if (200 <= n && n <= 699) {
                if (!this.isInviteTransaction()) {
                    this.setState(TransactionState.COMPLETED);
                } else if (n / 100 == 2) {
                    this.setState(TransactionState.TERMINATED);
                } else {
                    this.setState(TransactionState.COMPLETED);
                }
                if (!this.isReliable()) {
                    this.enableRetransmissionTimer();
                }
                this.enableTimeoutTimer(64);
            }
        } else if (this.getRealState() == TransactionState.PROCEEDING) {
            if (this.isInviteTransaction()) {
                if (n / 100 == 2) {
                    if (!sIPResponse.getCSeq().getMethod().equals("CANCEL")) {
                        this.collectionTime = 64;
                        this.setState(TransactionState.TERMINATED);
                        if (!this.isReliable()) {
                            if (this.dialog != null) {
                                this.dialog.setRetransmissionTicks();
                            }
                            this.enableRetransmissionTimer();
                        }
                        this.enableTimeoutTimer(64);
                    }
                } else if (300 <= n && n <= 699) {
                    this.setState(TransactionState.COMPLETED);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.enableTimeoutTimer(64);
                } else if (n / 100 == 2) {
                    this.setState(TransactionState.TERMINATED);
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                }
            } else if (200 <= n && n <= 699) {
                this.setState(TransactionState.COMPLETED);
                if (!this.isReliable()) {
                    this.disableRetransmissionTimer();
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.COMPLETED == this.getRealState()) {
            return;
        }
        try {
            this.lastResponse = sIPResponse;
            this.sendResponse(sIPResponse);
        }
        catch (IOException iOException) {
            this.setState(TransactionState.TERMINATED);
            this.collectionTime = 0;
            throw iOException;
        }
    }

    public String getViaHost() {
        return this.encapsulatedChannel.getViaHost();
    }

    public int getViaPort() {
        return this.encapsulatedChannel.getViaPort();
    }

    protected void fireRetransmissionTimer() {
        try {
            if (this.isInviteTransaction()) {
                if (((SIPTransactionStack)this.getSIPStack()).retransmissionFilter) {
                    super.sendMessage(this.lastResponse);
                } else {
                    this.raiseErrorEvent(3);
                }
            }
        }
        catch (IOException iOException) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logException(iOException);
            }
            this.raiseErrorEvent(2);
        }
    }

    protected void fireTimeoutTimer() {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("SIPServerTransaction.fireTimeoutTimer " + this.getRealState() + " method = " + this.getOriginalRequest().getMethod());
        }
        SIPDialog sIPDialog = this.dialog;
        if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(this.getOriginalRequest().getMethod()) && (TransactionState.CALLING == this.getRealState() || TransactionState.TRYING == this.getRealState())) {
            sIPDialog.setState(3);
        } else if (this.getOriginalRequest().getMethod().equals("BYE") && sIPDialog != null) {
            sIPDialog.setState(3);
        }
        if (TransactionState.COMPLETED == this.getRealState() && this.isInviteTransaction()) {
            this.raiseErrorEvent(1);
            this.setState(TransactionState.TERMINATED);
        } else if (TransactionState.CONFIRMED == this.getRealState() && this.isInviteTransaction()) {
            this.setState(TransactionState.TERMINATED);
        } else if (!(this.isInviteTransaction() || TransactionState.COMPLETED != this.getRealState() && TransactionState.CONFIRMED != this.getRealState())) {
            this.setState(TransactionState.TERMINATED);
        } else if (this.isInviteTransaction() && TransactionState.TERMINATED == this.getRealState()) {
            this.raiseErrorEvent(1);
            if (sIPDialog != null) {
                sIPDialog.setState(3);
            }
        }
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    public void setOriginalRequest(SIPRequest sIPRequest) {
        super.setOriginalRequest(sIPRequest);
        if (sIPRequest.getMethod().equals("ACK")) {
            this.setState(TransactionState.TERMINATED);
        }
    }

    public void sendResponse(Response response) throws SipException {
        SIPDialog sIPDialog = this.dialog;
        try {
            String string;
            SIPResponse sIPResponse = (SIPResponse)response;
            if (sIPDialog != null && sIPResponse.getStatusCode() == 200 && this.sipStack.isDialogCreated(sIPResponse.getCSeq().getMethod()) && sIPDialog.getLocalTag() == null && sIPResponse.getTo().getTag() == null) {
                throw new SipException("To tag must be set for OK");
            }
            if (sIPResponse.getStatusCode() == 200 && sIPResponse.getCSeq().getMethod().equals("INVITE") && sIPResponse.getHeader("Contact") == null) {
                throw new SipException("Contact Header is mandatory for the OK");
            }
            if (sIPDialog != null && sIPDialog.getLocalTag() != null) {
                sIPResponse.getTo().setTag(sIPDialog.getLocalTag());
            }
            if ((string = ((SIPRequest)this.getRequest()).getFrom().getTag()) != null) {
                sIPResponse.getFrom().setTag(string);
            } else if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("WARNING -- Null From tag  Dialog layer in jeopardy!!");
            }
            this.sendMessage((SIPResponse)response);
            if (sIPDialog != null) {
                if (sIPResponse.getCSeq().getMethod().equalsIgnoreCase("CANCEL") && sIPResponse.getStatusCode() == 200 && !sIPDialog.isReInvite() && this.sipStack.isDialogCreated(this.getOriginalRequest().getMethod()) && (sIPDialog.getState() == null || sIPDialog.getState().getValue() == 0)) {
                    sIPDialog.setState(3);
                } else if (sIPResponse.getCSeq().getMethod().equals("BYE") && sIPResponse.getStatusCode() == 200) {
                    sIPDialog.setState(3);
                } else if (sIPResponse.getCSeq().getMethod().equalsIgnoreCase("CANCEL")) {
                    if (sIPDialog.getState() == null || sIPDialog.getState().getValue() == 0) {
                        sIPDialog.setState(3);
                    }
                } else if (sIPDialog.getLocalTag() == null && sIPResponse.getTo().getTag() != null) {
                    if (sIPResponse.getStatusCode() != 100) {
                        sIPDialog.setLocalTag(sIPResponse.getTo().getTag());
                    }
                    if (this.sipStack.isDialogCreated(sIPResponse.getCSeq().getMethod())) {
                        if (response.getStatusCode() / 100 == 1) {
                            sIPDialog.setState(0);
                            if (sIPResponse.getStatusCode() != 100) {
                                this.sipStack.putDialog(sIPDialog);
                            }
                        } else if (sIPResponse.getStatusCode() / 100 <= 2) {
                            this.sipStack.putDialog(sIPDialog);
                        } else {
                            sIPDialog.setState(3);
                        }
                        if (sIPResponse.getStatusCode() / 100 == 2) {
                            if (sIPResponse.getCSeq().getMethod().equals("INVITE")) {
                                if (sIPDialog.getState() == null) {
                                    sIPDialog.setState(0);
                                }
                                sIPDialog.startTimer(this);
                            } else {
                                sIPDialog.setState(1);
                            }
                        }
                    }
                } else if (response.getStatusCode() / 100 == 2 && this.sipStack.isDialogCreated(sIPResponse.getCSeq().getMethod())) {
                    if (!sIPResponse.getCSeq().getMethod().equals("INVITE")) {
                        sIPDialog.setState(1);
                    } else {
                        if (this.dialog.getState() == null) {
                            this.dialog.setState(0);
                        }
                        this.dialog.startTimer(this);
                    }
                    this.sipStack.putDialog(sIPDialog);
                }
            }
        }
        catch (IOException iOException) {
            throw new SipException(iOException.getMessage());
        }
        catch (ParseException parseException) {
            throw new SipException(parseException.getMessage());
        }
    }

    private TransactionState getRealState() {
        return super.getState();
    }

    public TransactionState getState() {
        if (this.isInviteTransaction() && TransactionState.TRYING == super.getState()) {
            return TransactionState.PROCEEDING;
        }
        return super.getState();
    }

    public void setState(TransactionState transactionState) {
        if (transactionState == TransactionState.TERMINATED && this.isReliable() && !this.getSIPStack().cacheServerConnections) {
            this.collectionTime = 64;
        }
        super.setState(transactionState);
    }

    public boolean passToListener() {
        return this.toListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPending() {
        PendingRequest pendingRequest;
        LinkedList linkedList = this.pendingRequests;
        synchronized (linkedList) {
            if (this.pendingRequests.isEmpty()) {
                return;
            }
            pendingRequest = (PendingRequest)this.pendingRequests.removeFirst();
        }
        this.processRequest(pendingRequest.sipRequest, pendingRequest.messageChannel);
        this.eventPending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPending() {
        LinkedList linkedList = this.pendingRequests;
        synchronized (linkedList) {
            return !this.pendingRequests.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPending() {
        boolean bl = false;
        LinkedList linkedList = this.pendingRequests;
        synchronized (linkedList) {
            super.clearPending();
            if (this.isTerminated() || !this.pendingRequests.isEmpty()) {
                bl = true;
            }
        }
        if (bl) {
            this.sipStack.notifyPendingRecordScanner();
        }
    }

    protected void startTransactionTimer() {
        this.myTimer = new TransactionTimer(this);
        this.sipStack.timer.schedule(this.myTimer, 0L, 500L);
    }

    public boolean equals(Object object) {
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)object;
        return this.getBranch().equalsIgnoreCase(sIPServerTransaction.getBranch());
    }

    class TransactionTimer
    extends TimerTask {
        SIPServerTransaction myTransaction;
        SIPTransactionStack sipStack;

        public TransactionTimer(SIPServerTransaction sIPServerTransaction2) {
            this.myTransaction = sIPServerTransaction2;
            this.sipStack = sIPServerTransaction2.sipStack;
        }

        public void run() {
            if (this.myTransaction.isTerminated()) {
                block4: {
                    try {
                        this.cancel();
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (this.sipStack.isAlive()) break block4;
                        return;
                    }
                }
                this.myTransaction.myTimer = new SIPTransaction.LingerTimer(SIPServerTransaction.this, this.myTransaction);
                this.sipStack.timer.schedule(SIPServerTransaction.this.myTimer, 32000L);
            } else {
                SIPServerTransaction.this.fireTimer();
            }
        }
    }

    class SendTrying
    extends TimerTask {
        private SIPServerTransaction serverTransaction;

        protected SendTrying(SIPServerTransaction sIPServerTransaction2) {
            if (LogWriter.needsLogging) {
                SIPServerTransaction.this.sipStack.logWriter.logMessage("scheduled timer for " + sIPServerTransaction2);
            }
            this.serverTransaction = sIPServerTransaction2;
        }

        public void run() {
            block5: {
                if (this.serverTransaction.getRealState() == null || TransactionState.TRYING == this.serverTransaction.getRealState()) {
                    if (LogWriter.needsLogging) {
                        SIPServerTransaction.this.sipStack.logWriter.logMessage(" sending Trying current state = " + this.serverTransaction.getRealState());
                    }
                    try {
                        this.serverTransaction.sendMessage(this.serverTransaction.getOriginalRequest().createResponse(100, "Trying"));
                        if (LogWriter.needsLogging) {
                            SIPServerTransaction.this.sipStack.logWriter.logMessage(" trying sent " + this.serverTransaction.getRealState());
                        }
                    }
                    catch (IOException iOException) {
                        if (!LogWriter.needsLogging) break block5;
                        SIPServerTransaction.this.sipStack.logWriter.logMessage("IO error sending  TRYING");
                    }
                }
            }
        }
    }

    class PendingRequest {
        protected SIPRequest sipRequest;
        protected MessageChannel messageChannel;

        public PendingRequest(SIPRequest sIPRequest, MessageChannel messageChannel) {
            this.sipRequest = sIPRequest;
            this.messageChannel = messageChannel;
        }
    }
}

