/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.PipelinedMsgParser;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TCPMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.ParseException;

public final class TCPMessageChannel
extends MessageChannel
implements SIPMessageListener,
Runnable {
    private Socket mySock;
    private PipelinedMsgParser myParser;
    private InputStream myClientInputStream;
    private OutputStream myClientOutputStream;
    private String key;
    protected boolean isCached;
    protected boolean isRunning;
    private Thread mythread;
    private SIPMessageStack stack;
    private String myAddress;
    private int myPort;
    private InetAddress peerAddress;
    private int peerPort;
    private String peerProtocol;
    protected int useCount;
    private TCPMessageProcessor tcpMessageProcessor;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$From;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$To;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$CSeq;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$Via;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$CallID;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$RequestLine;
    static /* synthetic */ Class class$gov$nist$javax$sip$header$StatusLine;

    protected TCPMessageChannel(Socket socket, SIPMessageStack sIPMessageStack, TCPMessageProcessor tCPMessageProcessor) throws IOException {
        if (LogWriter.needsLogging) {
            sIPMessageStack.logWriter.logMessage("creating new TCPMessageChannel ");
            sIPMessageStack.logWriter.logStackTrace();
        }
        this.mySock = socket;
        this.peerAddress = this.mySock.getInetAddress();
        this.myAddress = sIPMessageStack.getHostAddress();
        this.myClientInputStream = this.mySock.getInputStream();
        this.myClientOutputStream = this.mySock.getOutputStream();
        this.mythread = new Thread(this);
        this.mythread.setDaemon(true);
        this.mythread.setName("TCPMessageChannelThread");
        this.stack = sIPMessageStack;
        this.tcpMessageProcessor = tCPMessageProcessor;
        this.myPort = this.tcpMessageProcessor.getPort();
        this.messageProcessor = tCPMessageProcessor;
        this.mythread.start();
    }

    protected TCPMessageChannel(InetAddress inetAddress, int n, SIPMessageStack sIPMessageStack, TCPMessageProcessor tCPMessageProcessor) throws IOException {
        if (LogWriter.needsLogging) {
            sIPMessageStack.logWriter.logMessage("creating new TCPMessageChannel ");
            sIPMessageStack.logWriter.logStackTrace();
        }
        this.peerAddress = inetAddress;
        this.peerPort = n;
        this.myPort = tCPMessageProcessor.getPort();
        this.peerProtocol = "TCP";
        this.stack = sIPMessageStack;
        this.tcpMessageProcessor = tCPMessageProcessor;
        this.myAddress = sIPMessageStack.getHostAddress();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
        this.messageProcessor = tCPMessageProcessor;
    }

    public boolean isReliable() {
        return true;
    }

    public void close() {
        block4: {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("Closing message Channel " + this);
                }
            }
            catch (IOException iOException) {
                if (!LogWriter.needsLogging) break block4;
                this.stack.logWriter.logMessage("Error closing socket " + iOException);
            }
        }
    }

    public SIPMessageStack getSIPStack() {
        return this.stack;
    }

    public String getTransport() {
        return "TCP";
    }

    public String getPeerAddress() {
        if (this.peerAddress != null) {
            return this.peerAddress.getHostAddress();
        }
        return this.getHost();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    private void sendMessage(byte[] byArray, boolean bl) throws IOException {
        Socket socket = this.stack.ioHandler.sendBytes(this.peerAddress, this.peerPort, this.peerProtocol, byArray, bl);
        if (socket != this.mySock && socket != null) {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySock = socket;
            this.myClientInputStream = this.mySock.getInputStream();
            this.myClientOutputStream = this.mySock.getOutputStream();
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("TCPMessageChannelThread");
            thread.start();
        }
    }

    public void sendMessage(SIPMessage sIPMessage) throws IOException {
        byte[] byArray = sIPMessage.encodeAsBytes();
        long l = System.currentTimeMillis();
        this.sendMessage(byArray, sIPMessage instanceof SIPRequest);
        if (this.stack.serverLog.needsLogging(16)) {
            this.logMessage(sIPMessage, this.peerAddress, this.peerPort, l);
        }
    }

    public void sendMessage(byte[] byArray, InetAddress inetAddress, int n, boolean bl) throws IOException {
        if (byArray == null || inetAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        Socket socket = this.stack.ioHandler.sendBytes(inetAddress, n, "TCP", byArray, bl);
        if (socket != this.mySock && socket != null) {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySock = socket;
            this.myClientInputStream = this.mySock.getInputStream();
            this.myClientOutputStream = this.mySock.getOutputStream();
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("TCPMessageChannelThread");
            thread.start();
        }
    }

    public void handleException(ParseException parseException, SIPMessage sIPMessage, Class clazz, String string, String string2) throws ParseException {
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logException(parseException);
        }
        if (clazz != null && (clazz.equals(class$gov$nist$javax$sip$header$From == null ? (class$gov$nist$javax$sip$header$From = TCPMessageChannel.class$("gov.nist.javax.sip.header.From")) : class$gov$nist$javax$sip$header$From) || clazz.equals(class$gov$nist$javax$sip$header$To == null ? (class$gov$nist$javax$sip$header$To = TCPMessageChannel.class$("gov.nist.javax.sip.header.To")) : class$gov$nist$javax$sip$header$To) || clazz.equals(class$gov$nist$javax$sip$header$CSeq == null ? (class$gov$nist$javax$sip$header$CSeq = TCPMessageChannel.class$("gov.nist.javax.sip.header.CSeq")) : class$gov$nist$javax$sip$header$CSeq) || clazz.equals(class$gov$nist$javax$sip$header$Via == null ? (class$gov$nist$javax$sip$header$Via = TCPMessageChannel.class$("gov.nist.javax.sip.header.Via")) : class$gov$nist$javax$sip$header$Via) || clazz.equals(class$gov$nist$javax$sip$header$CallID == null ? (class$gov$nist$javax$sip$header$CallID = TCPMessageChannel.class$("gov.nist.javax.sip.header.CallID")) : class$gov$nist$javax$sip$header$CallID) || clazz.equals(class$gov$nist$javax$sip$header$RequestLine == null ? (class$gov$nist$javax$sip$header$RequestLine = TCPMessageChannel.class$("gov.nist.javax.sip.header.RequestLine")) : class$gov$nist$javax$sip$header$RequestLine) || clazz.equals(class$gov$nist$javax$sip$header$StatusLine == null ? (class$gov$nist$javax$sip$header$StatusLine = TCPMessageChannel.class$("gov.nist.javax.sip.header.StatusLine")) : class$gov$nist$javax$sip$header$StatusLine))) {
            this.stack.logBadMessage(string2);
            throw parseException;
        }
        sIPMessage.addUnparsed(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(SIPMessage sIPMessage) throws Exception {
        if (sIPMessage.getFrom() == null || sIPMessage.getTo() == null || sIPMessage.getCallId() == null || sIPMessage.getCSeq() == null || sIPMessage.getViaHeaders() == null) {
            String string = sIPMessage.encode();
            if (LogWriter.needsLogging) {
                this.stack.logWriter.logMessage("bad message " + string);
                this.stack.logWriter.logMessage(">>> Dropped Bad Msg");
            }
            this.stack.logBadMessage(string);
            return;
        }
        ViaList viaList = sIPMessage.getViaHeaders();
        if (sIPMessage instanceof SIPRequest) {
            Via via = (Via)viaList.first();
            this.peerPort = via.hasPort() ? via.getPort() : 5060;
            this.peerProtocol = via.getTransport();
            try {
                this.peerAddress = this.mySock.getInetAddress();
                if (!via.getSentBy().getInetAddress().equals(this.peerAddress)) {
                    via.setParameter("received", this.peerAddress.getHostAddress());
                }
                via.setParameter("rport", new Integer(this.peerPort).toString());
            }
            catch (UnknownHostException unknownHostException) {
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("Rejecting message -- could not resolve Via Address");
                }
                return;
            }
            catch (ParseException parseException) {
                InternalErrorHandler.handleException(parseException);
            }
            if (!this.isCached) {
                ((TCPMessageProcessor)this.messageProcessor).cacheMessageChannel(this);
                this.isCached = true;
                String string = IOHandler.makeKey(this.mySock.getInetAddress(), this.peerPort);
                this.stack.ioHandler.putSocket(string, this.mySock);
            }
        }
        long l = System.currentTimeMillis();
        if (sIPMessage instanceof SIPRequest) {
            SIPRequest sIPRequest = (SIPRequest)sIPMessage;
            if (LogWriter.needsLogging) {
                this.stack.logWriter.logMessage("----Processing Message---");
            }
            if (this.stack.getMaxMessageSize() > 0 && sIPRequest.getSize() + (sIPRequest.getContentLength() == null ? 0 : sIPRequest.getContentLength().getContentLength()) > this.stack.getMaxMessageSize()) {
                SIPResponse sIPResponse = sIPRequest.createResponse(513);
                byte[] byArray = sIPResponse.encodeAsBytes();
                this.sendMessage(byArray, false);
                throw new Exception("Message size exceeded");
            }
            ServerRequestInterface serverRequestInterface = this.stack.newSIPServerRequest(sIPRequest, this);
            serverRequestInterface.processRequest(sIPRequest, this);
            if (this.stack.serverLog.needsLogging(16)) {
                if (serverRequestInterface.getProcessingInfo() == null) {
                    this.stack.serverLog.logMessage(sIPMessage, sIPRequest.getViaHost() + ":" + sIPRequest.getViaPort(), this.stack.getHostAddress() + ":" + this.stack.getPort(this.getTransport()), false, l);
                } else {
                    this.stack.serverLog.logMessage(sIPMessage, sIPRequest.getViaHost() + ":" + sIPRequest.getViaPort(), this.stack.getHostAddress() + ":" + this.stack.getPort(this.getTransport()), serverRequestInterface.getProcessingInfo(), false, l);
                }
            }
        } else {
            SIPResponse sIPResponse = (SIPResponse)sIPMessage;
            if (this.stack.getMaxMessageSize() > 0 && sIPResponse.getSize() + (sIPResponse.getContentLength() == null ? 0 : sIPResponse.getContentLength().getContentLength()) > this.stack.getMaxMessageSize()) {
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("Message size exceeded");
                }
                return;
            }
            ServerResponseInterface serverResponseInterface = this.stack.newSIPServerResponse(sIPResponse, this);
            serverResponseInterface.processResponse(sIPResponse, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Pipeline pipeline = null;
        pipeline = new Pipeline(this.myClientInputStream, this.stack.readTimeout, ((SIPTransactionStack)this.stack).timer);
        this.myParser = new PipelinedMsgParser(this, pipeline, this.stack.getMaxMessageSize());
        this.myParser.processInput();
        int n = 4096;
        ++this.tcpMessageProcessor.useCount;
        this.isRunning = true;
        try {
            while (true) {
                int n2;
                byte[] byArray;
                try {
                    byArray = new byte[n];
                    n2 = this.myClientInputStream.read(byArray, 0, n);
                    if (n2 == -1) {
                        pipeline.write("\r\n\r\n".getBytes("UTF-8"));
                        try {
                            if (this.stack.maxConnections != -1) {
                                TCPMessageProcessor tCPMessageProcessor = this.tcpMessageProcessor;
                                synchronized (tCPMessageProcessor) {
                                    --this.tcpMessageProcessor.nConnections;
                                    this.tcpMessageProcessor.notify();
                                }
                            }
                            pipeline.close();
                            this.mySock.close();
                        }
                        catch (IOException iOException) {
                        }
                        Object var10_13 = null;
                        this.isRunning = false;
                        this.tcpMessageProcessor.remove(this);
                        --this.tcpMessageProcessor.useCount;
                        return;
                    }
                }
                catch (IOException iOException) {
                    try {
                        pipeline.write("\r\n\r\n".getBytes("UTF-8"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (LogWriter.needsLogging) {
                            this.stack.logWriter.logMessage("IOException  closing sock " + iOException);
                        }
                        try {
                            if (this.stack.maxConnections != -1) {
                                TCPMessageProcessor tCPMessageProcessor = this.tcpMessageProcessor;
                                synchronized (tCPMessageProcessor) {
                                    --this.tcpMessageProcessor.nConnections;
                                    this.tcpMessageProcessor.notify();
                                }
                            }
                            this.mySock.close();
                            pipeline.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    catch (Exception exception) {
                    }
                    Object var10_14 = null;
                    this.isRunning = false;
                    this.tcpMessageProcessor.remove(this);
                    --this.tcpMessageProcessor.useCount;
                    return;
                }
                catch (Exception exception) {
                    InternalErrorHandler.handleException(exception);
                    continue;
                }
                {
                    pipeline.write(byArray, 0, n2);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.isRunning = false;
            this.tcpMessageProcessor.remove(this);
            --this.tcpMessageProcessor.useCount;
            throw throwable;
        }
    }

    protected void uncache() {
        this.tcpMessageProcessor.remove(this);
    }

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        TCPMessageChannel tCPMessageChannel = (TCPMessageChannel)object;
        return this.mySock == tCPMessageChannel.mySock;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
        return this.key;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getPeerPacketSourcePort() {
        return this.peerPort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerAddress;
    }

    public boolean isSecure() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

